/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ISARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScopeRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermCategorizationRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermISATypeOFRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermTYPEDBYRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRelationshipRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/subject-area"})
public class SubjectAreaRelationshipRESTResource
extends SubjectAreaRESTServicesInstance {
    private SubjectAreaRelationshipRESTServices restAPI = new SubjectAreaRelationshipRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/has-as"})
    public SubjectAreaOMASAPIResponse createTermHASARelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody TermHASARelationship termHASARelationship) {
        return this.restAPI.createTermHASARelationship(serverName, userId, termHASARelationship);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse getTermHASARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermHASARelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/has-as"})
    public SubjectAreaOMASAPIResponse updateTermHASARelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody TermHASARelationship termHASARelationship, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTermHASARelationship(serverName, userId, termHASARelationship, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermHASARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteTermHASARelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermHASARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermHASARelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/related-terms"})
    public SubjectAreaOMASAPIResponse createRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody RelatedTerm relatedTermRelationshipRelationship) {
        return this.restAPI.createRelatedTerm(serverName, userId, relatedTermRelationshipRelationship);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse getRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getRelatedTerm(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/related-terms"})
    public SubjectAreaOMASAPIResponse updateRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody RelatedTerm relatedTermRelationship, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateRelatedTerm(serverName, userId, relatedTermRelationship, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteRelatedTerm(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreRelatedTerm(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/synonyms"})
    public SubjectAreaOMASAPIResponse createSynonym(@PathVariable String serverName, @PathVariable String userId, @RequestBody Synonym synonym) {
        return this.restAPI.createSynonym(serverName, userId, synonym);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse getSynonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getSynonymRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/synonyms"})
    public SubjectAreaOMASAPIResponse updateSynonymRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody Synonym synonym, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateSynonymRelationship(serverName, userId, synonym, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteSynonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteSynonymRelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreSynonym(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreSynonym(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/antonyms"})
    public SubjectAreaOMASAPIResponse createAntonym(@PathVariable String serverName, @PathVariable String userId, @RequestBody Antonym antonym) {
        return this.restAPI.createAntonym(serverName, userId, antonym);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse getAntonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getAntonymRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/antonyms"})
    public SubjectAreaOMASAPIResponse updateAntonymRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody Antonym antonym, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateAntonymRelationship(serverName, userId, antonym, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteAntonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteAntonymRelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreAntonym(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreAntonym(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/translations"})
    public SubjectAreaOMASAPIResponse createTranslation(@PathVariable String serverName, @PathVariable String userId, @RequestBody Translation translation) {
        return this.restAPI.createTranslation(serverName, userId, translation);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/translations/{guid}"})
    public SubjectAreaOMASAPIResponse getTranslationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTranslationRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/translations"})
    public SubjectAreaOMASAPIResponse updateTranslationRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody Translation translation, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTranslationRelationship(serverName, userId, translation, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/translations/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTranslationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteTranslationRelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/translations/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTranslation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTranslation(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/used-in-contexts"})
    public SubjectAreaOMASAPIResponse createusedInContext(@PathVariable String serverName, @PathVariable String userId, @RequestBody UsedInContext usedInContext) {
        return this.restAPI.createUsedInContext(serverName, userId, usedInContext);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse getUsedInContextRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getUsedInContextRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/used-in-contexts"})
    public SubjectAreaOMASAPIResponse updateUsedInContextRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody UsedInContext usedInContext, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateUsedInContextRelationship(serverName, userId, usedInContext, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse deleteUsedInContextRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteUsedInContextRelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse restoreUsedInContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreUsedInContext(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/preferred-terms"})
    public SubjectAreaOMASAPIResponse createpreferredTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody PreferredTerm preferredTerm) {
        return this.restAPI.createPreferredTerm(serverName, userId, preferredTerm);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse getPreferredTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getPreferredTermRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/preferred-terms"})
    public SubjectAreaOMASAPIResponse updatePreferredTermRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody PreferredTerm preferredTerm, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updatePreferredTermRelationship(serverName, userId, preferredTerm, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse deletePreferredTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deletePreferredTermRelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse restorePreferredTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restorePreferredTerm(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/valid-values"})
    public SubjectAreaOMASAPIResponse createvalidValue(@PathVariable String serverName, @PathVariable String userId, @RequestBody ValidValue validValue) {
        return this.restAPI.createValidValue(serverName, userId, validValue);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse getValidValueRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getValidValueRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/valid-values"})
    public SubjectAreaOMASAPIResponse updateValidValueRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody ValidValue validValue, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateValidValueRelationship(serverName, userId, validValue, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse deleteValidValueRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteValidValueRelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse restoreValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreValidValue(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/replacement-terms"})
    public SubjectAreaOMASAPIResponse createreplacementTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReplacementTerm replacementTerm) {
        return this.restAPI.createReplacementTerm(serverName, userId, replacementTerm);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse getReplacementTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getReplacementTerm(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/replacement-terms"})
    public SubjectAreaOMASAPIResponse updateReplacementTermRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReplacementTerm replacementTerm, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateReplacementTerm(serverName, userId, replacementTerm, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteReplacementTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteReplacementTerm(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreReplacementTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreReplacementTerm(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/typed-bys"})
    public SubjectAreaOMASAPIResponse createtermTYPEDBYRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody TermTYPEDBYRelationship termTYPEDBYRelationship) {
        return this.restAPI.createTermTYPEDBYRelationship(serverName, userId, termTYPEDBYRelationship);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse getTYPEDBYRelationshipRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermTYPEDBYRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/typed-bys"})
    public SubjectAreaOMASAPIResponse updateTermTYPEDBYRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody TermTYPEDBYRelationship termTYPEDBYRelationship, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTermTYPEDBYRelationship(serverName, userId, termTYPEDBYRelationship, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTypedByRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteTermTYPEDBYRelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermTYPEDBYRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermTYPEDBYRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/is-as"})
    public SubjectAreaOMASAPIResponse createiSARelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody ISARelationship iSARelationship) {
        return this.restAPI.createISARelationship(serverName, userId, iSARelationship);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse getISARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getISARelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/is-as"})
    public SubjectAreaOMASAPIResponse updateISARelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody ISARelationship isa, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateISARelationship(serverName, userId, isa, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermISARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteISARelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse restoreIsaRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreISARelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/is-a-type-ofs"})
    public SubjectAreaOMASAPIResponse createtermISATypeOFRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody TermISATypeOFRelationship termISATypeOFRelationship) {
        return this.restAPI.createTermISATypeOFRelationship(serverName, userId, termISATypeOFRelationship);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse getTermISATypeOFRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermISATypeOFRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/is-a-type-ofs"})
    public SubjectAreaOMASAPIResponse updateISARelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody TermISATypeOFRelationship isatypeof, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTermISATypeOFRelationship(serverName, userId, isatypeof, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermIsaTypeOfRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteIsATypeOfRelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermIsaTypeOfRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermISATypeOFRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/term-categorizations"})
    public SubjectAreaOMASAPIResponse createTermCategorization(@PathVariable String serverName, @PathVariable String userId, @RequestBody TermCategorizationRelationship termCategorizationRelationship) {
        return this.restAPI.createTermCategorizationRelationship(serverName, userId, termCategorizationRelationship);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse getTermCategorizationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermCategorizationRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/term-categorizations"})
    public SubjectAreaOMASAPIResponse updateTermCategorizationRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody TermCategorizationRelationship isatypeof, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTermCategorizationRelationship(serverName, userId, isatypeof, isReplace);
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermCategorizationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteTermCategorizationRelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermCategorizationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermCategorizationRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/term-anchor"})
    public SubjectAreaOMASAPIResponse createTermAnchor(@PathVariable String serverName, @PathVariable String userId, @RequestBody TermAnchorRelationship termAnchorRelationship) {
        return this.restAPI.createTermAnchorRelationship(serverName, userId, termAnchorRelationship);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/term-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse getTermAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermAnchorRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/term-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        return this.restAPI.deleteTermAnchorRelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/term-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermAnchorRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/category-anchor"})
    public SubjectAreaOMASAPIResponse createCategoryAnchor(@PathVariable String serverName, @PathVariable String userId, @RequestBody CategoryAnchorRelationship categoryAnchorRelationship) {
        return this.restAPI.createCategoryAnchorRelationship(serverName, userId, categoryAnchorRelationship);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/category-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse getCategoryAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getCategoryAnchorRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/category-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse deleteCategoryAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        return this.restAPI.deleteCategoryAnchorRelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/category-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse restoreCategoryAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreCategoryAnchorRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/project-scopes"})
    public SubjectAreaOMASAPIResponse createProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody ProjectScopeRelationship projectScope) {
        return this.restAPI.createProjectScopeRelationship(serverName, userId, projectScope);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse getProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getProjectScopeRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/relationships/project-scopes"})
    public SubjectAreaOMASAPIResponse updateProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody ProjectScopeRelationship projectScope, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateProjectScopeRelationship(serverName, userId, projectScope, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/relationships/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse deleteProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteProjectScopeRelationship(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/relationships/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse restoreProjectScoperRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreProjectScopeRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/relationships/semantic-assignments/{guid}"})
    public SubjectAreaOMASAPIResponse getSemanticAssignmentRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getSemanticAssignmentRelationship(serverName, userId, guid);
    }
}

