/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaTermRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/subject-area"})
public class SubjectAreaTermRESTResource
extends SubjectAreaRESTServicesInstance {
    private SubjectAreaTermRESTServices restAPI = new SubjectAreaTermRESTServices();

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/terms"})
    public SubjectAreaOMASAPIResponse createTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody Term suppliedTerm) {
        return this.restAPI.createTerm(serverName, userId, suppliedTerm);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/terms/{guid}"})
    public SubjectAreaOMASAPIResponse getTermByGuid(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermByGuid(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/terms"})
    public SubjectAreaOMASAPIResponse findTerm(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findTerm(serverName, userId, searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/users/{userId}/terms/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse getTermRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getTermRelationships(serverName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/users/{userId}/terms/{guid}"})
    public SubjectAreaOMASAPIResponse updateTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Term suppliedTerm, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTerm(serverName, userId, guid, suppliedTerm, isReplace.booleanValue());
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"/users/{userId}/terms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteTerm(serverName, userId, guid, isPurge);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/users/{userId}/terms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTerm(serverName, userId, guid);
    }
}

