/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaCategoryRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/subject-area"})
public class SubjectAreaCategoryRESTResource
extends SubjectAreaRESTServicesInstance {
    private SubjectAreaCategoryRESTServices restAPI = new SubjectAreaCategoryRESTServices();

    @PostMapping(path={"/users/{userId}/categories"})
    public SubjectAreaOMASAPIResponse createCategory(@PathVariable String serverName, @PathVariable String userId, @RequestBody Category suppliedCategory) {
        return this.restAPI.createCategory(serverName, userId, suppliedCategory);
    }

    @GetMapping(path={"/users/{userId}/categories/{guid}"})
    public SubjectAreaOMASAPIResponse getCategoryByGuid(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getCategory(serverName, userId, guid);
    }

    @GetMapping(path={"/users/{userId}/categories"})
    public SubjectAreaOMASAPIResponse findTerm(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findCategory(serverName, userId, searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/users/{userId}/categories/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse getCategoryRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getCategoryRelationships(serverName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @PutMapping(path={"/users/{userId}/categories/{guid}"})
    public SubjectAreaOMASAPIResponse updateCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, Category suppliedCategory, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateCategory(serverName, userId, guid, suppliedCategory, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/categories/{guid}"})
    public SubjectAreaOMASAPIResponse deleteCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteCategory(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/categories/{guid}"})
    public SubjectAreaOMASAPIResponse restoreCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreCategory(serverName, userId, guid);
    }
}

