/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaProjectRESTServices;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRESTServicesInstance;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/subject-area"})
public class SubjectAreaProjectRESTResource
extends SubjectAreaRESTServicesInstance {
    private SubjectAreaProjectRESTServices restAPI = new SubjectAreaProjectRESTServices();

    @PostMapping(path={"/users/{userId}/projects"})
    public SubjectAreaOMASAPIResponse createProject(@PathVariable String serverName, @PathVariable String userId, @RequestBody Project suppliedProject) {
        return this.restAPI.createProject(serverName, userId, suppliedProject);
    }

    @GetMapping(path={"/users/{userId}/projects/{guid}"})
    public SubjectAreaOMASAPIResponse getProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getProjectByGuid(serverName, userId, guid);
    }

    @GetMapping(path={"/users/{userId}/projects"})
    public SubjectAreaOMASAPIResponse findProject(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findProject(serverName, userId, searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/users/{userId}/projects/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse getProjectRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getProjectRelationships(serverName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/users/{userId}/projects/{guid}/terms"})
    public SubjectAreaOMASAPIResponse getProjectTerms(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime) {
        return this.restAPI.getProjectTerms(serverName, userId, guid, asOfTime);
    }

    @PutMapping(path={"/users/{userId}/projects/{guid}"})
    public SubjectAreaOMASAPIResponse updateProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Project Project2, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateProject(serverName, userId, guid, Project2, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/projects/{guid}"})
    public SubjectAreaOMASAPIResponse deleteProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteProject(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/projects/{guid}"})
    public SubjectAreaOMASAPIResponse restoreProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreProject(serverName, userId, guid);
    }
}

