/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Hasa;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Isa;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsaTypeOf;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TypedBy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaRelationshipRESTServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/subject-area"})
@Tag(name="Subject Area OMAS", description="The Subject Area OMAS supports subject matter experts who are documenting their knowledge about a particular subject. This includes glossary terms, reference data, validation rules.", externalDocs=@ExternalDocumentation(description="Subject Area Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/subject-area/"))
public class SubjectAreaRelationshipRESTResource {
    private SubjectAreaRelationshipRESTServices restAPI = new SubjectAreaRelationshipRESTServices();

    @PostMapping(path={"/users/{userId}/relationships/has-as"})
    public SubjectAreaOMASAPIResponse createTermHASARelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody Hasa termHASARelationship) {
        return this.restAPI.createTermHASARelationship(serverName, userId, termHASARelationship);
    }

    @GetMapping(path={"/users/{userId}/relationships/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse getTermHASARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermHASARelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/has-as"})
    public SubjectAreaOMASAPIResponse updateTermHASARelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody Hasa termHASARelationship, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateTermHASARelationship(serverName, userId, termHASARelationship, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermHASARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteTermHASARelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermHASARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermHASARelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/related-terms"})
    public SubjectAreaOMASAPIResponse createRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody RelatedTerm relatedTermRelationshipRelationship) {
        return this.restAPI.createRelatedTerm(serverName, userId, relatedTermRelationshipRelationship);
    }

    @GetMapping(path={"/users/{userId}/relationships/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse getRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getRelatedTerm(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/related-terms"})
    public SubjectAreaOMASAPIResponse updateRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody RelatedTerm relatedTermRelationship, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateRelatedTerm(serverName, userId, relatedTermRelationship, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteRelatedTerm(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreRelatedTerm(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/synonyms"})
    public SubjectAreaOMASAPIResponse createSynonym(@PathVariable String serverName, @PathVariable String userId, @RequestBody Synonym synonym) {
        return this.restAPI.createSynonym(serverName, userId, synonym);
    }

    @GetMapping(path={"/users/{userId}/relationships/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse getSynonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getSynonymRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/synonyms"})
    public SubjectAreaOMASAPIResponse updateSynonymRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody Synonym synonym, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateSynonymRelationship(serverName, userId, synonym, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteSynonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteSynonymRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreSynonym(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreSynonym(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/antonyms"})
    public SubjectAreaOMASAPIResponse createAntonym(@PathVariable String serverName, @PathVariable String userId, @RequestBody Antonym antonym) {
        return this.restAPI.createAntonym(serverName, userId, antonym);
    }

    @GetMapping(path={"/users/{userId}/relationships/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse getAntonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getAntonymRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/antonyms"})
    public SubjectAreaOMASAPIResponse updateAntonymRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody Antonym antonym, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateAntonymRelationship(serverName, userId, antonym, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteAntonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteAntonymRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreAntonym(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreAntonym(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/translations"})
    public SubjectAreaOMASAPIResponse createTranslation(@PathVariable String serverName, @PathVariable String userId, @RequestBody Translation translation) {
        return this.restAPI.createTranslation(serverName, userId, translation);
    }

    @GetMapping(path={"/users/{userId}/relationships/translations/{guid}"})
    public SubjectAreaOMASAPIResponse getTranslationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTranslationRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/translations"})
    public SubjectAreaOMASAPIResponse updateTranslationRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody Translation translation, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateTranslationRelationship(serverName, userId, translation, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/translations/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTranslationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteTranslationRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/translations/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTranslation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTranslation(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/used-in-contexts"})
    public SubjectAreaOMASAPIResponse createusedInContext(@PathVariable String serverName, @PathVariable String userId, @RequestBody UsedInContext usedInContext) {
        return this.restAPI.createUsedInContext(serverName, userId, usedInContext);
    }

    @GetMapping(path={"/users/{userId}/relationships/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse getUsedInContextRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getUsedInContextRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/used-in-contexts"})
    public SubjectAreaOMASAPIResponse updateUsedInContextRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody UsedInContext usedInContext, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateUsedInContextRelationship(serverName, userId, usedInContext, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse deleteUsedInContextRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteUsedInContextRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse restoreUsedInContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreUsedInContext(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/preferred-terms"})
    public SubjectAreaOMASAPIResponse createpreferredTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody PreferredTerm preferredTerm) {
        return this.restAPI.createPreferredTerm(serverName, userId, preferredTerm);
    }

    @GetMapping(path={"/users/{userId}/relationships/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse getPreferredTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getPreferredTermRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/preferred-terms"})
    public SubjectAreaOMASAPIResponse updatePreferredTermRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody PreferredTerm preferredTerm, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updatePreferredTermRelationship(serverName, userId, preferredTerm, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse deletePreferredTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deletePreferredTermRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse restorePreferredTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restorePreferredTerm(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/valid-values"})
    public SubjectAreaOMASAPIResponse createValidValue(@PathVariable String serverName, @PathVariable String userId, @RequestBody ValidValue validValue) {
        return this.restAPI.createValidValue(serverName, userId, validValue);
    }

    @GetMapping(path={"/users/{userId}/relationships/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse getValidValueRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getValidValueRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/valid-values"})
    public SubjectAreaOMASAPIResponse updateValidValueRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody ValidValue validValue, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateValidValueRelationship(serverName, userId, validValue, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse deleteValidValueRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteValidValueRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse restoreValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreValidValue(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/replacement-terms"})
    public SubjectAreaOMASAPIResponse createreplacementTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReplacementTerm replacementTerm) {
        return this.restAPI.createReplacementTerm(serverName, userId, replacementTerm);
    }

    @GetMapping(path={"/users/{userId}/relationships/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse getReplacementTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getReplacementTerm(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/replacement-terms"})
    public SubjectAreaOMASAPIResponse updateReplacementTermRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReplacementTerm replacementTerm, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateReplacementTerm(serverName, userId, replacementTerm, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteReplacementTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteReplacementTerm(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreReplacementTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreReplacementTerm(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/typed-bys"})
    public SubjectAreaOMASAPIResponse createtermTYPEDBYRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody TypedBy termTYPEDBYRelationship) {
        return this.restAPI.createTermTYPEDBYRelationship(serverName, userId, termTYPEDBYRelationship);
    }

    @GetMapping(path={"/users/{userId}/relationships/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse getTYPEDBYRelationshipRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermTYPEDBYRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/typed-bys"})
    public SubjectAreaOMASAPIResponse updateTermTYPEDBYRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody TypedBy termTYPEDBYRelationship, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateTermTYPEDBYRelationship(serverName, userId, termTYPEDBYRelationship, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTypedByRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteTermTYPEDBYRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermTYPEDBYRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermTYPEDBYRelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/is-as"})
    public SubjectAreaOMASAPIResponse createiSARelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody Isa iSARelationship) {
        return this.restAPI.createISARelationship(serverName, userId, iSARelationship);
    }

    @GetMapping(path={"/users/{userId}/relationships/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse getISARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getISARelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/is-as"})
    public SubjectAreaOMASAPIResponse updateISARelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody Isa isa, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateISARelationship(serverName, userId, isa, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermISARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteISARelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse restoreIsaRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreISARelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/is-a-type-ofs"})
    public SubjectAreaOMASAPIResponse createtermISATypeOFRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody IsaTypeOf termISATypeOFRelationship) {
        return this.restAPI.createTermISATypeOFRelationship(serverName, userId, termISATypeOFRelationship);
    }

    @GetMapping(path={"/users/{userId}/relationships/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse getTermISATypeOFRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermISATypeOFRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/is-a-type-ofs"})
    public SubjectAreaOMASAPIResponse updateISARelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody IsaTypeOf isatypeof, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateTermISATypeOFRelationship(serverName, userId, isatypeof, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermIsaTypeOfRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteIsATypeOfRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermIsaTypeOfRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermISATypeOFRelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/term-categorizations"})
    public SubjectAreaOMASAPIResponse createTermCategorization(@PathVariable String serverName, @PathVariable String userId, @RequestBody Categorization termCategorizationRelationship) {
        return this.restAPI.createTermCategorizationRelationship(serverName, userId, termCategorizationRelationship);
    }

    @GetMapping(path={"/users/{userId}/relationships/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse getTermCategorizationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermCategorizationRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/term-categorizations"})
    public SubjectAreaOMASAPIResponse updateTermCategorizationRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody Categorization isatypeof, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateTermCategorizationRelationship(serverName, userId, isatypeof, isReplace);
    }

    @DeleteMapping(path={"/users/{userId}/relationships/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermCategorizationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteTermCategorizationRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermCategorizationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermCategorizationRelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/term-anchor"})
    public SubjectAreaOMASAPIResponse createTermAnchor(@PathVariable String serverName, @PathVariable String userId, @RequestBody TermAnchor termAnchorRelationship) {
        return this.restAPI.createTermAnchorRelationship(serverName, userId, termAnchorRelationship);
    }

    @GetMapping(path={"/users/{userId}/relationships/term-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse getTermAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermAnchorRelationship(serverName, userId, guid);
    }

    @DeleteMapping(path={"/users/{userId}/relationships/term-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteTermAnchorRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/term-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermAnchorRelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/category-anchor"})
    public SubjectAreaOMASAPIResponse createCategoryAnchor(@PathVariable String serverName, @PathVariable String userId, @RequestBody CategoryAnchor categoryAnchorRelationship) {
        return this.restAPI.createCategoryAnchorRelationship(serverName, userId, categoryAnchorRelationship);
    }

    @GetMapping(path={"/users/{userId}/relationships/category-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse getCategoryAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getCategoryAnchorRelationship(serverName, userId, guid);
    }

    @DeleteMapping(path={"/users/{userId}/relationships/category-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse deleteCategoryAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteCategoryAnchorRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/category-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse restoreCategoryAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreCategoryAnchorRelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/relationships/project-scopes"})
    public SubjectAreaOMASAPIResponse createProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody ProjectScope projectScope) {
        return this.restAPI.createProjectScopeRelationship(serverName, userId, projectScope);
    }

    @GetMapping(path={"/users/{userId}/relationships/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse getProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getProjectScopeRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/users/{userId}/relationships/project-scopes"})
    public SubjectAreaOMASAPIResponse updateProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody ProjectScope projectScope, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateProjectScopeRelationship(serverName, userId, projectScope, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/relationships/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse deleteProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteProjectScopeRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/relationships/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse restoreProjectScoperRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreProjectScopeRelationship(serverName, userId, guid);
    }

    @GetMapping(path={"/users/{userId}/relationships/semantic-assignments/{guid}"})
    public SubjectAreaOMASAPIResponse getSemanticAssignmentRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getSemanticAssignmentRelationship(serverName, userId, guid);
    }
}

