/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.StatusFilter;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGraphRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/subject-area"})
@Tag(name="Subject Area OMAS", description="The Subject Area OMAS supports subject matter experts who are documenting their knowledge about a particular subject. This includes glossary terms, reference data, validation rules.", externalDocs=@ExternalDocumentation(description="Subject Area Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/subject-area/"))
public class SubjectAreaGraphRESTResource {
    private final SubjectAreaGraphRESTServices restAPI = new SubjectAreaGraphRESTServices();

    @GetMapping(path={"/users/{userId}/nodes/{guid}"})
    public SubjectAreaOMASAPIResponse<Graph> getGraph(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="nodeFilter", required=false) String nodeFilterStr, @RequestParam(value="relationshipFilter", required=false) String relationshipFilterStr, @RequestParam(value="statusFilter", required=false) StatusFilter statusFilter, @RequestParam(value="level", required=false) Integer level) {
        return this.restAPI.getGraph(serverName, userId, guid, asOfTime, nodeFilterStr, relationshipFilterStr, statusFilter, level);
    }
}

