/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaProjectRESTServices;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/subject-area"})
@Tag(name="Subject Area OMAS", description="The Subject Area OMAS supports subject matter experts who are documenting their knowledge about a particular subject. This includes glossary terms, reference data, validation rules.", externalDocs=@ExternalDocumentation(description="Subject Area Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/subject-area/"))
public class SubjectAreaProjectRESTResource {
    private final SubjectAreaProjectRESTServices restAPI = new SubjectAreaProjectRESTServices();

    @PostMapping(path={"/users/{userId}/projects"})
    public SubjectAreaOMASAPIResponse<Project> createProject(@PathVariable String serverName, @PathVariable String userId, @RequestBody Project suppliedProject) {
        return this.restAPI.createProject(serverName, userId, suppliedProject);
    }

    @GetMapping(path={"/users/{userId}/projects/{guid}"})
    public SubjectAreaOMASAPIResponse<Project> getProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getProjectByGuid(serverName, userId, guid);
    }

    @GetMapping(path={"/users/{userId}/projects"})
    public SubjectAreaOMASAPIResponse<Project> findProject(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findProject(serverName, userId, searchCriteria, asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/users/{userId}/projects/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse<Line> getProjectRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getProjectRelationships(serverName, userId, guid, asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/users/{userId}/projects/{guid}/terms"})
    public SubjectAreaOMASAPIResponse<Term> getProjectTerms(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        return this.restAPI.getProjectTerms(serverName, userId, guid, startingFrom, pageSize);
    }

    @PutMapping(path={"/users/{userId}/projects/{guid}"})
    public SubjectAreaOMASAPIResponse<Project> updateProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Project Project2, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateProject(serverName, userId, guid, Project2, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/projects/{guid}"})
    public SubjectAreaOMASAPIResponse<Project> deleteProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteProject(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/projects/{guid}"})
    public SubjectAreaOMASAPIResponse<Project> restoreProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreProject(serverName, userId, guid);
    }
}

