/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaTermRESTServices;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/subject-area"})
@Tag(name="Subject Area OMAS", description="The Subject Area OMAS supports subject matter experts who are documenting their knowledge about a particular subject. This includes glossary terms, reference data, validation rules.", externalDocs=@ExternalDocumentation(description="Subject Area Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/subject-area/"))
public class SubjectAreaTermRESTResource {
    private final SubjectAreaTermRESTServices restAPI = new SubjectAreaTermRESTServices();

    @PostMapping(path={"/users/{userId}/terms"})
    public SubjectAreaOMASAPIResponse<Term> createTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody Term suppliedTerm) {
        return this.restAPI.createTerm(serverName, userId, suppliedTerm);
    }

    @GetMapping(path={"/users/{userId}/terms/{guid}"})
    public SubjectAreaOMASAPIResponse<Term> getTermByGuid(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermByGuid(serverName, userId, guid);
    }

    @GetMapping(path={"/users/{userId}/terms"})
    public SubjectAreaOMASAPIResponse<Term> findTerm(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) String sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findTerm(serverName, userId, searchCriteria, asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/users/{userId}/terms/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse<Relationship> getTermRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getTermRelationships(serverName, userId, guid, asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty);
    }

    @PutMapping(path={"/users/{userId}/terms/{guid}"})
    public SubjectAreaOMASAPIResponse<Term> updateTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Term suppliedTerm, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateTerm(serverName, userId, guid, suppliedTerm, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/terms/{guid}"})
    public SubjectAreaOMASAPIResponse<Term> deleteTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false, defaultValue="false") Boolean isPurge) {
        return this.restAPI.deleteTerm(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/users/{userId}/terms/{guid}"})
    public SubjectAreaOMASAPIResponse<Term> restoreTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTerm(serverName, userId, guid);
    }

    @GetMapping(path={"/users/{userId}/terms/{guid}/categories"})
    public SubjectAreaOMASAPIResponse<Category> getTermCategories(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        return this.restAPI.getTermCategories(serverName, userId, guid, startingFrom, pageSize);
    }
}

