/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaGlossaryRESTServices;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/subject-area"})
@Tag(name="Subject Area OMAS", description="The Subject Area OMAS supports subject matter experts who are documenting their knowledge about a particular subject. This includes glossary terms, reference data, validation rules.", externalDocs=@ExternalDocumentation(description="Subject Area Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/subject-area/overview/"))
public class SubjectAreaGlossaryRESTResource {
    private final SubjectAreaGlossaryRESTServices restAPI = new SubjectAreaGlossaryRESTServices();

    @PostMapping(path={"/users/{userId}/glossaries"})
    public SubjectAreaOMASAPIResponse<Glossary> createGlossary(@PathVariable String serverName, @PathVariable String userId, @RequestBody Glossary suppliedGlossary) {
        return this.restAPI.createGlossary(serverName, userId, suppliedGlossary);
    }

    @GetMapping(path={"/users/{userId}/glossaries/{guid}"})
    public SubjectAreaOMASAPIResponse<Glossary> getGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGlossaryByGuid(serverName, userId, guid);
    }

    @GetMapping(path={"/users/{userId}/glossaries"})
    public SubjectAreaOMASAPIResponse<Glossary> findGlossary(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="exactValue", required=false, defaultValue="false") Boolean exactValue, @RequestParam(value="ignoreCase", required=false, defaultValue="true") Boolean ignoreCase, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) String sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findGlossary(serverName, userId, searchCriteria, exactValue.booleanValue(), ignoreCase.booleanValue(), asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/users/{userId}/glossaries/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse<Relationship> getGlossaryRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getGlossaryRelationships(serverName, userId, guid, asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty);
    }

    @PutMapping(path={"/users/{userId}/glossaries/{guid}"})
    public SubjectAreaOMASAPIResponse<Glossary> updateGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Glossary glossary, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateGlossary(serverName, userId, guid, glossary, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/glossaries/{guid}"})
    public SubjectAreaOMASAPIResponse<Glossary> deleteGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteGlossary(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/glossaries/{guid}"})
    public SubjectAreaOMASAPIResponse<Glossary> restoreGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreGlossary(serverName, userId, guid);
    }

    @GetMapping(path={"/users/{userId}/glossaries/{guid}/terms"})
    public SubjectAreaOMASAPIResponse<Term> getGlossaryTerms(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="exactValue", required=false, defaultValue="false") Boolean exactValue, @RequestParam(value="ignoreCase", required=false, defaultValue="true") Boolean ignoreCase, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) String sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getGlossaryTerms(serverName, userId, guid, searchCriteria, exactValue.booleanValue(), ignoreCase.booleanValue(), asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/users/{userId}/glossaries/{guid}/categories"})
    public SubjectAreaOMASAPIResponse<Category> getGlossaryCategories(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="exactValue", required=false, defaultValue="false") Boolean exactValue, @RequestParam(value="ignoreCase", required=false, defaultValue="true") Boolean ignoreCase, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="onlyTop", required=false, defaultValue="true") Boolean onlyTop, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) String sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getGlossaryCategories(serverName, userId, guid, searchCriteria, exactValue.booleanValue(), ignoreCase.booleanValue(), asOfTime, onlyTop, startingFrom, pageSize, sequencingOrder, sequencingProperty);
    }
}

