/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.server.services.SubjectAreaCategoryRESTServices;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/subject-area"})
@Tag(name="Subject Area OMAS", description="The Subject Area OMAS supports subject matter experts who are documenting their knowledge about a particular subject. This includes glossary terms, reference data, validation rules.", externalDocs=@ExternalDocumentation(description="Subject Area Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/subject-area/"))
public class SubjectAreaCategoryRESTResource {
    private final SubjectAreaCategoryRESTServices restAPI = new SubjectAreaCategoryRESTServices();

    @PostMapping(path={"/users/{userId}/categories"})
    public SubjectAreaOMASAPIResponse<Category> createCategory(@PathVariable String serverName, @PathVariable String userId, @RequestBody Category suppliedCategory) {
        return this.restAPI.createCategory(serverName, userId, suppliedCategory);
    }

    @GetMapping(path={"/users/{userId}/categories/{guid}"})
    public SubjectAreaOMASAPIResponse<Category> getCategoryByGuid(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getCategory(serverName, userId, guid);
    }

    @GetMapping(path={"/users/{userId}/categories"})
    public SubjectAreaOMASAPIResponse<Category> findCategory(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="exactValue", required=false, defaultValue="false") Boolean exactValue, @RequestParam(value="ignoreCase", required=false, defaultValue="true") Boolean ignoreCase, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) String sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findCategory(serverName, userId, searchCriteria, exactValue.booleanValue(), ignoreCase.booleanValue(), asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/users/{userId}/categories/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse<Relationship> getCategoryRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="startingFrom", required=false) Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getCategoryRelationships(serverName, userId, guid, asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty);
    }

    @PutMapping(path={"/users/{userId}/categories/{guid}"})
    public SubjectAreaOMASAPIResponse<Category> updateCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Category suppliedCategory, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateCategory(serverName, userId, guid, suppliedCategory, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/users/{userId}/categories/{guid}"})
    public SubjectAreaOMASAPIResponse<Category> deleteCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteCategory(serverName, userId, guid);
    }

    @PostMapping(path={"/users/{userId}/categories/{guid}"})
    public SubjectAreaOMASAPIResponse<Category> restoreCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreCategory(serverName, userId, guid);
    }

    @GetMapping(path={"/users/{userId}/categories/{guid}/terms"})
    public SubjectAreaOMASAPIResponse<Term> getCategorizedTerms(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="exactValue", required=false, defaultValue="false") Boolean exactValue, @RequestParam(value="ignoreCase", required=false, defaultValue="true") Boolean ignoreCase, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        return this.restAPI.getCategorizedTerms(serverName, userId, guid, searchCriteria, exactValue.booleanValue(), ignoreCase.booleanValue(), startingFrom, pageSize);
    }

    @GetMapping(path={"/users/{userId}/categories/{guid}/categories"})
    public SubjectAreaOMASAPIResponse<Category> getCategoryChildren(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="exactValue", required=false, defaultValue="false") Boolean exactValue, @RequestParam(value="ignoreCase", required=false, defaultValue="true") Boolean ignoreCase, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        return this.restAPI.getCategoryChildren(serverName, userId, guid, searchCriteria, exactValue.booleanValue(), ignoreCase.booleanValue(), startingFrom, pageSize);
    }
}

