/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.generators;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.model.OmrsBeanAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.model.OmrsBeanEnumValue;
import org.odpi.openmetadata.accessservices.subjectarea.model.OmrsBeanModel;
import org.odpi.openmetadata.accessservices.subjectarea.model.OmrsBeanReference;
import org.odpi.openmetadata.accessservices.subjectarea.model.OmrsBeanRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.utils.GeneratorUtilities;

public class SubjectAreaOmrsBeanGenerator {
    private boolean regenAPIFiles = false;
    public static final String OPEN_METADATA_IMPLEMENTATION = "open-metadata-implementation";
    public static final String SUBJECTAREA_OMAS_SERVER = "open-metadata-implementation/access-services/subject-area/subject-area-server";
    public static final String SUBJECTAREA_OMAS_API = "open-metadata-implementation/access-services/subject-area/subject-area-api";
    public static final String GENERATOR = "open-metadata-implementation/access-services/subject-area/subject-area-tools";
    public static final String CLASSIFICATIONS = "classifications";
    public static final String RELATIONSHIPS = "relationships";
    public static final String REFERENCES = "references";
    public static final String ENTITIES = "entities";
    public static final String ENUMS = "enums";
    public static final String GENERATION_CLASSIFICATION_FACTORY_CLASS_NAME = "ClassificationFactory.java";
    public static final String GENERATION_OMRS_RELATIONSHIP_TO_LINES_CLASS_NAME = "OMRSRelationshipToLines.java";
    public static final String TEMPLATES_FOLDER = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/";
    public static final String SRC_SUBJECT_AREA = "/src/main/java/org/odpi/openmetadata/accessservices/subjectarea/";
    public static final String GENERATION_FOLDER = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//generated";
    public static final String GENERATION_REST_FOLDER = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//generated/server/";
    public static final String GENERATION_REST_TEST_FOLDER = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/test/java/org/odpi/openmetadata/accessservices/subjectarea/generated/server/Test";
    public static final String GENERATION_REST_CLASS_NAME = "SubjectAreaBeansToAccessOMRS.java";
    public static final String GENERATION_REST_FILE = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//generated/server/SubjectAreaBeansToAccessOMRS.java";
    public static final String GENERATION_REST_TEST_FILE = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/test/java/org/odpi/openmetadata/accessservices/subjectarea/generated/server/TestSubjectAreaBeansToAccessOMRS.java";
    public static final String GENERATION_REFERENCES_FOLDER = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//generated/references/";
    public static final String GENERATION_ENTITIES_FOLDER = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//generated/entities/";
    public static final String GENERATION_ENUMS_FOLDER = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//generated/enums/";
    public static final String GENERATION_CLASSIFICATIONS_FOLDER = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//generated/classifications/";
    public static final String SUBJECTAREA_OMAS_API_CLASSIFICATION_FOLDER = "open-metadata-implementation/access-services/subject-area/subject-area-api/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//properties/classifications";
    public static final String SUBJECTAREA_OMAS_API_ENUM_FOLDER = "open-metadata-implementation/access-services/subject-area/subject-area-api/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//properties/enums";
    public static final String GENERATION_RELATIONSHIPS_FOLDER = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//generated/relationships/";
    public static final String GENERATION_CLASSIFICATION_FACTORY_FILE_NAME = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//generated/classifications/ClassificationFactory.java";
    public static final String GENERATION_OMRS_RELATIONSHIP_TO_LINES_FILE_NAME = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//generated/relationships/OMRSRelationshipToLines.java";
    public static final String OMAS_REFERENCE_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/OmrsBeanReferenceTemplate";
    public static final String OMAS_ENTITY_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/OmrsBeanEntityTemplate";
    public static final String OMAS_CLASSIFICATION_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/OmrsBeanClassificationTemplate";
    public static final String OMAS_RELATIONSHIP_MAPPER_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/OmrsBeanRelationshipMapperTemplate";
    public static final String OMAS_RELATIONSHIP_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/OmrsBeanRelationshipTemplate";
    public static final String OMAS_ENUM_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/OmrsBeanEnumTemplate";
    public static final String OMAS_RELATIONSHIP_TO_LINES_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/OMRSRelationshipToLinesTemplate";
    public static final String OMAS_ENTITY_MAPPER_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/OmrsBeanEntityMapperTemplate";
    public static final String OMAS_CLASSIFICATION_MAPPER_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/OmrsBeanClassificationMapperTemplate";
    public static final String OMAS_TOP_REFERENCE_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/OmrsBeanTopReferenceTemplate";
    public static final String OMRS_BEANS_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/OmrsBeanAccessorTemplate";
    public static final String OMRS_BEANS_TEST_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/TestOmrsBeanAccessorTemplate";
    public static final String OMAS_CLASSIFICATION_FACTORY_TEMPLATE = "open-metadata-implementation/access-services/subject-area/subject-area-tools/src/main/resources/templates/OmrsBeanClassificationFactoryTemplate";
    private OmrsBeanModel omrsBeanModel;

    public SubjectAreaOmrsBeanGenerator(OmrsBeanModel omrsBeanModel) {
        this.omrsBeanModel = omrsBeanModel;
    }

    public static void main(String[] args) throws IOException {
        if (SubjectAreaOmrsBeanGenerator.checkCurrentFolder()) {
            SubjectAreaOmrsBeanGenerator.initializeFoldersandFiles();
            SubjectAreaOmrsBeanGenerator.generate(args);
        }
    }

    private static boolean checkCurrentFolder() {
        File curDir = new File(".");
        File[] filesList = curDir.listFiles();
        boolean validCurrentFolder = false;
        for (File f : filesList) {
            String folderName = f.getName();
            if (!folderName.equals(OPEN_METADATA_IMPLEMENTATION)) continue;
            validCurrentFolder = true;
        }
        return validCurrentFolder;
    }

    private static void initializeFoldersandFiles() throws FileNotFoundException {
        File relationshipToLinesFile;
        GeneratorUtilities.createEmptyFolder(GENERATION_FOLDER);
        GeneratorUtilities.writeFolder(GENERATION_REFERENCES_FOLDER);
        GeneratorUtilities.writeFolder(GENERATION_ENTITIES_FOLDER);
        GeneratorUtilities.writeFolder(GENERATION_ENUMS_FOLDER);
        GeneratorUtilities.writeFolder(GENERATION_CLASSIFICATIONS_FOLDER);
        GeneratorUtilities.writeFolder(GENERATION_RELATIONSHIPS_FOLDER);
        GeneratorUtilities.writeFolder(GENERATION_REST_FOLDER);
        GeneratorUtilities.writeFolder(GENERATION_REST_TEST_FOLDER);
        File classificationFactoryFile = new File(GENERATION_CLASSIFICATION_FACTORY_FILE_NAME);
        if (classificationFactoryFile.exists()) {
            classificationFactoryFile.delete();
        }
        if ((relationshipToLinesFile = new File(GENERATION_OMRS_RELATIONSHIP_TO_LINES_FILE_NAME)).exists()) {
            relationshipToLinesFile.delete();
        }
    }

    public static void generate(String[] args) throws IOException {
        OmrsBeanModel omrsBeanModel = new OmrsBeanModel();
        SubjectAreaOmrsBeanGenerator generator = new SubjectAreaOmrsBeanGenerator(omrsBeanModel);
        generator.generateEnumFiles();
        generator.generateClassificationFiles();
        generator.generateClassificationFactory();
        generator.generateOMRSRelationshipToLines();
        generator.generateEntityRelatedFiles(omrsBeanModel.getOmrsBeanEntityAttributeMap());
        generator.generateRelationshipFiles();
        generator.generateReferenceFiles();
        generator.generateOMRSBeansAccessorFile();
        generator.generateOMRSBeansAccessorTestFile();
    }

    private void generateEnumFiles() throws IOException {
        Map<String, List<OmrsBeanEnumValue>> enumsMap = this.omrsBeanModel.getEnumsMap();
        for (String enumName : enumsMap.keySet()) {
            String enumFileName = "open-metadata-implementation/access-services/subject-area/subject-area-server/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//generated/enums//" + enumName + ".java";
            this.generateEnumFile(enumName, enumsMap.get(enumName), enumFileName, "org.odpi.openmetadata.accessservices.subjectarea.generated.enums");
        }
        if (this.regenAPIFiles) {
            this.repopulateAPIEnums(enumsMap.keySet());
        }
    }

    private void repopulateAPIEnums(Set<String> enumNames) throws IOException {
        GeneratorUtilities.deleteFilesInFolder(SUBJECTAREA_OMAS_API_ENUM_FOLDER, "Status.java");
        Map<String, List<OmrsBeanEnumValue>> enumsMap = this.omrsBeanModel.getEnumsMap();
        for (String enumName : enumNames) {
            String enumPropertyFileName = "open-metadata-implementation/access-services/subject-area/subject-area-api/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//properties/enums/" + enumName + ".java";
            this.generateEnumFile(enumName, enumsMap.get(enumName), enumPropertyFileName, "org.odpi.openmetadata.accessservices.subjectarea.properties.enums");
        }
    }

    private void generateClassificationFiles() throws IOException {
        Map<String, List<OmrsBeanAttribute>> omrsBeanAttributeMap = this.omrsBeanModel.getOmrsBeanClassificationAttributeMap();
        for (String classificationName : omrsBeanAttributeMap.keySet()) {
            String outputFolder = this.createClassificationJavaFolderIfRequired(classificationName);
            String classificationFileName = outputFolder + "/" + classificationName + ".java";
            String classificationMapperFileName = outputFolder + "/" + classificationName + "Mapper.java";
            this.generateClassificationFile(classificationName, classificationFileName, "org.odpi.openmetadata.accessservices.subjectarea.generated.classifications." + classificationName);
            this.generateClassificationMapperFile(classificationName, classificationMapperFileName);
        }
        if (this.regenAPIFiles) {
            this.repopulateAPIClassifications(omrsBeanAttributeMap.keySet());
        }
    }

    private void repopulateAPIClassifications(Set<String> classificationNames) throws IOException {
        GeneratorUtilities.deleteFilesInFolder(SUBJECTAREA_OMAS_API_CLASSIFICATION_FOLDER, "Classification.java");
        for (String classificationName : classificationNames) {
            String classificationPropertyFileName = "open-metadata-implementation/access-services/subject-area/subject-area-api/src/main/java/org/odpi/openmetadata/accessservices/subjectarea//properties/classifications/" + classificationName + ".java";
            this.generateClassificationFile(classificationName, classificationPropertyFileName, "org.odpi.openmetadata.accessservices.subjectarea.properties.classifications");
        }
    }

    private void generateClassificationMapperFile(String classificationName, String fileName) throws IOException {
        FileWriter outputFileWriter = new FileWriter(fileName);
        ArrayList<String> loopEntityLines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(OMAS_CLASSIFICATION_MAPPER_TEMPLATE));
        String line = reader.readLine();
        while (line != null) {
            loopEntityLines.add(line);
            line = reader.readLine();
        }
        reader.close();
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        replacementMap.put("package", "classifications." + classificationName);
        this.mapOMRSToOMAS("Classification", replacementMap, outputFileWriter, loopEntityLines, classificationName);
        outputFileWriter.close();
    }

    private void generateClassificationFactory() throws IOException {
        FileWriter outputFileWriter = new FileWriter(GENERATION_CLASSIFICATION_FACTORY_FILE_NAME);
        BufferedReader reader = new BufferedReader(new FileReader(OMAS_CLASSIFICATION_FACTORY_TEMPLATE));
        String line = reader.readLine();
        while (line != null) {
            ArrayList<String> loopLines = new ArrayList<String>();
            if (line.contains("<$$$")) {
                String loopline = reader.readLine();
                while (loopline != null && !loopline.contains("$$$>")) {
                    loopLines.add(loopline);
                    loopline = reader.readLine();
                }
                for (String classificationName : this.omrsBeanModel.getOmrsBeanClassificationAttributeMap().keySet()) {
                    for (int loopCounter = 0; loopCounter < loopLines.size(); ++loopCounter) {
                        String newLine = (String)loopLines.get(loopCounter);
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uClassification"), GeneratorUtilities.uppercase1stLetter(classificationName));
                        outputFileWriter.write(newLine + "\n");
                    }
                }
            } else {
                outputFileWriter.write(line + "\n");
            }
            line = reader.readLine();
        }
        reader.close();
        outputFileWriter.close();
    }

    private void generateOMRSRelationshipToLines() throws IOException {
        FileWriter outputFileWriter = new FileWriter(GENERATION_OMRS_RELATIONSHIP_TO_LINES_FILE_NAME);
        BufferedReader reader = new BufferedReader(new FileReader(OMAS_RELATIONSHIP_TO_LINES_TEMPLATE));
        String line = reader.readLine();
        while (line != null) {
            ArrayList<String> loopLines = new ArrayList<String>();
            if (line.contains(" <$$RELATIONSHIP$")) {
                String loopline = reader.readLine();
                while (loopline != null && !loopline.contains(" $$RELATIONSHIP$>")) {
                    loopLines.add(loopline);
                    loopline = reader.readLine();
                }
                for (String relationshipName : this.omrsBeanModel.getOmrsBeanRelationshipMap().keySet()) {
                    for (int loopCounter = 0; loopCounter < loopLines.size(); ++loopCounter) {
                        String newLine = (String)loopLines.get(loopCounter);
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uRelationshipName"), GeneratorUtilities.uppercase1stLetter(relationshipName));
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("RelationshipName"), GeneratorUtilities.lowercase1stLetter(relationshipName));
                        outputFileWriter.write(newLine + "\n");
                    }
                }
            } else {
                outputFileWriter.write(line + "\n");
            }
            line = reader.readLine();
        }
        reader.close();
        outputFileWriter.close();
    }

    private void generateRelationshipFiles() throws IOException {
        Map<String, List<OmrsBeanAttribute>> omrsBeanAttributeMap = this.omrsBeanModel.getOmrsBeanRelationshipAttributeMap();
        for (String relationshipName : omrsBeanAttributeMap.keySet()) {
            relationshipName = GeneratorUtilities.uppercase1stLetter(relationshipName);
            String outputFolder = this.createRelationshipJavaFolderIfRequired(relationshipName);
            String relationshipFileName = outputFolder + "/" + relationshipName + ".java";
            OmrsBeanRelationship omrsBeanRelationship = this.omrsBeanModel.getOmrsBeanRelationshipByName(relationshipName);
            this.generateRelationshipFile(omrsBeanRelationship, relationshipFileName);
            String relationshipMapperFileName = outputFolder + "/" + relationshipName + "Mapper.java";
            this.generateRelationshipMapperFile(omrsBeanRelationship, relationshipMapperFileName);
        }
    }

    private void generateEntityRelatedFiles(Map<String, List<OmrsBeanAttribute>> omrsBeanAttributeMap) throws IOException {
        for (String entityName : omrsBeanAttributeMap.keySet()) {
            String outputFolder = this.createEntityJavaFolderIfRequired(entityName);
            String entityFileName = outputFolder + "/" + entityName + ".java";
            this.generateEntityFile(entityName, entityFileName);
            String mapperFileName = outputFolder + "/" + entityName + "Mapper.java";
            this.generateEntityMapperFile(entityName, mapperFileName);
        }
    }

    private void generateTopReferenceFile(String entityName, List<OmrsBeanAttribute> omrsBeanAttributes, String topReferenceFileName) throws IOException {
        FileWriter outputFileWriter = new FileWriter(topReferenceFileName);
        if (GeneratorUtilities.uppercase1stLetter(entityName).equals("LicenseType")) {
            int n = 11;
        }
        BufferedReader reader = new BufferedReader(new FileReader(OMAS_TOP_REFERENCE_TEMPLATE));
        String line = reader.readLine();
        while (line != null) {
            HashMap<String, String> replacementMap = new HashMap<String, String>();
            replacementMap.put("package", "entities." + entityName);
            replacementMap.put("name", GeneratorUtilities.lowercase1stLetter(entityName));
            replacementMap.put("uname", GeneratorUtilities.uppercase1stLetter(entityName));
            this.writeTopReferenceAttributesToFile(omrsBeanAttributes, replacementMap, outputFileWriter, reader, line);
            line = reader.readLine();
        }
        reader.close();
        outputFileWriter.close();
    }

    private void generateEnumFile(String enumName, List<OmrsBeanEnumValue> enumValues, String enumFileName, String pkg) throws IOException {
        FileWriter outputFileWriter = new FileWriter(enumFileName);
        BufferedReader reader = new BufferedReader(new FileReader(OMAS_ENUM_TEMPLATE));
        String line = reader.readLine();
        while (line != null) {
            HashMap<String, String> replacementMap = new HashMap<String, String>();
            replacementMap.put("description", this.omrsBeanModel.getTypeDefDescription(GeneratorUtilities.uppercase1stLetter(enumName)));
            replacementMap.put("package", pkg);
            replacementMap.put("name", GeneratorUtilities.lowercase1stLetter(enumName));
            replacementMap.put("uname", GeneratorUtilities.uppercase1stLetter(enumName));
            this.writeEnumToFile(enumName, enumValues, replacementMap, outputFileWriter, reader, line);
            line = reader.readLine();
        }
        reader.close();
        outputFileWriter.close();
    }

    private void generateEntityMapperFile(String entityName, String fileName) throws IOException {
        FileWriter outputFileWriter = new FileWriter(fileName);
        ArrayList<String> loopEntityLines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(OMAS_ENTITY_MAPPER_TEMPLATE));
        String line = reader.readLine();
        while (line != null) {
            loopEntityLines.add(line);
            line = reader.readLine();
        }
        reader.close();
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        replacementMap.put("package", "entities." + entityName);
        this.mapOMRSToOMAS("Entity", replacementMap, outputFileWriter, loopEntityLines, entityName);
        outputFileWriter.close();
    }

    private void generateOMRSBeansAccessorFile() throws IOException {
        FileWriter outputFileWriter = new FileWriter(GENERATION_REST_FILE);
        BufferedReader reader = new BufferedReader(new FileReader(OMRS_BEANS_TEMPLATE));
        String line = reader.readLine();
        while (line != null) {
            HashMap<String, String> replacementMap = new HashMap<String, String>();
            this.writeOMRSBeansAccessorFile(replacementMap, outputFileWriter, reader, line);
            line = reader.readLine();
        }
        reader.close();
        outputFileWriter.close();
    }

    private void generateOMRSBeansAccessorTestFile() throws IOException {
        FileWriter outputFileWriter = new FileWriter(GENERATION_REST_TEST_FILE);
        BufferedReader reader = new BufferedReader(new FileReader(OMRS_BEANS_TEST_TEMPLATE));
        String line = reader.readLine();
        while (line != null) {
            HashMap<String, String> replacementMap = new HashMap<String, String>();
            this.writeOMRSBeansAccessorFile(replacementMap, outputFileWriter, reader, line);
            line = reader.readLine();
        }
        reader.close();
        outputFileWriter.close();
    }

    private void writeOMRSBeansAccessorFile(Map<String, String> replacementMap, FileWriter outputFileWriter, BufferedReader reader, String line) throws IOException {
        Object loopline;
        Set<String> allEntities = this.omrsBeanModel.getOmrsBeanEntityAttributeMap().keySet();
        ArrayList<String> loopEntityLines = new ArrayList<String>();
        ArrayList<String> loopRelationshipLines = new ArrayList<String>();
        if (line.contains("<$$$")) {
            loopline = reader.readLine();
            while (loopline != null && !((String)loopline).contains("$$$>")) {
                loopEntityLines.add((String)loopline);
                loopline = reader.readLine();
            }
        }
        if (line.contains("<$$RELATIONSHIP$")) {
            loopline = reader.readLine();
            while (loopline != null && !((String)loopline).contains("$$RELATIONSHIP$>")) {
                loopRelationshipLines.add((String)loopline);
                loopline = reader.readLine();
            }
        }
        if (!loopEntityLines.isEmpty()) {
            for (String entityName : allEntities) {
                this.mapOMRSToOMAS("Entity", replacementMap, outputFileWriter, loopEntityLines, entityName);
            }
        } else if (!loopRelationshipLines.isEmpty()) {
            Map<String, List<OmrsBeanAttribute>> omrsBeanAttributeMap = this.omrsBeanModel.getOmrsBeanRelationshipAttributeMap();
            for (String relationshipName : omrsBeanAttributeMap.keySet()) {
                this.mapOMRSToOMAS("Relationship", replacementMap, outputFileWriter, loopRelationshipLines, relationshipName);
            }
        } else {
            String newLine = line;
            newLine = this.replaceTokensInLineFromMap(replacementMap, newLine);
            outputFileWriter.write(newLine + "\n");
        }
    }

    private void mapOMRSToOMAS(String omrsType, Map<String, String> replacementMap, FileWriter outputFileWriter, List<String> loopArtifactLines, String omrsArtifactName) throws IOException {
        String lowercaseArtifact = GeneratorUtilities.lowercase1stLetter(omrsArtifactName);
        String uppercaseArtifact = GeneratorUtilities.uppercase1stLetter(omrsArtifactName);
        String lowerCasePluralArtifactName = "";
        lowerCasePluralArtifactName = lowercaseArtifact.endsWith("y") ? lowercaseArtifact.substring(0, lowercaseArtifact.length() - 1) + "ies" : (lowercaseArtifact.endsWith("s") ? lowercaseArtifact + "es" : lowercaseArtifact + "s");
        List<OmrsBeanAttribute> allOmrsBeanAttributes = null;
        allOmrsBeanAttributes = omrsType.equals("Entity") ? this.omrsBeanModel.getOmrsBeanEntityAttributeMap().get(uppercaseArtifact) : (omrsType.equals("Classification") ? this.omrsBeanModel.getOmrsBeanClassificationAttributeMap().get(uppercaseArtifact) : this.omrsBeanModel.getOmrsBeanRelationshipAttributeMap().get(uppercaseArtifact));
        ArrayList<OmrsBeanAttribute> omrsBeanAttributes = new ArrayList<OmrsBeanAttribute>();
        ArrayList<OmrsBeanAttribute> omrsBeanEnumAttributes = new ArrayList<OmrsBeanAttribute>();
        ArrayList<OmrsBeanAttribute> omrsBeanMapAttributes = new ArrayList<OmrsBeanAttribute>();
        if (allOmrsBeanAttributes != null) {
            for (OmrsBeanAttribute omrsBeanAttribute : allOmrsBeanAttributes) {
                if (omrsBeanAttribute.isEnum) {
                    omrsBeanEnumAttributes.add(omrsBeanAttribute);
                    continue;
                }
                if (omrsBeanAttribute.isMap) {
                    omrsBeanMapAttributes.add(omrsBeanAttribute);
                    continue;
                }
                omrsBeanAttributes.add(omrsBeanAttribute);
            }
        }
        for (int loopArtifactCounter = 0; loopArtifactCounter < loopArtifactLines.size(); ++loopArtifactCounter) {
            ArrayList<String> loopRefLines;
            String attrValue;
            String uppercaseattributeType;
            OmrsBeanAttribute attribute;
            ArrayList<String> loopAttrLines;
            String newLine = loopArtifactLines.get(loopArtifactCounter);
            newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken(omrsType + "Name"), lowercaseArtifact);
            newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("u" + omrsType + "Name"), uppercaseArtifact);
            newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("lowerCasePlural" + omrsType + "Name"), lowerCasePluralArtifactName);
            if (omrsType.equals("Relationship")) {
                OmrsBeanRelationship omrsBeanRelationship = this.omrsBeanModel.getOmrsBeanRelationshipByName(uppercaseArtifact);
                newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uRelationshipEntity1"), GeneratorUtilities.uppercase1stLetter(omrsBeanRelationship.entityProxy1Name));
                newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uRelationshipEntity2"), GeneratorUtilities.uppercase1stLetter(omrsBeanRelationship.entityProxy2Name));
                newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uRelationshipEntityType1"), GeneratorUtilities.uppercase1stLetter(omrsBeanRelationship.entityProxy1Type));
                newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uRelationshipEntityType2"), GeneratorUtilities.uppercase1stLetter(omrsBeanRelationship.entityProxy2Type));
            }
            if (newLine.contains("<$$Attr$$")) {
                loopAttrLines = new ArrayList<String>();
                newLine = loopArtifactLines.get(++loopArtifactCounter);
                while (newLine != null) {
                    if (newLine.contains("$$Attr$$>")) {
                        newLine = loopArtifactLines.get(++loopArtifactCounter);
                        break;
                    }
                    loopAttrLines.add(newLine);
                    newLine = loopArtifactLines.get(++loopArtifactCounter);
                }
                if (omrsBeanAttributes.isEmpty()) continue;
                for (int attributeNumber = 0; attributeNumber < omrsBeanAttributes.size(); ++attributeNumber) {
                    attribute = (OmrsBeanAttribute)omrsBeanAttributes.get(attributeNumber);
                    if (attribute.isList) continue;
                    for (String attrLine : loopAttrLines) {
                        attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken(omrsType + "Name"), lowercaseArtifact);
                        attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("u" + omrsType + "Name"), uppercaseArtifact);
                        attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("AttrName"), GeneratorUtilities.lowercase1stLetter(attribute.name));
                        attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("uAttrName"), GeneratorUtilities.uppercase1stLetter(attribute.name));
                        if (attribute.isList) continue;
                        uppercaseattributeType = attribute.type.toUpperCase();
                        if (uppercaseattributeType.equals("INTEGER")) {
                            uppercaseattributeType = "INT";
                        }
                        if (uppercaseattributeType.startsWith("LIST<")) {
                            uppercaseattributeType = uppercaseattributeType.substring(5, uppercaseattributeType.length() - 1);
                        }
                        attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("uAttrType"), uppercaseattributeType);
                        attrValue = "";
                        if (uppercaseattributeType.equals("STRING")) {
                            attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("AttrType"), "String");
                            attrValue = "\"string" + attributeNumber + "\"";
                        } else if (uppercaseattributeType.equals("DATE")) {
                            attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("AttrType"), "java.util.Date");
                            attrValue = "new java.util.Date()";
                        } else if (uppercaseattributeType.equals("INT")) {
                            attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("AttrType"), "Integer");
                            attrValue = "new Integer(" + attributeNumber + ")";
                        } else if (uppercaseattributeType.equals("BOOLEAN")) {
                            attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("AttrType"), "Boolean");
                            attrValue = "new Boolean(true)";
                        } else {
                            attrValue = "";
                        }
                        attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("AttrValue"), attrValue);
                        outputFileWriter.write(attrLine + "\n");
                    }
                }
                continue;
            }
            if (newLine.contains("<$$AttrList$$")) {
                loopAttrLines = new ArrayList();
                newLine = loopArtifactLines.get(++loopArtifactCounter);
                while (newLine != null) {
                    if (newLine.contains("$$AttrList$$>")) {
                        newLine = loopArtifactLines.get(++loopArtifactCounter);
                        break;
                    }
                    loopAttrLines.add(newLine);
                    newLine = loopArtifactLines.get(++loopArtifactCounter);
                }
                if (omrsBeanAttributes.isEmpty()) continue;
                for (int attributeNumber = 0; attributeNumber < omrsBeanAttributes.size(); ++attributeNumber) {
                    attribute = (OmrsBeanAttribute)omrsBeanAttributes.get(attributeNumber);
                    if (!attribute.isList) continue;
                    for (String attrLine : loopAttrLines) {
                        attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken(omrsType + "Name"), lowercaseArtifact);
                        attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("u" + omrsType + "Name"), uppercaseArtifact);
                        attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("AttrName"), GeneratorUtilities.lowercase1stLetter(attribute.name));
                        attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("uAttrName"), GeneratorUtilities.uppercase1stLetter(attribute.name));
                        uppercaseattributeType = attribute.type.toUpperCase();
                        if (uppercaseattributeType.startsWith("LIST<")) {
                            uppercaseattributeType = uppercaseattributeType.substring(5, uppercaseattributeType.length() - 1);
                        }
                        if (uppercaseattributeType.equals("INTEGER")) {
                            uppercaseattributeType = "INT";
                        }
                        attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("uAttrType"), uppercaseattributeType);
                        attrValue = "";
                        if (uppercaseattributeType.equals("STRING")) {
                            attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("AttrType"), "String");
                            attrValue = "\"string" + attributeNumber + "\"";
                        } else if (uppercaseattributeType.equals("DATE")) {
                            attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("AttrType"), "java.util.Date");
                            attrValue = "new java.util.Date()";
                        } else if (uppercaseattributeType.equals("INT")) {
                            attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("AttrType"), "Integer");
                            attrValue = "new Integer(" + attributeNumber + ")";
                        } else {
                            attrValue = "";
                        }
                        attrLine = attrLine.replaceAll(GeneratorUtilities.getRegexToken("AttrValue"), attrValue);
                        outputFileWriter.write(attrLine + "\n");
                    }
                }
                continue;
            }
            if (newLine.contains("<$$Enum$$")) {
                ArrayList<String> loopEnumLines = new ArrayList<String>();
                newLine = loopArtifactLines.get(++loopArtifactCounter);
                while (newLine != null) {
                    if (newLine.contains("$$Enum$$>")) {
                        newLine = loopArtifactLines.get(++loopArtifactCounter);
                        break;
                    }
                    loopEnumLines.add(newLine);
                    newLine = loopArtifactLines.get(++loopArtifactCounter);
                }
                if (omrsBeanEnumAttributes.isEmpty()) continue;
                for (OmrsBeanAttribute enumAttribute : omrsBeanEnumAttributes) {
                    for (String enumLine : loopEnumLines) {
                        enumLine = enumLine.replaceAll(GeneratorUtilities.getRegexToken(omrsType + "Name"), lowercaseArtifact);
                        enumLine = enumLine.replaceAll(GeneratorUtilities.getRegexToken("u" + omrsType + "Name"), uppercaseArtifact);
                        enumLine = enumLine.replaceAll(GeneratorUtilities.getRegexToken("EnumType"), lowercaseArtifact);
                        enumLine = enumLine.replaceAll(GeneratorUtilities.getRegexToken("uEnumType"), GeneratorUtilities.uppercase1stLetter(enumAttribute.type));
                        enumLine = enumLine.replaceAll(GeneratorUtilities.getRegexToken("EnumName"), GeneratorUtilities.lowercase1stLetter(enumAttribute.name));
                        enumLine = enumLine.replaceAll(GeneratorUtilities.getRegexToken("uEnumName"), GeneratorUtilities.uppercase1stLetter(enumAttribute.name));
                        outputFileWriter.write(enumLine + "\n");
                    }
                }
                continue;
            }
            if (newLine.contains("<$$Map$$")) {
                ArrayList<String> loopMapLines = new ArrayList<String>();
                newLine = loopArtifactLines.get(++loopArtifactCounter);
                while (newLine != null) {
                    if (newLine.contains("$$Map$$>")) {
                        newLine = loopArtifactLines.get(++loopArtifactCounter);
                        break;
                    }
                    loopMapLines.add(newLine);
                    newLine = loopArtifactLines.get(++loopArtifactCounter);
                }
                if (omrsBeanMapAttributes.isEmpty()) continue;
                for (OmrsBeanAttribute mapAttribute : omrsBeanMapAttributes) {
                    for (String mapLine : loopMapLines) {
                        mapLine = mapLine.replaceAll(GeneratorUtilities.getRegexToken("u" + omrsType + "Name"), uppercaseArtifact);
                        mapLine = mapLine.replaceAll(GeneratorUtilities.getRegexToken(omrsType + "Name"), lowercaseArtifact);
                        mapLine = mapLine.replaceAll(GeneratorUtilities.getRegexToken("MapName"), GeneratorUtilities.lowercase1stLetter(mapAttribute.name));
                        mapLine = mapLine.replaceAll(GeneratorUtilities.getRegexToken("uMapName"), GeneratorUtilities.uppercase1stLetter(mapAttribute.name));
                        outputFileWriter.write(mapLine + "\n");
                    }
                }
                continue;
            }
            if (newLine.contains("<$$ref$$")) {
                List<OmrsBeanAttribute> omrsBeanReferences;
                loopRefLines = new ArrayList<String>();
                newLine = loopArtifactLines.get(++loopArtifactCounter);
                while (newLine != null) {
                    if (newLine.contains("$$ref$$>")) {
                        newLine = loopArtifactLines.get(++loopArtifactCounter);
                        break;
                    }
                    loopRefLines.add(newLine);
                    newLine = loopArtifactLines.get(++loopArtifactCounter);
                }
                if ((omrsBeanReferences = this.omrsBeanModel.getOmrsBeanReferencesAsAttributesByEntity().get(omrsArtifactName)) == null) continue;
                for (OmrsBeanAttribute reference : omrsBeanReferences) {
                    if (reference.isList) continue;
                    for (String refLine : loopRefLines) {
                        refLine = refLine.replaceAll(GeneratorUtilities.getRegexToken(omrsType + "Name"), lowercaseArtifact);
                        refLine = refLine.replaceAll(GeneratorUtilities.getRegexToken("referencePackage"), reference.referencePackage);
                        refLine = refLine.replaceAll(GeneratorUtilities.getRegexToken("refName"), GeneratorUtilities.lowercase1stLetter(reference.name));
                        refLine = refLine.replaceAll(GeneratorUtilities.getRegexToken("urefName"), GeneratorUtilities.uppercase1stLetter(reference.name));
                        outputFileWriter.write(refLine + "\n");
                    }
                }
                continue;
            }
            if (newLine.contains("<$$refList$$")) {
                List<OmrsBeanAttribute> omrsBeanReferences;
                loopRefLines = new ArrayList();
                newLine = loopArtifactLines.get(++loopArtifactCounter);
                while (newLine != null) {
                    if (newLine.contains("$$refList$$>")) {
                        newLine = loopArtifactLines.get(++loopArtifactCounter);
                        break;
                    }
                    loopRefLines.add(newLine);
                    newLine = loopArtifactLines.get(++loopArtifactCounter);
                }
                if ((omrsBeanReferences = this.omrsBeanModel.getOmrsBeanReferencesAsAttributesByEntity().get(omrsArtifactName)) == null) continue;
                for (OmrsBeanAttribute reference : omrsBeanReferences) {
                    if (!reference.isList) continue;
                    for (String refLine : loopRefLines) {
                        refLine = refLine.replaceAll(GeneratorUtilities.getRegexToken(omrsType + "Name"), lowercaseArtifact);
                        refLine = refLine.replaceAll(GeneratorUtilities.getRegexToken("referencePackage"), reference.referencePackage);
                        refLine = refLine.replaceAll(GeneratorUtilities.getRegexToken("refListName"), GeneratorUtilities.lowercase1stLetter(reference.name));
                        refLine = refLine.replaceAll(GeneratorUtilities.getRegexToken("urefListName"), GeneratorUtilities.uppercase1stLetter(reference.name));
                        outputFileWriter.write(refLine + "\n");
                    }
                }
                continue;
            }
            newLine = this.replaceTokensInLineFromMap(replacementMap, newLine);
            outputFileWriter.write(newLine + "\n");
        }
    }

    private void generateEntityFile(String entityName, String fileName) throws IOException {
        FileWriter outputFileWriter = new FileWriter(fileName);
        String uEntityName = GeneratorUtilities.uppercase1stLetter(entityName);
        entityName = GeneratorUtilities.lowercase1stLetter(entityName);
        List<OmrsBeanAttribute> attributeMap = this.omrsBeanModel.getOmrsBeanEntityAttributeMap().get(uEntityName);
        BufferedReader reader = new BufferedReader(new FileReader(OMAS_ENTITY_TEMPLATE));
        String line = reader.readLine();
        while (line != null) {
            HashMap<String, String> replacementMap = new HashMap<String, String>();
            replacementMap.put("uname", uEntityName);
            replacementMap.put("name", entityName);
            replacementMap.put("description", this.omrsBeanModel.getTypeDefDescription(uEntityName));
            replacementMap.put("package", "entities." + uEntityName);
            this.writeAttributesToFile(attributeMap, replacementMap, outputFileWriter, reader, line);
            line = reader.readLine();
        }
        reader.close();
        outputFileWriter.close();
    }

    private void generateClassificationFile(String classificationName, String fileName, String pkg) throws IOException {
        FileWriter outputFileWriter = new FileWriter(fileName);
        classificationName = GeneratorUtilities.lowercase1stLetter(classificationName);
        String uClassificationName = GeneratorUtilities.uppercase1stLetter(classificationName);
        List<OmrsBeanAttribute> attrList = this.omrsBeanModel.getOmrsBeanClassificationAttributeMap().get(uClassificationName);
        BufferedReader reader = new BufferedReader(new FileReader(OMAS_CLASSIFICATION_TEMPLATE));
        String line = reader.readLine();
        while (line != null) {
            HashMap<String, String> replacementMap = new HashMap<String, String>();
            replacementMap.put("uname", uClassificationName);
            replacementMap.put("name", classificationName);
            replacementMap.put("description", this.omrsBeanModel.getTypeDefDescription(uClassificationName));
            replacementMap.put("package", pkg);
            this.writeAttributesToFile(attrList, replacementMap, outputFileWriter, reader, line);
            line = reader.readLine();
        }
        reader.close();
        outputFileWriter.close();
    }

    private void generateRelationshipFile(OmrsBeanRelationship omrsBeanRelationship, String fileName) throws IOException {
        FileWriter outputFileWriter = new FileWriter(fileName);
        String relationshipName = omrsBeanRelationship.label;
        relationshipName = GeneratorUtilities.lowercase1stLetter(relationshipName);
        String uRelationshipName = GeneratorUtilities.uppercase1stLetter(relationshipName);
        BufferedReader reader = new BufferedReader(new FileReader(OMAS_RELATIONSHIP_TEMPLATE));
        String line = reader.readLine();
        while (line != null) {
            HashMap<String, String> replacementMap = new HashMap<String, String>();
            List<OmrsBeanAttribute> attrList = this.omrsBeanModel.getOmrsBeanRelationshipAttributeMap().get(uRelationshipName);
            replacementMap.put("uname", uRelationshipName);
            replacementMap.put("description", this.omrsBeanModel.getTypeDefDescription(GeneratorUtilities.uppercase1stLetter(GeneratorUtilities.uppercase1stLetter(relationshipName))));
            replacementMap.put("name", relationshipName);
            replacementMap.put("entityProxy1Name", omrsBeanRelationship.entityProxy1Name);
            replacementMap.put("entityProxy1Type", omrsBeanRelationship.entityProxy1Type);
            replacementMap.put("entityProxy2Name", omrsBeanRelationship.entityProxy2Name);
            replacementMap.put("entityProxy2Type", omrsBeanRelationship.entityProxy2Type);
            replacementMap.put("typeDefGuid", omrsBeanRelationship.typeDefGuid);
            this.writeAttributesToFile(attrList, replacementMap, outputFileWriter, reader, line);
            line = reader.readLine();
        }
        reader.close();
        outputFileWriter.close();
    }

    private void generateRelationshipMapperFile(OmrsBeanRelationship omrsBeanRelationship, String fileName) throws IOException {
        FileWriter outputFileWriter = new FileWriter(fileName);
        String label = omrsBeanRelationship.label;
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        ArrayList<String> loopRelationshipLines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(OMAS_RELATIONSHIP_MAPPER_TEMPLATE));
        String line = reader.readLine();
        while (line != null) {
            replacementMap.put("uname", GeneratorUtilities.uppercase1stLetter(label));
            replacementMap.put("name", GeneratorUtilities.lowercase1stLetter(label));
            loopRelationshipLines.add(line);
            line = reader.readLine();
        }
        reader.close();
        this.mapOMRSToOMAS("Relationship", replacementMap, outputFileWriter, loopRelationshipLines, label);
        outputFileWriter.close();
    }

    private void generateReferenceFiles() throws IOException {
        List<OmrsBeanReference> omrsBeanReferences = this.omrsBeanModel.getOmrsBeanReferences();
        for (OmrsBeanReference omrsBeanReference : omrsBeanReferences) {
            String outputFolder = this.createReferenceJavaFolderIfRequired(omrsBeanReference);
            String fileName = outputFolder + "/" + omrsBeanReference.uReferenceName + "Reference.java";
            FileWriter outputFileWriter = new FileWriter(fileName);
            BufferedReader reader = new BufferedReader(new FileReader(OMAS_REFERENCE_TEMPLATE));
            String line = reader.readLine();
            while (line != null) {
                List<OmrsBeanAttribute> attrList = omrsBeanReference.attrList;
                HashMap<String, String> replacementMap = new HashMap<String, String>();
                replacementMap.put("uname", omrsBeanReference.uReferenceName);
                replacementMap.put("mytype", omrsBeanReference.myType);
                String refPackage = GeneratorUtilities.getReferencePackage(omrsBeanReference.myType, omrsBeanReference.relatedEndType);
                replacementMap.put("refpackage", refPackage);
                replacementMap.put("name", omrsBeanReference.referenceName);
                replacementMap.put("relationshiptype", omrsBeanReference.relationshipType);
                replacementMap.put("relatedendtype", GeneratorUtilities.lowercase1stLetter(omrsBeanReference.relatedEndType));
                replacementMap.put("urelatedendtype", GeneratorUtilities.uppercase1stLetter(omrsBeanReference.relatedEndType));
                replacementMap.put("AttrDescription", omrsBeanReference.description);
                this.writeAttributesToFile(attrList, replacementMap, outputFileWriter, reader, line);
                line = reader.readLine();
            }
            reader.close();
            outputFileWriter.close();
        }
        Map<String, List<OmrsBeanAttribute>> omrsBeanReferencesAsAttributesByEntity = this.omrsBeanModel.getOmrsBeanReferencesAsAttributesByEntity();
        Set<String> entitiesWithRelationships = omrsBeanReferencesAsAttributesByEntity.keySet();
        for (String entityName : entitiesWithRelationships) {
            String outputFolder = this.createEntityJavaFolderIfRequired(entityName);
            String topReferenceFileName = outputFolder + "/" + entityName + "References.java";
            List<OmrsBeanAttribute> omrsBeanAttributes = omrsBeanReferencesAsAttributesByEntity.get(entityName);
            this.generateTopReferenceFile(entityName, omrsBeanAttributes, topReferenceFileName);
        }
    }

    private void writeEnumToFile(String enumName, List<OmrsBeanEnumValue> enumValues, Map<String, String> replacementMap, FileWriter outputFileWriter, BufferedReader reader, String line) throws IOException {
        if (line.contains("<$$$")) {
            String loopline = reader.readLine();
            ArrayList<String> loopLines = new ArrayList<String>();
            while (loopline != null && !loopline.contains("$$$>")) {
                loopLines.add(loopline);
                loopline = reader.readLine();
            }
            for (int i = 0; i < enumValues.size(); ++i) {
                OmrsBeanEnumValue omrsBeanEnumValue = enumValues.get(i);
                String enumValue = omrsBeanEnumValue.name;
                String enumDescription = omrsBeanEnumValue.description;
                for (int loopCounter = 0; loopCounter < loopLines.size(); ++loopCounter) {
                    String newLine = (String)loopLines.get(loopCounter);
                    newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("enum"), enumValue);
                    if (enumDescription == null) {
                        enumDescription = "Enumeration value for " + enumValue;
                    }
                    int enumOrdinal = omrsBeanEnumValue.ordinal;
                    newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("enumdescription"), enumDescription);
                    newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("enumordinal"), "" + enumOrdinal);
                    outputFileWriter.write(newLine + "\n");
                }
                if (i >= enumValues.size() - 1) continue;
                outputFileWriter.write(",\n");
            }
        } else {
            String newLine = line;
            newLine = this.replaceTokensInLineFromMap(replacementMap, newLine);
            outputFileWriter.write(newLine + "\n");
        }
    }

    private void writeAttributesToFile(List<OmrsBeanAttribute> attrList, Map<String, String> replacementMap, FileWriter outputFileWriter, BufferedReader reader, String line) throws IOException {
        String loopline;
        ArrayList<String> loopPropertyLines = new ArrayList<String>();
        ArrayList<String> loopAttrLines = new ArrayList<String>();
        ArrayList<String> loopEnumLines = new ArrayList<String>();
        ArrayList<String> loopMapLines = new ArrayList<String>();
        ArrayList<String> loopRelationshipLines = new ArrayList<String>();
        if (line.contains("<$$$")) {
            loopline = reader.readLine();
            while (loopline != null && !loopline.contains("$$$>")) {
                loopPropertyLines.add(loopline);
                loopline = reader.readLine();
            }
        } else if (line.contains("<$Enum$$")) {
            loopline = reader.readLine();
            while (loopline != null && !loopline.contains("$Enum$$>")) {
                loopEnumLines.add(loopline);
                loopline = reader.readLine();
            }
        } else if (line.contains("<$Map$$")) {
            loopline = reader.readLine();
            while (loopline != null && !loopline.contains("$Map$$>")) {
                loopMapLines.add(loopline);
                loopline = reader.readLine();
            }
        } else if (line.contains("<$Attr$$")) {
            loopline = reader.readLine();
            while (loopline != null && !loopline.contains("$Attr$$>")) {
                loopAttrLines.add(loopline);
                loopline = reader.readLine();
            }
        } else if (line.contains("<$Relationship$$")) {
            loopline = reader.readLine();
            while (loopline != null && !loopline.contains("$Relationship$$>")) {
                loopRelationshipLines.add(loopline);
                loopline = reader.readLine();
            }
        } else {
            String newLine = line;
            newLine = this.replaceTokensInLineFromMap(replacementMap, newLine);
            outputFileWriter.write(newLine + "\n");
        }
        if (attrList != null && !attrList.isEmpty()) {
            for (OmrsBeanAttribute attr : attrList) {
                String newLine;
                int loopCounter;
                if (!loopPropertyLines.isEmpty()) {
                    for (loopCounter = 0; loopCounter < loopPropertyLines.size(); ++loopCounter) {
                        newLine = (String)loopPropertyLines.get(loopCounter);
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("PropertyName"), GeneratorUtilities.lowercase1stLetter(attr.name));
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uPropertyName"), GeneratorUtilities.uppercase1stLetter(attr.name));
                        newLine = this.replaceTokensInLineFromMap(replacementMap, newLine);
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("PropertyType"), GeneratorUtilities.uppercase1stLetter(attr.type));
                        String javadoc = GeneratorUtilities.uppercase1stLetter(attr.type);
                        if (javadoc.contains("<") || javadoc.contains(">")) {
                            javadoc = "{@code " + javadoc + " }";
                        }
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("PropertyTypeJavadoc"), javadoc);
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("AttrDescription"), attr.description);
                        outputFileWriter.write(newLine + "\n");
                    }
                }
                if (!loopEnumLines.isEmpty()) {
                    for (loopCounter = 0; loopCounter < loopEnumLines.size(); ++loopCounter) {
                        newLine = (String)loopEnumLines.get(loopCounter);
                        if (!attr.isEnum) continue;
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("EnumName"), GeneratorUtilities.lowercase1stLetter(attr.name));
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("description"), GeneratorUtilities.lowercase1stLetter(attr.description));
                        outputFileWriter.write(newLine + "\n");
                    }
                }
                if (!loopMapLines.isEmpty()) {
                    for (loopCounter = 0; loopCounter < loopMapLines.size(); ++loopCounter) {
                        newLine = (String)loopMapLines.get(loopCounter);
                        if (!attr.isMap) continue;
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("MapName"), GeneratorUtilities.lowercase1stLetter(attr.name));
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("description"), attr.description);
                        outputFileWriter.write(newLine + "\n");
                    }
                }
                if (!loopAttrLines.isEmpty()) {
                    for (loopCounter = 0; loopCounter < loopAttrLines.size(); ++loopCounter) {
                        newLine = (String)loopAttrLines.get(loopCounter);
                        if (attr.isEnum || attr.isMap) continue;
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("AttrName"), GeneratorUtilities.lowercase1stLetter(attr.name));
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("description"), attr.description);
                        outputFileWriter.write(newLine + "\n");
                    }
                }
                if (loopRelationshipLines.isEmpty()) continue;
                for (loopCounter = 0; loopCounter < loopRelationshipLines.size(); ++loopCounter) {
                    newLine = (String)loopRelationshipLines.get(loopCounter);
                    if (!attr.isReference) continue;
                    newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("description"), attr.description);
                    outputFileWriter.write(newLine + "\n");
                }
            }
        }
    }

    private void writeTopReferenceAttributesToFile(List<OmrsBeanAttribute> allProperties, Map<String, String> replacementMap, FileWriter outputFileWriter, BufferedReader reader, String line) throws IOException {
        block24: {
            String upperCaseAttrName;
            String lowerCaseAttrName;
            ArrayList<OmrsBeanAttribute> singleProperties;
            ArrayList<String> loopSingleAttrLines;
            block26: {
                ArrayList<OmrsBeanAttribute> listProperties;
                ArrayList<String> loopListAttrLines;
                block25: {
                    ArrayList<OmrsBeanAttribute> setProperties;
                    ArrayList<String> loopSetAttrLines;
                    block23: {
                        String loopline;
                        ArrayList<String> loopPropertyLines = new ArrayList<String>();
                        loopSetAttrLines = new ArrayList<String>();
                        loopListAttrLines = new ArrayList<String>();
                        loopSingleAttrLines = new ArrayList<String>();
                        setProperties = new ArrayList<OmrsBeanAttribute>();
                        listProperties = new ArrayList<OmrsBeanAttribute>();
                        singleProperties = new ArrayList<OmrsBeanAttribute>();
                        for (OmrsBeanAttribute property : allProperties) {
                            lowerCaseAttrName = GeneratorUtilities.lowercase1stLetter(property.name);
                            upperCaseAttrName = GeneratorUtilities.uppercase1stLetter(property.name);
                            if (property.isSet) {
                                setProperties.add(property);
                                continue;
                            }
                            if (property.isList) {
                                listProperties.add(property);
                                continue;
                            }
                            singleProperties.add(property);
                        }
                        if (line.contains("<$$$")) {
                            loopline = reader.readLine();
                            while (loopline != null && !loopline.contains("$$$>")) {
                                loopPropertyLines.add(loopline);
                                loopline = reader.readLine();
                            }
                        } else if (line.contains("<$SetAttr$$")) {
                            loopline = reader.readLine();
                            while (loopline != null && !loopline.contains("$SetAttr$$>")) {
                                loopSetAttrLines.add(loopline);
                                loopline = reader.readLine();
                            }
                        } else if (line.contains("<$ListAttr$$")) {
                            loopline = reader.readLine();
                            while (loopline != null && !loopline.contains("$ListAttr$$>")) {
                                loopListAttrLines.add(loopline);
                                loopline = reader.readLine();
                            }
                        } else if (line.contains("<$SingleAttr$$")) {
                            loopline = reader.readLine();
                            while (loopline != null && !loopline.contains("$SingleAttr$$>")) {
                                loopSingleAttrLines.add(loopline);
                                loopline = reader.readLine();
                            }
                        } else {
                            String newLine = line;
                            newLine = this.replaceTokensInLineFromMap(replacementMap, newLine);
                            outputFileWriter.write(newLine + "\n");
                        }
                        if (loopPropertyLines.isEmpty()) break block23;
                        for (OmrsBeanAttribute property : allProperties) {
                            lowerCaseAttrName = GeneratorUtilities.lowercase1stLetter(property.name);
                            upperCaseAttrName = GeneratorUtilities.uppercase1stLetter(property.name);
                            String upperCaserelationshipName = GeneratorUtilities.uppercase1stLetter(property.referenceRelationshipName);
                            String lowerCaserelationshipName = GeneratorUtilities.lowercase1stLetter(property.referenceRelationshipName);
                            for (int loopCounter = 0; loopCounter < loopPropertyLines.size(); ++loopCounter) {
                                String newLine = (String)loopPropertyLines.get(loopCounter);
                                newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("referencePackage"), property.referencePackage);
                                newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("PropertyName"), lowerCaseAttrName);
                                newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uPropertyName"), upperCaseAttrName);
                                newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uRelationshipName"), upperCaserelationshipName);
                                newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("RelationshipName"), lowerCaserelationshipName);
                                outputFileWriter.write(newLine + "\n");
                            }
                        }
                        break block24;
                    }
                    if (loopSetAttrLines.isEmpty()) break block25;
                    for (OmrsBeanAttribute property : setProperties) {
                        lowerCaseAttrName = GeneratorUtilities.lowercase1stLetter(property.name);
                        upperCaseAttrName = GeneratorUtilities.uppercase1stLetter(property.name);
                        String upperCaserelationshipName = GeneratorUtilities.uppercase1stLetter(property.referenceRelationshipName);
                        String lowerCaserelationshipName = GeneratorUtilities.lowercase1stLetter(property.referenceRelationshipName);
                        for (int loopCounter = 0; loopCounter < loopSetAttrLines.size(); ++loopCounter) {
                            String newLine = (String)loopSetAttrLines.get(loopCounter);
                            newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("setReferenceName"), lowerCaseAttrName);
                            newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uSetReferenceName"), upperCaseAttrName);
                            newLine = this.replaceTokensInLineFromMap(replacementMap, newLine);
                            newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("PropertyType"), GeneratorUtilities.uppercase1stLetter(property.type));
                            newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("AttrDescription"), property.description);
                            newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uRelationshipName"), upperCaserelationshipName);
                            newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("RelationshipName"), lowerCaserelationshipName);
                            outputFileWriter.write(newLine + "\n");
                        }
                    }
                    break block24;
                }
                if (loopListAttrLines.isEmpty()) break block26;
                for (OmrsBeanAttribute property : listProperties) {
                    lowerCaseAttrName = GeneratorUtilities.lowercase1stLetter(property.name);
                    upperCaseAttrName = GeneratorUtilities.uppercase1stLetter(property.name);
                    String upperCaserelationshipName = GeneratorUtilities.uppercase1stLetter(property.referenceRelationshipName);
                    String lowerCaserelationshipName = GeneratorUtilities.lowercase1stLetter(property.referenceRelationshipName);
                    for (int loopCounter = 0; loopCounter < loopListAttrLines.size(); ++loopCounter) {
                        String newLine = (String)loopListAttrLines.get(loopCounter);
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("listReferenceName"), lowerCaseAttrName);
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uListReferenceName"), upperCaseAttrName);
                        newLine = this.replaceTokensInLineFromMap(replacementMap, newLine);
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("PropertyType"), GeneratorUtilities.uppercase1stLetter(property.type));
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("AttrDescription"), property.description);
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uRelationshipName"), upperCaserelationshipName);
                        newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("RelationshipName"), lowerCaserelationshipName);
                        outputFileWriter.write(newLine + "\n");
                    }
                }
                break block24;
            }
            if (loopSingleAttrLines.isEmpty()) break block24;
            for (OmrsBeanAttribute property : singleProperties) {
                lowerCaseAttrName = GeneratorUtilities.lowercase1stLetter(property.name);
                upperCaseAttrName = GeneratorUtilities.uppercase1stLetter(property.name);
                String upperCaserelationshipName = GeneratorUtilities.uppercase1stLetter(property.referenceRelationshipName);
                String lowerCaserelationshipName = GeneratorUtilities.lowercase1stLetter(property.referenceRelationshipName);
                for (int loopCounter = 0; loopCounter < loopSingleAttrLines.size(); ++loopCounter) {
                    String newLine = (String)loopSingleAttrLines.get(loopCounter);
                    newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("singleReferenceName"), lowerCaseAttrName);
                    newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uSingleReferenceName"), upperCaseAttrName);
                    newLine = this.replaceTokensInLineFromMap(replacementMap, newLine);
                    newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("PropertyType"), GeneratorUtilities.uppercase1stLetter(property.type));
                    newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("AttrDescription"), property.description);
                    newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("uRelationshipName"), upperCaserelationshipName);
                    newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken("RelationshipName"), lowerCaserelationshipName);
                    outputFileWriter.write(newLine + "\n");
                }
            }
        }
    }

    private String replaceTokensInLineFromMap(Map<String, String> referenceMap, String newLine) {
        if (referenceMap != null) {
            for (String key : referenceMap.keySet()) {
                if (referenceMap.get(key) == null) continue;
                newLine = newLine.replaceAll(GeneratorUtilities.getRegexToken(key), referenceMap.get(key));
            }
        }
        return newLine;
    }

    private String createReferenceJavaFolderIfRequired(OmrsBeanReference rgi) {
        String outputpackage = rgi.myType + "To" + rgi.relatedEndType;
        File newFolder = GeneratorUtilities.writeFolder(GENERATION_REFERENCES_FOLDER + outputpackage + "/");
        return newFolder.getPath();
    }

    private String createEntityJavaFolderIfRequired(String outputpackage) {
        File newFolder = GeneratorUtilities.writeFolder(GENERATION_ENTITIES_FOLDER + outputpackage + "/");
        return newFolder.getPath();
    }

    private String createClassificationJavaFolderIfRequired(String outputpackage) {
        File newFolder = GeneratorUtilities.writeFolder(GENERATION_CLASSIFICATIONS_FOLDER + outputpackage + "/");
        return newFolder.getPath();
    }

    private String createRelationshipJavaFolderIfRequired(String outputpackage) {
        File newFolder = GeneratorUtilities.writeFolder(GENERATION_RELATIONSHIPS_FOLDER + outputpackage + "/");
        return newFolder.getPath();
    }
}

