/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;

public class OmTypeFilter {
    private List<TypeDef> allTypeDefs = new ArrayList<TypeDef>();
    private List<AttributeTypeDef> allAttributeTypeDefs = new ArrayList<AttributeTypeDef>();
    private Map<String, EnumDef> allEnumTypedefs = new HashMap<String, EnumDef>();
    private Map<String, EntityDef> allEntityTypedefs = new HashMap<String, EntityDef>();
    private Map<String, RelationshipDef> allRelationshipTypedefs = new HashMap<String, RelationshipDef>();
    private Map<String, ClassificationDef> allClassificationTypedefs = new HashMap<String, ClassificationDef>();
    private Set<String> group3EntityDefSet = new HashSet<String>();
    private Map<String, EntityDef> entityDefsMap = new HashMap<String, EntityDef>();
    private Map<String, ClassificationDef> classificationDefsMap = new HashMap<String, ClassificationDef>();
    private Map<String, EnumDef> enumDefsMap = new HashMap<String, EnumDef>();
    private Map<String, RelationshipDef> relationshipTypeDefsMap = new HashMap<String, RelationshipDef>();
    private static String[] ENTITY_TYPES = new String[]{"APIOperation", "Community", "ExternalGlossaryLink", "GovernanceMetric", "ImplementationSnippet", "MetadataCollection", "ProjectCharter", "SoftwareServer", "APISchemaType", "ComplexSchemaType", "ExternalId", "GovernancePolicy", "InformalTag", "MetadataRepositoryCohort", "PropertyFacet", "SoftwareServerCapability", "ActorProfile", "Connection", "ExternalReference", "GovernanceProcess", "LicenseType", "Network", "Rating", "SubscriberList", "Application", "ConnectorType", "FileFolder", "GovernanceResponsibility", "Like", "NetworkGateway", "Referenceable", "Team", "Asset", "ContactDetails", "Glossary", "GovernanceRule", "Location", "NoteEntry", "Regulation", "ToDo", "BusinessCapability", "DataFile", "GlossaryCategory", "GovernanceZone", "MapSchemaType", "NoteLog", "RelatedMedia", "Topic", "CertificationType", "DataSet", "GlossaryTerm", "GraphEdge", "MediaCollection", "OperatingPlatform", "SchemaAttribute", "UserIdentity", "CohortMember", "DeployedAPI", "GovernanceControl", "GraphVertex", "MediaFile", "Person", "SchemaLinkElement", "VirtualConnection", "Collection", "DerivedSchemaAttribute", "GovernanceDefinition", "Host", "MediaUsage", "Process", "SchemaType", "VirtualContainer", "Comment", "Endpoint", "GovernanceDriver", "HostCluster", "Meeting", "Project", "SoftwareComponent", "DeployedSoftwareComponent"};
    private static String[] RELATIONSHIP_TYPES = new String[]{"APIEndpoint", "BusinessCapabilityResponsibility", "ExternallySourcedGlossary", "LibraryCategoryReference", "ProfileIdentity", "ServerDeployment", "APIHeader", "CategoryAnchor", "FolderHierarchy", "License", "", "ProjectCharterLink", "ServerEndpoint", "APIOperations", "CategoryHierarchyLink", "GovernanceControlLink", "LinkedFile", "ProjectDependency", "ServerSupportedCapability", "APIRequest", "Certification", "GovernanceDefinitionMetric", "LinkedMedia", "ProjectHierarchy", "SoftwareComponentDeployment", "APIResponse", "CohortMemberMetadataCollection", "GovernanceImplementation", "LinkedType", "ProjectMeeting", "StaffAssignment", "AcceptedAnswer", "CollectionMember", "GovernancePolicyLink", "MapFromElementType", "ProjectResources", "Synonym", "ActorCollection", "CommunityMembership", "GovernanceProcessImplementation", "MapToElementType", "ProjectScope", "TermAnchor", "AdjacentLocation", "CommunityResources", "GovernanceResponse", "MediaReference", "ProjectTeam", "TermCategorization", "Antonym", "", "ConnectionConnectorType", "GovernanceResults", "MediaUsageGuidance", "ReferenceableFacet", "TermHASARelationship", "AssetLocation", "ConnectionEndpoint", "GovernanceRuleImplementation", "MeetingOnReferenceable", "RegulationCertificationType", "TermISATypeOFRelationship", "AssetSchemaType", "ConnectionToAsset", "GraphEdgeLink", "MetadataCohortPeer", "RelatedTerm", "TermTYPEDBYRelationship", "AssetServerUse", "ContactThrough", "GroupedMedia", "NestedFile", "ReplacementTerm", "ToDoOnReferenceable", "AttachedComment", "Contributor", "HostClusterMember", "NestedLocation", "ResponsibilityStaffContact", "ToDoSource", "AttachedLike", "DataContentForDataSet", "HostLocation", "NetworkGatewayLink", "RuntimeForProcess", "TopicSubscribers", "AttachedNoteLog", "DeployedVirtualContainer", "HostNetwork", "OrganizationalCapability", "SchemaAttributeType", "Translation", "AttachedNoteLogEntry", "EmbeddedConnection", "HostOperatingPlatform", "Peer", "SchemaLinkToType", "UsedInContext", "AttachedRating", "ExternalIdLink", "ISARelationship", "PreferredTerm", "SchemaQueryImplementation", "ValidValue", "AttachedTag", "ExternalIdScope", "IsTaxonomy", "ProcessInput", "SchemaTypeImplementation", "ZoneGovernance", "AttributeForSchema", "ExternalReferenceLink", "Leadership", "ProcessOutput", "SemanticAssignment", "ZoneMembership"};
    public static final Set<String> RELATIONSHIP_TYPES_SET = new HashSet<String>(Arrays.asList(RELATIONSHIP_TYPES));
    public static final Set<String> ENTITY_TYPES_SET = new HashSet<String>(Arrays.asList(ENTITY_TYPES));

    public OmTypeFilter(List<TypeDef> newTypeDefs, List<AttributeTypeDef> attributeTypeDefs) {
        this.allTypeDefs = newTypeDefs;
        this.allAttributeTypeDefs = attributeTypeDefs;
        for (TypeDef omTypeDef : this.allTypeDefs) {
            String typeName = omTypeDef.getName();
            switch (omTypeDef.getCategory()) {
                case ENTITY_DEF: {
                    this.allEntityTypedefs.put(typeName, (EntityDef)omTypeDef);
                    if (!ENTITY_TYPES_SET.contains(typeName)) break;
                    this.entityDefsMap.put(typeName, (EntityDef)omTypeDef);
                    break;
                }
                case CLASSIFICATION_DEF: {
                    this.allClassificationTypedefs.put(omTypeDef.getName(), (ClassificationDef)omTypeDef);
                    break;
                }
                case RELATIONSHIP_DEF: {
                    this.allRelationshipTypedefs.put(omTypeDef.getName(), (RelationshipDef)omTypeDef);
                    if (!RELATIONSHIP_TYPES_SET.contains(typeName)) break;
                    this.relationshipTypeDefsMap.put(typeName, (RelationshipDef)omTypeDef);
                }
            }
        }
        for (AttributeTypeDef omAttrTypeDef : this.allAttributeTypeDefs) {
            switch (omAttrTypeDef.getCategory()) {
                case ENUM_DEF: {
                    this.allEnumTypedefs.put(omAttrTypeDef.getName(), (EnumDef)omAttrTypeDef);
                    break;
                }
                case PRIMITIVE: {
                    break;
                }
            }
        }
        this.enumDefsMap = this.allEnumTypedefs;
        this.classificationDefsMap = this.allClassificationTypedefs;
    }

    private EntityDef getEntityDef(String typeName) {
        return this.allEntityTypedefs.get(typeName);
    }

    private ClassificationDef getClassificationDef(String typeName) {
        return this.allClassificationTypedefs.get(typeName);
    }

    private EnumDef getEnumDef(String typeName) {
        return this.allEnumTypedefs.get(typeName);
    }

    private RelationshipDef getRelationshipDef(String typeName) {
        return this.allRelationshipTypedefs.get(typeName);
    }

    public Map<String, EntityDef> getEntityDefsMap() {
        return this.entityDefsMap;
    }

    public Map<String, ClassificationDef> getClassificationDefsMap() {
        return this.classificationDefsMap;
    }

    public Map<String, EnumDef> getEnumDefsMap() {
        return this.enumDefsMap;
    }

    public Map<String, RelationshipDef> getRelationshipTypeDefsMap() {
        return this.relationshipTypeDefsMap;
    }

    public String getTypeDescription(String typeName) {
        String description = null;
        if (this.entityDefsMap.get(typeName) != null) {
            description = this.entityDefsMap.get(typeName).getDescription();
        } else if (this.classificationDefsMap.get(typeName) != null) {
            description = this.classificationDefsMap.get(typeName).getDescription();
        } else if (this.relationshipTypeDefsMap.get(typeName) != null) {
            description = this.relationshipTypeDefsMap.get(typeName).getDescription();
        } else if (this.enumDefsMap.get(typeName) != null) {
            description = this.enumDefsMap.get(typeName).getDescription();
        }
        if (description == null) {
            description = "";
        }
        return description;
    }
}

