/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.subjectarea.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.model.OmTypeFilter;
import org.odpi.openmetadata.accessservices.subjectarea.model.OmrsBeanAttribute;
import org.odpi.openmetadata.accessservices.subjectarea.model.OmrsBeanEnumValue;
import org.odpi.openmetadata.accessservices.subjectarea.model.OmrsBeanReference;
import org.odpi.openmetadata.accessservices.subjectarea.model.OmrsBeanRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.utils.GeneratorUtilities;
import org.odpi.openmetadata.repositoryservices.archivemanager.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;

public class OmrsBeanModel {
    private OmTypeFilter typeFilter = null;
    String[] jsonFolders;
    private static final ObjectMapper mapper = new ObjectMapper();
    private List<OmrsBeanReference> omrsBeanReferences = new ArrayList<OmrsBeanReference>();
    private Map<String, List<OmrsBeanAttribute>> omrsBeanReferencesAsAttributesByEntity = new HashMap<String, List<OmrsBeanAttribute>>();
    private Set<String> typesWithRelationships = new HashSet<String>();
    private Map<String, List<OmrsBeanAttribute>> omrsBeanEntityAttributesMap = new HashMap<String, List<OmrsBeanAttribute>>();
    private Map<String, String> omrsBeanTypeDefDescriptionMap = new HashMap<String, String>();
    private Map<String, List<OmrsBeanEnumValue>> omrsBeanEnumToValuesMap = new HashMap<String, List<OmrsBeanEnumValue>>();
    private Map<String, List<OmrsBeanAttribute>> omrsBeanClassificationAttributesMap = new HashMap<String, List<OmrsBeanAttribute>>();
    private Map<String, String> omrsBeanClassificationDescriptionMap = new HashMap<String, String>();
    private Map<String, List<OmrsBeanAttribute>> omrsBeanRelationshipAttributesMap = new HashMap<String, List<OmrsBeanAttribute>>();
    private Map<String, OmrsBeanRelationship> nametoRelationshipMap = new HashMap<String, OmrsBeanRelationship>();
    OpenMetadataArchive omArchive = null;
    List<TypeDef> allOmTypedefs = null;
    List<AttributeTypeDef> allOmAttributeTypeDefs = null;
    List<TypeDef> omTypedefs = null;
    List<AttributeTypeDef> omAttributeTypeDefs = null;
    Map<String, EntityDef> omEntityTypedefs = new HashMap<String, EntityDef>();
    Map<String, RelationshipDef> omRelationshipTypedefs = new HashMap<String, RelationshipDef>();
    Map<String, ClassificationDef> omClassificationTypedefs = new HashMap<String, ClassificationDef>();
    Map<String, EnumDef> omEnumTypedefs = new HashMap<String, EnumDef>();

    public OmrsBeanModel() throws IOException {
        OpenMetadataTypesArchive typesArchive = new OpenMetadataTypesArchive();
        this.omArchive = typesArchive.getOpenMetadataArchive();
        this.typeFilter = new OmTypeFilter(this.omArchive.getArchiveTypeStore().getNewTypeDefs(), this.omArchive.getArchiveTypeStore().getAttributeTypeDefs());
        this.omEntityTypedefs = this.typeFilter.getEntityDefsMap();
        this.omClassificationTypedefs = this.typeFilter.getClassificationDefsMap();
        this.omEnumTypedefs = this.typeFilter.getEnumDefsMap();
        this.omRelationshipTypedefs = this.typeFilter.getRelationshipTypeDefsMap();
        this.createOmrsBeanEnums();
        this.createOmrsBeanReferences();
        this.createOmrsBeanEntityAttributes();
        this.createOmrsBeanClassifications();
        this.createOmrsBeanRelationships();
    }

    public String getTypeDefDescription(String typeName) {
        return this.typeFilter.getTypeDescription(typeName);
    }

    private void createOmrsBeanEnums() {
        for (String enumName : this.omEnumTypedefs.keySet()) {
            EnumDef enumDef = this.omEnumTypedefs.get(enumName);
            List enumElements = enumDef.getElementDefs();
            ArrayList<OmrsBeanEnumValue> enumValues = new ArrayList<OmrsBeanEnumValue>();
            for (EnumElementDef enumElement : enumElements) {
                OmrsBeanEnumValue omrsBeanEnumValue = new OmrsBeanEnumValue();
                omrsBeanEnumValue.name = this.normalizeTypeName(enumElement.getValue());
                omrsBeanEnumValue.description = enumElement.getDescription();
                omrsBeanEnumValue.ordinal = enumElement.getOrdinal();
                enumValues.add(omrsBeanEnumValue);
            }
            this.omrsBeanEnumToValuesMap.put(enumName, enumValues);
        }
    }

    private void createOmrsBeanEntityAttributes() {
        for (String entityName : this.omEntityTypedefs.keySet()) {
            EntityDef entityDef = this.omEntityTypedefs.get(entityName);
            ArrayList<TypeDefAttribute> attributeDefs = entityDef.getPropertiesDefinition();
            if (attributeDefs == null) {
                attributeDefs = new ArrayList<TypeDefAttribute>();
            }
            HashSet<String> attrNamesSet = new HashSet<String>();
            for (TypeDefAttribute attr : attributeDefs) {
                attrNamesSet.add(attr.getAttributeName());
            }
            if (entityName.equals("GlossaryTerm") || entityName.equals("GlossaryCategory")) {
                TypeDefAttribute typeDefAttribute = new TypeDefAttribute();
                typeDefAttribute.setAttributeName("glossaryName");
                typeDefAttribute.setAttributeDescription("The name of the glossary associated with this term. This must be present.");
                PrimitiveDef primitiveDef = new PrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitiveDef.setGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                primitiveDef.setName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                primitiveDef.setVersion(0L);
                primitiveDef.setVersionName("0");
                typeDefAttribute.setAttributeType((AttributeTypeDef)primitiveDef);
                typeDefAttribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
                typeDefAttribute.setValuesMinCount(0);
                typeDefAttribute.setValuesMaxCount(1);
                typeDefAttribute.setIndexable(true);
                typeDefAttribute.setUnique(false);
                typeDefAttribute.setDefaultValue(null);
                typeDefAttribute.setExternalStandardMappings(null);
                attrNamesSet.add("glossaryName");
                attributeDefs.add(typeDefAttribute);
            }
            while (entityDef.getSuperType() != null) {
                if ((entityDef = (EntityDef)entityDef.getSuperType()).getPropertiesDefinition() == null) continue;
                for (TypeDefAttribute attr : entityDef.getPropertiesDefinition()) {
                    String attributeName = attr.getAttributeName();
                    if (attrNamesSet.contains(attributeName)) continue;
                    attributeDefs.add(attr);
                    attrNamesSet.add(attributeName);
                }
            }
            List<OmrsBeanAttribute> omrsBeanattributeList = this.createOmrsBeanAttributeList(attributeDefs);
            this.omrsBeanEntityAttributesMap.put(entityName, omrsBeanattributeList);
        }
    }

    private void createOmrsBeanClassifications() {
        for (String classificationDefName : this.omClassificationTypedefs.keySet()) {
            classificationDefName = this.normalizeTypeName(classificationDefName);
            ClassificationDef classificationDef = this.omClassificationTypedefs.get(classificationDefName);
            List attributeDefs = classificationDef.getPropertiesDefinition();
            List<OmrsBeanAttribute> omrsBeanattributeList = this.createOmrsBeanAttributeList(attributeDefs);
            this.omrsBeanClassificationAttributesMap.put(classificationDefName, omrsBeanattributeList);
            this.omrsBeanClassificationDescriptionMap.put(classificationDefName, classificationDef.getDescription());
        }
    }

    private void createOmrsBeanRelationships() {
        for (String relationshipDefName : this.omRelationshipTypedefs.keySet()) {
            RelationshipDef relationshipDef = this.omRelationshipTypedefs.get(relationshipDefName);
            List attributeDefs = relationshipDef.getPropertiesDefinition();
            List<OmrsBeanAttribute> omrsBeanattributeList = this.createOmrsBeanAttributeList(attributeDefs);
            this.omrsBeanRelationshipAttributesMap.put(relationshipDefName, omrsBeanattributeList);
            OmrsBeanRelationship omrsBeanRelationship = new OmrsBeanRelationship();
            omrsBeanRelationship.description = relationshipDef.getDescription();
            omrsBeanRelationship.entityProxy1Name = relationshipDef.getEndDef1().getAttributeName();
            omrsBeanRelationship.entityProxy1Type = relationshipDef.getEndDef1().getEntityType().getName();
            omrsBeanRelationship.entityProxy2Name = relationshipDef.getEndDef2().getAttributeName();
            omrsBeanRelationship.entityProxy2Type = relationshipDef.getEndDef2().getEntityType().getName();
            omrsBeanRelationship.typeDefGuid = relationshipDef.getGUID();
            omrsBeanRelationship.label = relationshipDefName;
            this.nametoRelationshipMap.put(relationshipDefName, omrsBeanRelationship);
        }
    }

    public Map<String, List<OmrsBeanEnumValue>> getEnumsMap() {
        return this.omrsBeanEnumToValuesMap;
    }

    private List<OmrsBeanAttribute> createOmrsBeanAttributeList(List<TypeDefAttribute> attributeDefs) {
        ArrayList<OmrsBeanAttribute> omrsBeanattributeList = new ArrayList<OmrsBeanAttribute>();
        if (attributeDefs != null) {
            for (TypeDefAttribute attributeDef : attributeDefs) {
                String normalizedTypeName = this.normalizeTypeName(attributeDef.getAttributeType().getName());
                OmrsBeanAttribute omrsBeanAttribute = new OmrsBeanAttribute();
                omrsBeanAttribute.isList = attributeDef.getAttributeCardinality() != AttributeCardinality.AT_MOST_ONE && attributeDef.getAttributeCardinality() != AttributeCardinality.ONE_ONLY;
                if (attributeDef.getAttributeType().getCategory().equals((Object)AttributeTypeDefCategory.COLLECTION) && attributeDef.getAttributeType().getName().startsWith("array<")) {
                    omrsBeanAttribute.isList = true;
                }
                omrsBeanAttribute.name = attributeDef.getAttributeName();
                omrsBeanAttribute.description = attributeDef.getAttributeDescription();
                omrsBeanAttribute.type = normalizedTypeName;
                omrsBeanAttribute.isMap = false;
                omrsBeanAttribute.isEnum = false;
                omrsBeanattributeList.add(omrsBeanAttribute);
                if (attributeDef.getAttributeType().getCategory() == AttributeTypeDefCategory.ENUM_DEF) {
                    omrsBeanAttribute.isEnum = true;
                }
                if (attributeDef.getAttributeType().getCategory() != AttributeTypeDefCategory.COLLECTION || !attributeDef.getAttributeType().getName().startsWith("map<")) continue;
                omrsBeanAttribute.isMap = true;
            }
        }
        return omrsBeanattributeList;
    }

    private void createOmrsBeanReferences() {
        int i = 0;
        for (String relationshipDefName : this.omRelationshipTypedefs.keySet()) {
            ++i;
            RelationshipDef relationshipDef = this.omRelationshipTypedefs.get(relationshipDefName);
            String description = relationshipDef.getDescription();
            String relationshipGuid = relationshipDef.getGUID();
            RelationshipEndDef end1 = relationshipDef.getEndDef1();
            RelationshipEndDef end2 = relationshipDef.getEndDef2();
            String end1Name = end1.getAttributeName();
            String end1Type = this.normalizeTypeName(end1.getEntityType().getName());
            String end2Name = end2.getAttributeName();
            String end2Type = this.normalizeTypeName(end2.getEntityType().getName());
            boolean end1IsSet = false;
            boolean end2IsSet = false;
            if (end1.getAttributeCardinality() == RelationshipEndCardinality.ANY_NUMBER) {
                end1IsSet = true;
            }
            if (end2.getAttributeCardinality() == RelationshipEndCardinality.ANY_NUMBER) {
                end2IsSet = true;
            }
            List attributeDefs = relationshipDef.getPropertiesDefinition();
            List<OmrsBeanAttribute> omrsBeanattributeList = this.createOmrsBeanAttributeList(attributeDefs);
            if (end1Name.equals(end2Name) && end1Type.equals(end2Type)) {
                OmrsBeanReference omrsBeanReference = new OmrsBeanReference();
                omrsBeanReference.attrList = omrsBeanattributeList;
                omrsBeanReference.uReferenceName = GeneratorUtilities.uppercase1stLetter(end1Name);
                omrsBeanReference.referenceName = GeneratorUtilities.lowercase1stLetter(end1Name);
                omrsBeanReference.relatedEndType = end1Type;
                omrsBeanReference.relationshipType = relationshipDefName;
                omrsBeanReference.relationshipGuid = relationshipGuid;
                omrsBeanReference.myType = end1Type;
                omrsBeanReference.description = description;
                omrsBeanReference.isSet = end1IsSet;
                this.omrsBeanReferences.add(omrsBeanReference);
                this.typesWithRelationships.add(omrsBeanReference.myType);
                List<OmrsBeanAttribute> entityOmrsBeanReferencesAsAttributes = this.omrsBeanReferencesAsAttributesByEntity.get(omrsBeanReference.myType);
                if (entityOmrsBeanReferencesAsAttributes == null) {
                    entityOmrsBeanReferencesAsAttributes = new ArrayList<OmrsBeanAttribute>();
                }
                OmrsBeanAttribute omrsBeanAttribute = new OmrsBeanAttribute();
                omrsBeanAttribute.name = omrsBeanReference.referenceName;
                omrsBeanAttribute.type = omrsBeanReference.relatedEndType;
                omrsBeanAttribute.isSet = end1IsSet;
                omrsBeanAttribute.isReference = true;
                omrsBeanAttribute.referencePackage = GeneratorUtilities.getReferencePackage(omrsBeanReference.myType, omrsBeanReference.relatedEndType);
                omrsBeanAttribute.referenceRelationshipName = omrsBeanReference.relationshipType;
                entityOmrsBeanReferencesAsAttributes.add(omrsBeanAttribute);
                this.omrsBeanReferencesAsAttributesByEntity.put(omrsBeanReference.myType, entityOmrsBeanReferencesAsAttributes);
                continue;
            }
            OmrsBeanReference omrsBeanReference1 = new OmrsBeanReference();
            omrsBeanReference1.attrList = omrsBeanattributeList;
            omrsBeanReference1.uReferenceName = GeneratorUtilities.uppercase1stLetter(end2Name);
            omrsBeanReference1.referenceName = GeneratorUtilities.lowercase1stLetter(end2Name);
            omrsBeanReference1.relatedEndType = end2Type;
            omrsBeanReference1.relationshipType = relationshipDefName;
            omrsBeanReference1.relationshipGuid = relationshipGuid;
            omrsBeanReference1.myType = end1Type;
            omrsBeanReference1.isSet = end2IsSet;
            OmrsBeanReference omrsBeanReference2 = new OmrsBeanReference();
            omrsBeanReference2.attrList = omrsBeanattributeList;
            omrsBeanReference2.uReferenceName = GeneratorUtilities.uppercase1stLetter(end1Name);
            omrsBeanReference2.referenceName = GeneratorUtilities.lowercase1stLetter(end1Name);
            omrsBeanReference2.relationshipType = relationshipDefName;
            omrsBeanReference2.relationshipGuid = relationshipGuid;
            omrsBeanReference2.relatedEndType = end1Type;
            omrsBeanReference2.myType = end2Type;
            omrsBeanReference2.isSet = end1IsSet;
            this.omrsBeanReferences.add(omrsBeanReference1);
            this.omrsBeanReferences.add(omrsBeanReference2);
            this.typesWithRelationships.add(omrsBeanReference1.myType);
            this.typesWithRelationships.add(omrsBeanReference2.myType);
            List<OmrsBeanAttribute> entityOmrsBeanReferences1 = this.omrsBeanReferencesAsAttributesByEntity.get(omrsBeanReference1.myType);
            if (entityOmrsBeanReferences1 == null) {
                entityOmrsBeanReferences1 = new ArrayList<OmrsBeanAttribute>();
            }
            OmrsBeanAttribute omrsBeanAttribute1 = new OmrsBeanAttribute();
            omrsBeanAttribute1.name = omrsBeanReference1.referenceName;
            omrsBeanAttribute1.type = omrsBeanReference1.relatedEndType;
            omrsBeanAttribute1.isSet = omrsBeanReference1.isSet;
            omrsBeanAttribute1.isReference = true;
            omrsBeanAttribute1.referencePackage = GeneratorUtilities.getReferencePackage(omrsBeanReference1.myType, omrsBeanReference1.relatedEndType);
            omrsBeanAttribute1.referenceRelationshipName = omrsBeanReference1.relationshipType;
            entityOmrsBeanReferences1.add(omrsBeanAttribute1);
            this.omrsBeanReferencesAsAttributesByEntity.put(omrsBeanReference1.myType, entityOmrsBeanReferences1);
            List<OmrsBeanAttribute> entityOmrsBeanReferences2 = this.omrsBeanReferencesAsAttributesByEntity.get(omrsBeanReference2.myType);
            if (entityOmrsBeanReferences2 == null) {
                entityOmrsBeanReferences2 = new ArrayList<OmrsBeanAttribute>();
            }
            OmrsBeanAttribute omrsBeanAttribute2 = new OmrsBeanAttribute();
            omrsBeanAttribute2.name = omrsBeanReference2.referenceName;
            omrsBeanAttribute2.type = omrsBeanReference2.relatedEndType;
            omrsBeanAttribute2.isSet = omrsBeanReference2.isSet;
            omrsBeanAttribute2.isReference = true;
            omrsBeanAttribute2.referencePackage = GeneratorUtilities.getReferencePackage(omrsBeanReference2.myType, omrsBeanReference2.relatedEndType);
            omrsBeanAttribute2.referenceRelationshipName = omrsBeanReference1.relationshipType;
            entityOmrsBeanReferences2.add(omrsBeanAttribute2);
            this.omrsBeanReferencesAsAttributesByEntity.put(omrsBeanReference2.myType, entityOmrsBeanReferences2);
        }
        for (String entityDefName : this.omEntityTypedefs.keySet()) {
            EntityDef entityDef = this.omEntityTypedefs.get(entityDefName);
            List<OmrsBeanAttribute> deduplicatedOmrsBeanAttributes = this.omrsBeanReferencesAsAttributesByEntity.get(entityDefName);
            HashSet<String> attributeNames = new HashSet<String>();
            if (deduplicatedOmrsBeanAttributes != null) {
                for (OmrsBeanAttribute omrsBeanAttribute : deduplicatedOmrsBeanAttributes) {
                    attributeNames.add(omrsBeanAttribute.name);
                }
                if (attributeNames.size() != deduplicatedOmrsBeanAttributes.size()) {
                    throw new RuntimeException("Unexpected mismatch of attributes during reference processing");
                }
            }
            while (entityDef.getSuperType() != null) {
                List<OmrsBeanAttribute> parentOmrsBeanAttributes = this.omrsBeanReferencesAsAttributesByEntity.get((entityDef = (EntityDef)entityDef.getSuperType()).getName());
                if (parentOmrsBeanAttributes == null || parentOmrsBeanAttributes.size() <= 0) continue;
                HashSet<OmrsBeanAttribute> newAttributes = new HashSet<OmrsBeanAttribute>();
                if (deduplicatedOmrsBeanAttributes == null) {
                    deduplicatedOmrsBeanAttributes = new ArrayList<OmrsBeanAttribute>();
                }
                for (OmrsBeanAttribute omrsBeanAttribute : parentOmrsBeanAttributes) {
                    if (attributeNames.contains(omrsBeanAttribute.name)) continue;
                    attributeNames.add(omrsBeanAttribute.name);
                    newAttributes.add(omrsBeanAttribute);
                }
                if (!newAttributes.isEmpty()) {
                    for (OmrsBeanAttribute newOmrsBeanAttribute : newAttributes) {
                        deduplicatedOmrsBeanAttributes.add(newOmrsBeanAttribute);
                    }
                }
                if (attributeNames.size() == deduplicatedOmrsBeanAttributes.size()) continue;
                throw new RuntimeException("Unexpected mismatch2 of attributes during reference processing");
            }
            this.omrsBeanReferencesAsAttributesByEntity.put(entityDefName, deduplicatedOmrsBeanAttributes);
        }
    }

    public List<OmrsBeanReference> getOmrsBeanReferences() {
        return this.omrsBeanReferences;
    }

    public OmrsBeanRelationship getOmrsBeanRelationshipByName(String name) {
        return this.nametoRelationshipMap.get(name);
    }

    public Map<String, OmrsBeanRelationship> getOmrsBeanRelationshipMap() {
        return this.nametoRelationshipMap;
    }

    public Map<String, List<OmrsBeanAttribute>> getOmrsBeanRelationshipAttributeMap() {
        return this.omrsBeanRelationshipAttributesMap;
    }

    public Map<String, List<OmrsBeanAttribute>> getOmrsBeanEntityAttributeMap() {
        return this.omrsBeanEntityAttributesMap;
    }

    public Map<String, List<OmrsBeanAttribute>> getOmrsBeanClassificationAttributeMap() {
        return this.omrsBeanClassificationAttributesMap;
    }

    public Map<String, String> getOmrsBeanClassificationDescriptionMap() {
        return this.omrsBeanClassificationDescriptionMap;
    }

    public Map<String, List<OmrsBeanAttribute>> getOmrsBeanReferencesAsAttributesByEntity() {
        return this.omrsBeanReferencesAsAttributesByEntity;
    }

    private String normalizeTypeName(String typeName) {
        String normalizedTypeName = typeName;
        if (typeName.startsWith("map<string")) {
            normalizedTypeName = "Map<String,String>";
        }
        if (typeName.startsWith("array<")) {
            normalizedTypeName = normalizedTypeName.replaceAll(" ", "");
            int endIndex = normalizedTypeName.length() - 1;
            String element = normalizedTypeName.substring(6, endIndex);
            if ((element = GeneratorUtilities.uppercase1stLetter(element)).equals("Int")) {
                element = "Integer";
            }
            normalizedTypeName = "List<" + element + ">";
        }
        if (typeName.equals("int")) {
            normalizedTypeName = "Integer";
        }
        return normalizedTypeName;
    }
}

