/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.surveyaction.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum SurveyActionErrorCode implements ExceptionMessageSet
{
    SERVICE_INSTANCE_FAILURE(400, "OMES-SURVEY-ACTION-400-001", "The Survey Action OMES are unable to initialize a new instance in server {0}; error message is {1}", "The Survey Action OMES detected an error during the start up of a specific server instance.  No survey action services are available in the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    INVALID_SURVEY_SERVICE(400, "OMES-SURVEY-ACTION-400-002", "The survey action service {0} linked to request type {1} can not be started.  The {2} exception was returned with message {3}", "The survey request is not run and an error is returned to the caller.", "This may be an error in the survey action service's logic or the survey action service may not be properly deployed or there is a configuration error related to the survey action engine.  The configuration that defines the discovery request type in the survey action engine and links it to the survey action service is maintained in the metadata server by the Discovery Engine OMAS's configuration API.Verify that this configuration is correct.  If it is then validate that the jar file containing the survey action service's implementation has been deployed so the Survey Action OMES can load it.  If all this is true this it is likely to be a code error in the survey action service in which case, raise an issue with the author of the survey action service to get it fixed.  Once the cause is resolved, retry the survey request."),
    NO_TARGET_ASSET(400, "OMES-SURVEY-ACTION-400-003", "The survey action service {0} linked to request type {1} and engine action {2} can not be started because there is no asset action target supplied", "The survey request is not run and an error is recorded in the engine action.", "Retry the survey request and ensuring that an action target is included in the request."),
    NULL_REQUEST(400, "OMES-SURVEY-ACTION-400-004", "The survey engine action {0} can not be started because there is no governance service context", "The survey request is not run and an error is recorded in the engine action because the governance service is not set up property.", "This is an unexpected error, you may need to trace through the code to find out what has happened.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private SurveyActionErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

