/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionService;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyContext;
import org.odpi.openmetadata.frameworks.surveyaction.ffdc.SAFAuditCode;
import org.odpi.openmetadata.frameworks.surveyaction.ffdc.SAFErrorCode;

public abstract class SurveyActionServiceConnector
extends ConnectorBase
implements SurveyActionService,
AuditLoggingComponent,
VirtualConnectorExtension {
    protected static ObjectMapper objectMapper = new ObjectMapper();
    protected String surveyActionServiceName = "<Unknown>";
    protected SurveyContext surveyContext = null;
    protected AuditLog auditLog = null;
    protected List<Connector> embeddedConnectors = null;

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    public String getJSONProperties(Object properties) throws PropertyServerException {
        String methodName = "getJSONProperties";
        try {
            return objectMapper.writeValueAsString(properties);
        }
        catch (JsonProcessingException parsingError) {
            throw new PropertyServerException(SAFErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.surveyActionServiceName, ((Object)((Object)parsingError)).getClass().getName(), "getJSONProperties", parsingError.getMessage()), this.getClass().getName(), "getJSONProperties", (Throwable)parsingError);
        }
    }

    public synchronized void setSurveyContext(SurveyContext surveyContext) {
        this.surveyContext = surveyContext;
    }

    public void setSurveyActionServiceName(String surveyActionServiceName) {
        this.surveyActionServiceName = surveyActionServiceName;
    }

    protected synchronized SurveyContext getSurveyContext() throws ConnectorCheckedException {
        String methodName = "getSurveyContext";
        this.validateIsActive("getSurveyContext");
        return this.surveyContext;
    }

    protected synchronized AnnotationStore getAnnotationStore() throws ConnectorCheckedException {
        String methodName = "getAnnotationStore";
        this.validateIsActive("getAnnotationStore");
        return this.surveyContext.getAnnotationStore();
    }

    protected void throwWrongTypeOfAsset(String assetGUID, String assetType, String supportedAssetType, String methodName) throws ConnectorCheckedException {
        throw new ConnectorCheckedException(SAFErrorCode.INVALID_ASSET_TYPE.getMessageDefinition(assetGUID, assetType, this.surveyActionServiceName, supportedAssetType), this.getClass().getName(), methodName);
    }

    public void throwWrongTypeOfConnector(String actualConnectorClass, String expectedConnectorClass, String assetGUID, String methodName) throws ConnectorCheckedException {
        this.auditLog.logMessage(methodName, SAFAuditCode.WRONG_TYPE_OF_CONNECTOR.getMessageDefinition(this.surveyActionServiceName, actualConnectorClass, expectedConnectorClass, assetGUID));
        throw new ConnectorCheckedException(SAFErrorCode.WRONG_TYPE_OF_CONNECTOR.getMessageDefinition(this.surveyActionServiceName, actualConnectorClass, expectedConnectorClass, assetGUID), this.getClass().getName(), methodName);
    }

    public void logWrongTypeOfConnector(String actualConnectorClass, String expectedConnectorClass, String assetGUID, String methodName) {
        this.auditLog.logMessage(methodName, SAFAuditCode.WRONG_TYPE_OF_CONNECTOR.getMessageDefinition(this.surveyActionServiceName, actualConnectorClass, expectedConnectorClass, assetGUID));
    }

    private void validateIsActive(String methodName) throws ConnectorCheckedException {
        if (!this.isActive()) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, SAFAuditCode.DISCONNECT_DETECTED.getMessageDefinition(this.surveyActionServiceName));
            }
            throw new ConnectorCheckedException(SAFErrorCode.DISCONNECT_DETECTED.getMessageDefinition(this.surveyActionServiceName), this.getClass().getName(), methodName);
        }
    }

    protected List<SurveyActionServiceConnector> getEmbeddedSurveyActionServices() throws ConnectorCheckedException {
        String methodName = "getEmbeddedSurveyActionServices";
        ArrayList<SurveyActionServiceConnector> surveyActionServiceConnectors = null;
        if (this.embeddedConnectors != null) {
            surveyActionServiceConnectors = new ArrayList<SurveyActionServiceConnector>();
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (embeddedConnector == null) continue;
                if (embeddedConnector instanceof SurveyActionServiceConnector) {
                    surveyActionServiceConnectors.add((SurveyActionServiceConnector)embeddedConnector);
                    continue;
                }
                throw new ConnectorCheckedException(SAFErrorCode.INVALID_EMBEDDED_SURVEY_ACTION_SERVICE.getMessageDefinition(this.surveyActionServiceName), this.getClass().getName(), "getEmbeddedSurveyActionServices");
            }
            if (surveyActionServiceConnectors.isEmpty()) {
                surveyActionServiceConnectors = null;
            }
        }
        return surveyActionServiceConnectors;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        if (this.surveyContext == null) {
            throw new ConnectorCheckedException(SAFErrorCode.NULL_SURVEY_CONTEXT.getMessageDefinition(this.surveyActionServiceName), this.getClass().getName(), "start");
        }
    }

    protected void handleUnexpectedException(String methodName, Exception error) throws ConnectorCheckedException {
        throw new ConnectorCheckedException(SAFErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.surveyActionServiceName, error.getClass().getName(), methodName, error.getMessage()), this.getClass().getName(), methodName);
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        if (this.surveyContext != null) {
            this.surveyContext.disconnect();
        }
        super.disconnectConnectors(this.embeddedConnectors);
        super.disconnect();
    }
}

