/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.controls;

import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationTypeType;

public enum AnnotationType {
    EXAMPLE_ANNOTATION_TYPE("Example Annotation Type", AnalysisStep.PROFILE_DATA, OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "This is an example annotation type.", "This is the explanation of the annotation type's processing.", "This is the expression used in the annotation type's processing.");

    public final String name;
    public final AnalysisStep analysisStep;
    public final String openMetadataTypeName;
    public final String summary;
    public final String explanation;
    public final String expression;

    private AnnotationType(String name, AnalysisStep analysisStep, String openMetadataTypeName, String summary, String explanation, String expression) {
        this.name = name;
        this.analysisStep = analysisStep;
        this.openMetadataTypeName = openMetadataTypeName;
        this.summary = summary;
        this.explanation = explanation;
        this.expression = expression;
    }

    public String getName() {
        return this.name;
    }

    public String getAnalysisStep() {
        if (this.analysisStep != null) {
            return this.analysisStep.getName();
        }
        return null;
    }

    public String getOpenMetadataTypeName() {
        return this.openMetadataTypeName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getExpression() {
        return this.expression;
    }

    public AnnotationTypeType getAnnotationTypeType() {
        AnnotationTypeType annotationTypeType = new AnnotationTypeType();
        annotationTypeType.setName(this.name);
        annotationTypeType.setOpenMetadataTypeName(this.openMetadataTypeName);
        annotationTypeType.setAnalysisStepName(this.analysisStep.getName());
        annotationTypeType.setSummary(this.summary);
        annotationTypeType.setExplanation(this.explanation);
        annotationTypeType.setExpression(this.expression);
        return annotationTypeType;
    }

    public String toString() {
        return "AnnotationType{ name='" + this.name + "}";
    }
}

