/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum AnnotationStatus {
    NEW_ANNOTATION(0, "New", "Annotation has been created but not reviewed", "9f7e13d1-ec51-4c95-9931-383b3ab9295b"),
    REVIEWED_ANNOTATION(1, "Reviewed", "Annotation has been reviewed by no decision has been made", "64730138-399a-4f30-a0b8-1f6cc487cb53"),
    APPROVED_ANNOTATION(2, "Approved", "Annotation has been approved", "91b5c627-2c3a-4598-af72-e1b52f1f03c5"),
    ACTIONED_ANNOTATION(3, "Actioned", "Annotation has been approved and insight has been added to Asset's metadata", "b848b720-4171-4d28-9e4c-1d34f51aaf5f"),
    INVALID_ANNOTATION(4, "Invalid", "Annotation has been reviewed and declared invalid", "c65a21dc-d1ae-4a8f-ba33-58ec401c1b42"),
    IGNORE_ANNOTATION(5, "Ignore", "Annotation is invalid and should be ignored", "519cf063-9386-42e5-88dd-c5baab234df6"),
    OTHER_STATUS(98, "Other", "Annotation's status stored in additional properties", "fd4b6779-9582-4cc2-885e-72e44445ff04"),
    UNKNOWN_STATUS(99, "Unknown", "Annotation has not had a status assigned", "a9fc9231-f04a-40c4-99b1-4a1058063f5e");

    private static final String ENUM_TYPE_GUID = "71187df6-ef66-4f88-bc03-cd3c7f925165";
    private static final String ENUM_TYPE_NAME = "AnnotationStatus";
    private static final String ENUM_TYPE_DESCRIPTION = "Defines the status of an annotation.";
    private static final String ENUM_TYPE_DESCRIPTION_GUID = "a2671bf6-5eef-4432-a189-1e99d84507e1";
    private static final String ENUM_TYPE_WIKI_URL = "https://egeria-project.org/types/6/0612-Annotation-Reviews/";
    private final int statusCode;
    private final String statusName;
    private final String statusDescription;
    private final String statusDescriptionGUID;

    private AnnotationStatus(int statusCode, String statusName, String statusDescription, String statusDescriptionGUID) {
        this.statusCode = statusCode;
        this.statusName = statusName;
        this.statusDescription = statusDescription;
        this.statusDescriptionGUID = statusDescriptionGUID;
    }

    public int getOrdinal() {
        return this.statusCode;
    }

    public String getName() {
        return this.statusName;
    }

    public String getDescription() {
        return this.statusDescription;
    }

    public String getDescriptionGUID() {
        return this.statusDescriptionGUID;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_TYPE_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_TYPE_DESCRIPTION_GUID;
    }

    public static String getOpenTypeWikiURL() {
        return ENUM_TYPE_WIKI_URL;
    }

    public String toString() {
        return "AnnotationStatus{statusCode=" + this.statusCode + ", statusName='" + this.statusName + "', statusDescription='" + this.statusDescription + "', statusDescriptionGUID='" + this.statusDescriptionGUID + "'}";
    }
}

