/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.surveyaction.properties.DataFieldAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ResourceProfileLogAnnotation
extends DataFieldAnnotation {
    private List<String> resourceProfileLogGUIDs = null;

    public ResourceProfileLogAnnotation() {
    }

    public ResourceProfileLogAnnotation(ResourceProfileLogAnnotation template) {
        super(template);
        if (template != null) {
            this.resourceProfileLogGUIDs = template.getResourceProfileLogGUIDs();
        }
    }

    public List<String> getResourceProfileLogGUIDs() {
        if (this.resourceProfileLogGUIDs == null) {
            return null;
        }
        if (this.resourceProfileLogGUIDs.isEmpty()) {
            return null;
        }
        return this.resourceProfileLogGUIDs;
    }

    public void setResourceProfileLogGUIDs(List<String> resourceProfileLogFileNames) {
        this.resourceProfileLogGUIDs = resourceProfileLogFileNames;
    }

    @Override
    public String toString() {
        return "ResourceProfileLogAnnotation{resourceProfileLogFiles=" + this.resourceProfileLogGUIDs + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ResourceProfileLogAnnotation that = (ResourceProfileLogAnnotation)objectToCompare;
        return Objects.equals(this.resourceProfileLogGUIDs, that.resourceProfileLogGUIDs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resourceProfileLogGUIDs);
    }
}

