/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.NestedSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionService;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyContext;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyActionGuard;
import org.odpi.openmetadata.frameworks.surveyaction.ffdc.SAFAuditCode;
import org.odpi.openmetadata.frameworks.surveyaction.ffdc.SAFErrorCode;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileLogAnnotation;

public abstract class SurveyActionServiceConnector
extends ConnectorBase
implements SurveyActionService,
AuditLoggingComponent {
    protected final PropertyHelper propertyHelper = new PropertyHelper();
    protected Connector connector = null;
    protected static ObjectMapper objectMapper = new ObjectMapper();
    protected String surveyActionServiceName = "<Unknown>";
    protected SurveyContext surveyContext = null;
    protected AuditLog auditLog = null;
    protected List<Connector> embeddedConnectors = null;

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public String getJSONProperties(Object properties) throws PropertyServerException {
        String methodName = "getJSONProperties";
        try {
            return objectMapper.writeValueAsString(properties);
        }
        catch (JsonProcessingException parsingError) {
            throw new PropertyServerException(SAFErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.surveyActionServiceName, ((Object)((Object)parsingError)).getClass().getName(), "getJSONProperties", parsingError.getMessage()), this.getClass().getName(), "getJSONProperties", (Throwable)parsingError);
        }
    }

    public void setSurveyContext(SurveyContext surveyContext) {
        this.surveyContext = surveyContext;
    }

    public void setSurveyActionServiceName(String surveyActionServiceName) {
        this.surveyActionServiceName = surveyActionServiceName;
    }

    protected <T> Connector performCheckAssetAnalysisStep(Class<T> expectedConnectorClass, String expectedAssetType) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectionCheckedException {
        String methodName = "performCheckAssetAnalysisStep";
        this.performCheckAssetAnalysisStep(expectedAssetType);
        SurveyAssetStore assetStore = this.surveyContext.getAssetStore();
        Connector connector = assetStore.getConnectorToAsset();
        if (expectedConnectorClass.isInstance(connector)) {
            connector.start();
            return connector;
        }
        this.surveyContext.recordCompletionStatus(SurveyActionGuard.SURVEY_INVALID.getCompletionStatus(), Collections.singletonList(SurveyActionGuard.SURVEY_INVALID.getName()), null, null, SAFAuditCode.WRONG_TYPE_OF_CONNECTOR.getMessageDefinition(this.surveyActionServiceName, connector.getClass().getName(), expectedConnectorClass.getName(), assetStore.getAssetGUID()));
        throw new ConnectorCheckedException(SAFErrorCode.WRONG_TYPE_OF_CONNECTOR.getMessageDefinition(this.surveyActionServiceName, connector.getClass().getName(), expectedConnectorClass.getName(), assetStore.getAssetGUID()), this.getClass().getName(), "performCheckAssetAnalysisStep");
    }

    protected void performCheckAssetAnalysisStep(String expectedAssetType) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "performCheckAssetAnalysisStep";
        AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
        SurveyAssetStore assetStore = this.surveyContext.getAssetStore();
        annotationStore.setAnalysisStep(AnalysisStep.CHECK_ASSET.getName());
        AssetUniverse assetUniverse = assetStore.getAssetProperties();
        if (assetUniverse == null) {
            this.surveyContext.recordCompletionStatus(SurveyActionGuard.SURVEY_INVALID.getCompletionStatus(), Collections.singletonList(SurveyActionGuard.SURVEY_INVALID.getName()), null, null, SAFAuditCode.NO_ASSET.getMessageDefinition(assetStore.getAssetGUID(), this.surveyActionServiceName));
            super.throwNoAsset(assetStore.getAssetGUID(), this.surveyActionServiceName, "performCheckAssetAnalysisStep");
        } else if (!this.propertyHelper.isTypeOf((ElementControlHeader)assetUniverse, expectedAssetType)) {
            this.surveyContext.recordCompletionStatus(SurveyActionGuard.SURVEY_INVALID.getCompletionStatus(), Collections.singletonList(SurveyActionGuard.SURVEY_INVALID.getName()), null, null, SAFAuditCode.WRONG_TYPE_OF_ASSET.getMessageDefinition(assetUniverse.getGUID(), assetUniverse.getType().getTypeName(), this.surveyActionServiceName, expectedAssetType));
            throw new ConnectorCheckedException(SAFErrorCode.INVALID_ASSET_TYPE.getMessageDefinition(assetUniverse.getGUID(), assetUniverse.getType().getTypeName(), this.surveyActionServiceName, expectedAssetType), this.getClass().getName(), "performCheckAssetAnalysisStep");
        }
    }

    protected NestedSchemaType getNestedSchemaType(AssetUniverse assetUniverse, String schemaTypeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectorCheckedException {
        NestedSchemaType nestedSchemaType;
        String methodName = "getNestedSchemaType";
        SchemaType rootSchemaType = assetUniverse.getRootSchemaType();
        if (rootSchemaType instanceof NestedSchemaType && this.propertyHelper.isTypeOf((ElementControlHeader)(nestedSchemaType = (NestedSchemaType)rootSchemaType), schemaTypeName)) {
            if (nestedSchemaType.getSchemaAttributes() != null && nestedSchemaType.getSchemaAttributes().hasNext()) {
                return nestedSchemaType;
            }
            this.surveyContext.recordCompletionStatus(SurveyActionGuard.SURVEY_INVALID.getCompletionStatus(), Collections.singletonList(SurveyActionGuard.SURVEY_INVALID.getName()), null, null, SAFAuditCode.NO_SCHEMA_ATTRIBUTES.getMessageDefinition(this.surveyActionServiceName, assetUniverse.getGUID()));
            throw new ConnectorCheckedException(SAFErrorCode.NO_SCHEMA_ATTRIBUTES.getMessageDefinition(this.surveyActionServiceName, assetUniverse.getGUID()), this.getClass().getName(), "getNestedSchemaType");
        }
        if (rootSchemaType != null) {
            this.surveyContext.recordCompletionStatus(SurveyActionGuard.SURVEY_INVALID.getCompletionStatus(), Collections.singletonList(SurveyActionGuard.SURVEY_INVALID.getName()), null, null, SAFAuditCode.INVALID_ROOT_SCHEMA_TYPE.getMessageDefinition(assetUniverse.getGUID(), assetUniverse.getType().getTypeName(), this.surveyActionServiceName, schemaTypeName));
            super.throwWrongTypeOfRootSchema(assetUniverse.getGUID(), rootSchemaType.getType().getTypeName(), schemaTypeName, this.surveyActionServiceName, "getNestedSchemaType");
        }
        return null;
    }

    protected void throwMissingSchemaType(String assetGUID) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "throwMissingSchemaType";
        this.surveyContext.recordCompletionStatus(SurveyActionGuard.SURVEY_INVALID.getCompletionStatus(), Collections.singletonList(SurveyActionGuard.SURVEY_INVALID.getName()), null, null, SAFAuditCode.NO_SCHEMA.getMessageDefinition(this.surveyActionServiceName, assetGUID));
        throw new ConnectorCheckedException(SAFErrorCode.NO_SCHEMA.getMessageDefinition(this.surveyActionServiceName, assetGUID), this.getClass().getName(), "throwMissingSchemaType");
    }

    protected SurveyContext getSurveyContext() throws ConnectorCheckedException {
        String methodName = "getSurveyContext";
        this.validateIsActive("getSurveyContext");
        return this.surveyContext;
    }

    protected synchronized AnnotationStore getAnnotationStore() throws ConnectorCheckedException {
        String methodName = "getAnnotationStore";
        this.validateIsActive("getAnnotationStore");
        return this.surveyContext.getAnnotationStore();
    }

    protected void setUpAnnotation(Annotation annotation, AnnotationType annotationType) {
        annotation.setAnnotationType(annotationType.getName());
        annotation.setAnalysisStep(annotationType.getAnalysisStep());
        annotation.setSummary(annotationType.getSummary());
        annotation.setExplanation(annotationType.getExplanation());
        annotation.setExpression(annotationType.getExpression());
    }

    protected ResourceProfileLogAnnotation writePropertyListInventory(AnnotationType annotationType, String inventoryName, List<String> propertyNames, List<Map<String, String>> propertyList, String surveyReportGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, IOException, ConnectorCheckedException {
        ResourceProfileLogAnnotation inventoryLog = new ResourceProfileLogAnnotation();
        this.setUpAnnotation(inventoryLog, annotationType);
        ArrayList<String> dataProfileDataGUIDs = new ArrayList<String>();
        dataProfileDataGUIDs.add(this.setUpExternalPropertyListLogFile(surveyReportGUID, inventoryName, propertyNames, propertyList));
        inventoryLog.setResourceProfileLogGUIDs(dataProfileDataGUIDs);
        return inventoryLog;
    }

    private String setUpExternalPropertyListLogFile(String surveyReportGUID, String inventoryName, List<String> propertyNames, List<Map<String, String>> propertyList) throws IOException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectorCheckedException {
        String methodName = "setUpExternalNamePropertiesLogFile";
        String logFileName = "surveys/report-" + surveyReportGUID + "-" + inventoryName + ".csv";
        File logFile = new File(logFileName);
        boolean newLogFile = false;
        if (propertyList != null) {
            try {
                FileUtils.sizeOf((File)logFile);
            }
            catch (IllegalArgumentException notFound) {
                newLogFile = true;
            }
            ArrayList<String> columnList = new ArrayList<String>(propertyNames);
            StringBuilder fileHeader = new StringBuilder();
            boolean isFirstElement = true;
            for (String columnName : columnList) {
                if (isFirstElement) {
                    isFirstElement = false;
                    fileHeader.append(columnName);
                    continue;
                }
                fileHeader.append(",").append(columnName);
            }
            fileHeader.append("\n");
            FileUtils.writeStringToFile((File)logFile, (String)fileHeader.toString(), (String)null, (boolean)false);
            SurveyAssetStore surveyAssetStore = this.surveyContext.getAssetStore();
            String assetGUID = surveyAssetStore.addCSVFileToCatalog(inventoryName + " for survey report " + surveyReportGUID, "Provides an inventory of the resources discovered during the survey.", logFile.getAbsolutePath(), null, Character.valueOf(','), Character.valueOf('\"'));
            if (newLogFile) {
                this.auditLog.logMessage("setUpExternalNamePropertiesLogFile", SAFAuditCode.CREATING_LOG_FILE.getMessageDefinition(this.surveyActionServiceName, logFileName, assetGUID));
            } else {
                this.auditLog.logMessage("setUpExternalNamePropertiesLogFile", SAFAuditCode.REUSING_LOG_FILE.getMessageDefinition(this.surveyActionServiceName, logFileName));
            }
            for (Map<String, String> properties : propertyList) {
                StringBuilder row = new StringBuilder();
                isFirstElement = true;
                for (String columnName : columnList) {
                    if (isFirstElement) {
                        isFirstElement = false;
                        row.append(properties.get(columnName));
                        continue;
                    }
                    row.append(",").append(properties.get(columnName));
                }
                row.append("\n");
                FileUtils.writeStringToFile((File)logFile, (String)row.toString(), (String)null, (boolean)true);
            }
            return assetGUID;
        }
        return null;
    }

    protected ResourceProfileLogAnnotation writeNameListInventory(AnnotationType annotationType, String inventoryName, List<String> names, String surveyReportGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, IOException, ConnectorCheckedException {
        ResourceProfileLogAnnotation inventoryLog = new ResourceProfileLogAnnotation();
        this.setUpAnnotation(inventoryLog, annotationType);
        ArrayList<String> dataProfileDataGUIDs = new ArrayList<String>();
        dataProfileDataGUIDs.add(this.setUpExternalNamesLogFile(surveyReportGUID, inventoryName, names));
        inventoryLog.setResourceProfileLogGUIDs(dataProfileDataGUIDs);
        return inventoryLog;
    }

    private String setUpExternalNamesLogFile(String surveyReportGUID, String inventoryName, List<String> names) throws IOException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectorCheckedException {
        String methodName = "setUpExternalNamesLogFile";
        String logFileName = "surveys/report-" + surveyReportGUID + "-" + inventoryName + ".csv";
        File logFile = new File(logFileName);
        boolean newLogFile = false;
        try {
            FileUtils.sizeOf((File)logFile);
        }
        catch (IllegalArgumentException notFound) {
            newLogFile = true;
            FileUtils.writeStringToFile((File)logFile, (String)"Name\n", (String)null, (boolean)false);
        }
        SurveyAssetStore surveyAssetStore = this.surveyContext.getAssetStore();
        String assetGUID = surveyAssetStore.addCSVFileToCatalog(inventoryName + " for survey report " + surveyReportGUID, "Provides an inventory of the resources discovered during the survey.", logFile.getAbsolutePath(), null, Character.valueOf(','), Character.valueOf('\"'));
        if (newLogFile) {
            this.auditLog.logMessage("setUpExternalNamesLogFile", SAFAuditCode.CREATING_LOG_FILE.getMessageDefinition(this.surveyActionServiceName, logFileName, assetGUID));
        } else {
            this.auditLog.logMessage("setUpExternalNamesLogFile", SAFAuditCode.REUSING_LOG_FILE.getMessageDefinition(this.surveyActionServiceName, logFileName));
        }
        for (String name : names) {
            String row = name + "\n";
            FileUtils.writeStringToFile((File)logFile, (String)row, (String)null, (boolean)true);
        }
        return assetGUID;
    }

    protected ResourceProfileLogAnnotation writeNameCountInventory(AnnotationType annotationType, String inventoryName, Map<String, Integer> nameCounts, String surveyReportGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, IOException, ConnectorCheckedException {
        ResourceProfileLogAnnotation inventoryLog = new ResourceProfileLogAnnotation();
        this.setUpAnnotation(inventoryLog, annotationType);
        ArrayList<String> dataProfileDataGUIDs = new ArrayList<String>();
        dataProfileDataGUIDs.add(this.setUpExternalNameCountLogFile(surveyReportGUID, inventoryName, nameCounts));
        inventoryLog.setResourceProfileLogGUIDs(dataProfileDataGUIDs);
        return inventoryLog;
    }

    private String setUpExternalNameCountLogFile(String surveyReportGUID, String inventoryName, Map<String, Integer> nameCounts) throws IOException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectorCheckedException {
        String methodName = "setUpExternalNameCountLogFile";
        String logFileName = "surveys/report-" + surveyReportGUID + "-" + inventoryName + ".csv";
        File logFile = new File(logFileName);
        boolean newLogFile = false;
        try {
            FileUtils.sizeOf((File)logFile);
        }
        catch (IllegalArgumentException notFound) {
            newLogFile = true;
            FileUtils.writeStringToFile((File)logFile, (String)"Name, Number of Occurrences\n", (String)null, (boolean)false);
        }
        SurveyAssetStore surveyAssetStore = this.surveyContext.getAssetStore();
        String assetGUID = surveyAssetStore.addCSVFileToCatalog(inventoryName + " for survey report " + surveyReportGUID, "Provides an inventory of the resources discovered during the survey.", logFile.getAbsolutePath(), null, Character.valueOf(','), Character.valueOf('\"'));
        if (newLogFile) {
            this.auditLog.logMessage("setUpExternalNameCountLogFile", SAFAuditCode.CREATING_LOG_FILE.getMessageDefinition(this.surveyActionServiceName, logFileName, assetGUID));
        } else {
            this.auditLog.logMessage("setUpExternalNameCountLogFile", SAFAuditCode.REUSING_LOG_FILE.getMessageDefinition(this.surveyActionServiceName, logFileName));
        }
        for (String fileName : nameCounts.keySet()) {
            String row = fileName + "," + nameCounts.get(fileName) + "\n";
            FileUtils.writeStringToFile((File)logFile, (String)row, (String)null, (boolean)true);
        }
        return assetGUID;
    }

    protected ResourceProfileLogAnnotation writeNameDescriptionInventory(AnnotationType annotationType, String inventoryName, Map<String, String> nameDescriptions, String surveyReportGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, IOException, ConnectorCheckedException {
        ResourceProfileLogAnnotation inventoryLog = new ResourceProfileLogAnnotation();
        this.setUpAnnotation(inventoryLog, annotationType);
        ArrayList<String> dataProfileDataGUIDs = new ArrayList<String>();
        dataProfileDataGUIDs.add(this.setUpExternalNameDescriptionLogFile(surveyReportGUID, inventoryName, nameDescriptions));
        inventoryLog.setResourceProfileLogGUIDs(dataProfileDataGUIDs);
        return inventoryLog;
    }

    private String setUpExternalNameDescriptionLogFile(String surveyReportGUID, String inventoryName, Map<String, String> nameDescriptions) throws IOException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectorCheckedException {
        String methodName = "setUpExternalNameDescriptionLogFile";
        String logFileName = "surveys/report-" + surveyReportGUID + "-" + inventoryName + ".csv";
        File logFile = new File(logFileName);
        boolean newLogFile = false;
        try {
            FileUtils.sizeOf((File)logFile);
        }
        catch (IllegalArgumentException notFound) {
            newLogFile = true;
            FileUtils.writeStringToFile((File)logFile, (String)"Name, Description\n", (String)null, (boolean)false);
        }
        SurveyAssetStore surveyAssetStore = this.surveyContext.getAssetStore();
        String assetGUID = surveyAssetStore.addCSVFileToCatalog(inventoryName + " for survey report " + surveyReportGUID, "Provides an inventory of the resources discovered during the survey.", logFile.getAbsolutePath(), null, Character.valueOf(','), Character.valueOf('\"'));
        if (newLogFile) {
            this.auditLog.logMessage("setUpExternalNameDescriptionLogFile", SAFAuditCode.CREATING_LOG_FILE.getMessageDefinition(this.surveyActionServiceName, logFileName, assetGUID));
        } else {
            this.auditLog.logMessage("setUpExternalNameDescriptionLogFile", SAFAuditCode.REUSING_LOG_FILE.getMessageDefinition(this.surveyActionServiceName, logFileName));
        }
        for (String fileName : nameDescriptions.keySet()) {
            String row = fileName + "," + nameDescriptions.get(fileName) + "\n";
            FileUtils.writeStringToFile((File)logFile, (String)row, (String)null, (boolean)true);
        }
        return assetGUID;
    }

    private void validateIsActive(String methodName) throws ConnectorCheckedException {
        if (!this.isActive()) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, SAFAuditCode.DISCONNECT_DETECTED.getMessageDefinition(this.surveyActionServiceName));
            }
            throw new ConnectorCheckedException(SAFErrorCode.DISCONNECT_DETECTED.getMessageDefinition(this.surveyActionServiceName), this.getClass().getName(), methodName);
        }
    }

    protected List<SurveyActionServiceConnector> getEmbeddedSurveyActionServices() throws ConnectorCheckedException {
        String methodName = "getEmbeddedSurveyActionServices";
        ArrayList<SurveyActionServiceConnector> surveyActionServiceConnectors = null;
        if (this.embeddedConnectors != null) {
            surveyActionServiceConnectors = new ArrayList<SurveyActionServiceConnector>();
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (embeddedConnector == null) continue;
                if (embeddedConnector instanceof SurveyActionServiceConnector) {
                    surveyActionServiceConnectors.add((SurveyActionServiceConnector)embeddedConnector);
                    continue;
                }
                throw new ConnectorCheckedException(SAFErrorCode.INVALID_EMBEDDED_SURVEY_ACTION_SERVICE.getMessageDefinition(this.surveyActionServiceName), this.getClass().getName(), "getEmbeddedSurveyActionServices");
            }
            if (surveyActionServiceConnectors.isEmpty()) {
                surveyActionServiceConnectors = null;
            }
        }
        return surveyActionServiceConnectors;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        if (this.surveyContext == null) {
            throw new ConnectorCheckedException(SAFErrorCode.NULL_SURVEY_CONTEXT.getMessageDefinition(this.surveyActionServiceName), this.getClass().getName(), "start");
        }
    }

    protected void handleUnexpectedException(String methodName, Exception error) throws ConnectorCheckedException {
        throw new ConnectorCheckedException(SAFErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.surveyActionServiceName, error.getClass().getName(), methodName, error.getMessage()), this.getClass().getName(), methodName);
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        if (this.connector != null) {
            this.connector.disconnect();
        }
        if (this.surveyContext != null) {
            this.surveyContext.disconnect();
        }
        super.disconnect();
    }
}

