/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;

public enum SurveyActionGuard {
    SURVEY_COMPLETED("survey-completed", CompletionStatus.ACTIONED, "The survey completed successfully.  The survey report is attached to the asset."),
    SURVEY_INVALID("survey-invalid", CompletionStatus.INVALID, "The survey did not run because the supplied information (such as the asset) is invalid for this type of survey."),
    SURVEY_FAILED("survey-failed", CompletionStatus.FAILED, "An unexpected error occurred during the survey process.  The survey report is incomplete."),
    DATA_CERTIFIED("data-certified", CompletionStatus.ACTIONED, "All of the quality checks on the data succeeded.  The data has been certified."),
    DATA_NOT_CERTIFIED("data-not-certified", CompletionStatus.ACTIONED, "One or more of the quality checks on the data failed.  The data has not been certified and a request for action has been raised."),
    MISSING_CERTIFICATION_TYPE("missing-certification-type", CompletionStatus.INVALID, "The certification type is not supplied in the action targets.  This means the survey is not able to certify the data if it is correct."),
    MISSING_SCHEMA_TYPE("missing-schema-type", CompletionStatus.INVALID, "The surveyed asset does not have a schema type attached.  This means the survey is not able to certify that the data is stored in the correct structure.");

    public final String name;
    public final CompletionStatus completionStatus;
    public final String description;

    private SurveyActionGuard(String name, CompletionStatus completionStatus, String description) {
        this.name = name;
        this.completionStatus = completionStatus;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<GuardType> getSimpleSurveyGuardTypes() {
        ArrayList<GuardType> guardTypes = new ArrayList<GuardType>();
        guardTypes.add(SURVEY_COMPLETED.getGuardType());
        guardTypes.add(SURVEY_INVALID.getGuardType());
        guardTypes.add(SURVEY_FAILED.getGuardType());
        return guardTypes;
    }

    public static List<GuardType> getDataValidationSurveyGuardTypes() {
        ArrayList<GuardType> guardTypes = new ArrayList<GuardType>();
        guardTypes.add(DATA_CERTIFIED.getGuardType());
        guardTypes.add(DATA_NOT_CERTIFIED.getGuardType());
        guardTypes.add(MISSING_CERTIFICATION_TYPE.getGuardType());
        guardTypes.add(MISSING_SCHEMA_TYPE.getGuardType());
        guardTypes.add(SURVEY_FAILED.getGuardType());
        return guardTypes;
    }

    public GuardType getGuardType() {
        GuardType guardType = new GuardType();
        guardType.setGuard(this.name);
        guardType.setDescription(this.description);
        guardType.setCompletionStatus(this.completionStatus);
        return guardType;
    }

    public String toString() {
        return "SurveyActionGuard{ name='" + this.name + "}";
    }
}

