/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassifier;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyOpenMetadataStore;
import org.odpi.openmetadata.frameworks.surveyaction.ffdc.SAFAuditCode;
import org.odpi.openmetadata.frameworks.surveyaction.ffdc.SAFErrorCode;

public class SurveyContext {
    private final String userId;
    private final String assetGUID;
    private final Map<String, String> requestParameters;
    private final List<ActionTargetElement> actionTargetElements;
    private final SurveyAssetStore assetStore;
    private final AnnotationStore annotationStore;
    private final SurveyOpenMetadataStore openMetadataStore;
    private final String surveyActionServiceName;
    private final String requesterUserId;
    private final AuditLog auditLog;
    private final FileClassifier fileClassifier;
    private boolean isActive = true;
    private CompletionStatus completionStatus = null;
    private List<String> completionGuards = null;
    private AuditLogMessageDefinition completionMessage = null;
    private Map<String, String> completionRequestParameters = null;
    private List<NewActionTarget> completionActionTargets = null;

    public SurveyContext(String userId, String assetGUID, Map<String, String> requestParameters, List<ActionTargetElement> actionTargetElements, SurveyAssetStore assetStore, AnnotationStore annotationStore, SurveyOpenMetadataStore openMetadataStore, String surveyActionServiceName, String requesterUserId, AuditLog auditLog) {
        this.userId = userId;
        this.assetGUID = assetGUID;
        this.requestParameters = requestParameters;
        this.actionTargetElements = actionTargetElements;
        this.assetStore = assetStore;
        this.annotationStore = annotationStore;
        this.openMetadataStore = openMetadataStore;
        this.surveyActionServiceName = surveyActionServiceName;
        this.requesterUserId = requesterUserId;
        this.auditLog = auditLog;
        this.fileClassifier = new FileClassifier((OpenMetadataStore)openMetadataStore);
    }

    public String getAssetGUID() throws ConnectorCheckedException {
        String methodName = "getAssetGUID";
        this.validateIsActive("getAssetGUID");
        return this.assetGUID;
    }

    public Map<String, String> getRequestParameters() throws ConnectorCheckedException {
        String methodName = "getRequestParameters";
        this.validateIsActive("getRequestParameters");
        return this.requestParameters;
    }

    public List<ActionTargetElement> getActionTargetElements() {
        return this.actionTargetElements;
    }

    public String getRequesterUserId() {
        return this.requesterUserId;
    }

    public SurveyAssetStore getAssetStore() throws ConnectorCheckedException {
        String methodName = "getAssetStore";
        this.validateIsActive("getAssetStore");
        return this.assetStore;
    }

    public AnnotationStore getAnnotationStore() throws ConnectorCheckedException {
        String methodName = "getAnnotationStore";
        this.validateIsActive("getAnnotationStore");
        return this.annotationStore;
    }

    public SurveyOpenMetadataStore getOpenMetadataStore() throws ConnectorCheckedException {
        String methodName = "getOpenMetadataStore";
        this.validateIsActive("getOpenMetadataStore");
        return this.openMetadataStore;
    }

    public FileClassifier getFileClassifier() throws ConnectorCheckedException {
        String methodName = "getFileClassifier";
        this.validateIsActive("getFileClassifier");
        return this.fileClassifier;
    }

    public boolean elementShouldBeSurveyed(String elementName, List<String> excludedNames, List<String> includedNames) {
        if (elementName == null) {
            return false;
        }
        if (includedNames != null) {
            return includedNames.contains(elementName);
        }
        if (excludedNames != null) {
            return !excludedNames.contains(elementName);
        }
        return true;
    }

    public void disconnect() throws ConnectorCheckedException {
        this.isActive = false;
    }

    private void validateIsActive(String methodName) throws ConnectorCheckedException {
        if (!this.isActive) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, SAFAuditCode.DISCONNECT_DETECTED.getMessageDefinition(this.surveyActionServiceName));
            }
            throw new ConnectorCheckedException(SAFErrorCode.DISCONNECT_DETECTED.getMessageDefinition(this.surveyActionServiceName), this.getClass().getName(), methodName);
        }
    }

    public void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, Map<String, String> requestParameters, List<NewActionTarget> newActionTargets, AuditLogMessageDefinition completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.completionStatus = status;
        this.completionGuards = outputGuards;
        this.completionRequestParameters = requestParameters;
        this.completionActionTargets = newActionTargets;
        this.completionMessage = completionMessage;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public List<String> getCompletionGuards() {
        return this.completionGuards;
    }

    public AuditLogMessageDefinition getCompletionMessage() {
        return this.completionMessage;
    }

    public Map<String, String> getCompletionRequestParameters() {
        return this.completionRequestParameters;
    }

    public List<NewActionTarget> getCompletionActionTargets() {
        return this.completionActionTargets;
    }

    public String toString() {
        return "SurveyContext{userId='" + this.userId + "', assetGUID='" + this.assetGUID + "', requestParameters=" + String.valueOf(this.requestParameters) + ", actionTargetElements=" + String.valueOf(this.actionTargetElements) + ", assetStore=" + String.valueOf(this.assetStore) + ", annotationStore=" + String.valueOf(this.annotationStore) + ", openMetadataStore=" + String.valueOf((Object)this.openMetadataStore) + ", surveyActionServiceName='" + this.surveyActionServiceName + "', requesterUserId='" + this.requesterUserId + "', fileClassifier=" + String.valueOf(this.fileClassifier) + ", isActive=" + this.isActive + ", completionStatus=" + String.valueOf(this.completionStatus) + ", completionGuards=" + String.valueOf(this.completionGuards) + ", completionMessage=" + String.valueOf(this.completionMessage) + ", completionRequestParameters=" + String.valueOf(this.completionRequestParameters) + ", completionActionTargets=" + String.valueOf(this.completionActionTargets) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        SurveyContext that = (SurveyContext)objectToCompare;
        return this.isActive == that.isActive && Objects.equals(this.userId, that.userId) && Objects.equals(this.assetGUID, that.assetGUID) && Objects.equals(this.requestParameters, that.requestParameters) && Objects.equals(this.actionTargetElements, that.actionTargetElements) && Objects.equals(this.assetStore, that.assetStore) && Objects.equals(this.annotationStore, that.annotationStore) && Objects.equals((Object)this.openMetadataStore, (Object)that.openMetadataStore) && Objects.equals(this.surveyActionServiceName, that.surveyActionServiceName) && Objects.equals(this.requesterUserId, that.requesterUserId) && Objects.equals(this.auditLog, that.auditLog) && Objects.equals(this.fileClassifier, that.fileClassifier) && this.completionStatus == that.completionStatus && Objects.equals(this.completionGuards, that.completionGuards) && Objects.equals(this.completionMessage, that.completionMessage) && Objects.equals(this.completionRequestParameters, that.completionRequestParameters) && Objects.equals(this.completionActionTargets, that.completionActionTargets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userId, this.assetGUID, this.requestParameters, this.actionTargetElements, this.assetStore, this.annotationStore, this.openMetadataStore, this.surveyActionServiceName, this.requesterUserId, this.auditLog, this.fileClassifier, this.isActive, this.completionStatus, this.completionGuards, this.completionMessage, this.completionRequestParameters, this.completionActionTargets});
    }
}

