/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTargetType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public enum SurveyActionTarget {
    SURVEY_REPORT("surveyReport", "The survey report created by a survey action service.", OpenMetadataType.SURVEY_REPORT.typeName, null),
    STEWARD("steward", "The person, or team who is responsible for setting up the governance metadata associated with .", OpenMetadataType.ACTOR.typeName, null),
    TO_DO_ELEMENT("stewardAction", "To Do element created for the steward.", OpenMetadataType.TO_DO.typeName, null);

    public final String name;
    public final String description;
    public final String typeName;
    private final String deployedImplementationType;

    private SurveyActionTarget(String name, String description, String typeName, String deployedImplementationType) {
        this.name = name;
        this.description = description;
        this.typeName = typeName;
        this.deployedImplementationType = deployedImplementationType;
    }

    public static List<ActionTargetType> getStewardshipReviewActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(STEWARD.getActionTargetType());
        actionTargetTypes.add(SURVEY_REPORT.getActionTargetType());
        return actionTargetTypes;
    }

    public static List<ActionTargetType> getStewardshipHandoverActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(TO_DO_ELEMENT.getActionTargetType());
        return actionTargetTypes;
    }

    public static List<ActionTargetType> getReportActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(SURVEY_REPORT.getActionTargetType());
        return actionTargetTypes;
    }

    public static List<ActionTargetType> getActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        for (SurveyActionTarget actionTarget : SurveyActionTarget.values()) {
            actionTargetTypes.add(actionTarget.getActionTargetType());
        }
        return actionTargetTypes;
    }

    public ActionTargetType getActionTargetType() {
        ActionTargetType actionTargetType = new ActionTargetType();
        actionTargetType.setName(this.name);
        actionTargetType.setDescription(this.description);
        actionTargetType.setTypeName(this.typeName);
        actionTargetType.setDeployedImplementationType(this.deployedImplementationType);
        return actionTargetType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public String toString() {
        return "SurveyActionTarget{name='" + this.name + "}";
    }
}

