/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum SAFAuditCode implements AuditLogMessageSet
{
    DISCONNECT_DETECTED("SAF-CONNECTOR-0001", AuditLogRecordSeverityLevel.INFO, "The {0} survey action service has been disconnected - either due to its own actions or a cancel request", "The survey action framework will attempt to stop the work of the survey action framework", "Monitor the shutdown of the survey action service."),
    WRONG_TYPE_OF_CONNECTOR("SAF-CONNECTOR-0002", AuditLogRecordSeverityLevel.ERROR, "The {0} Survey Action Service has been supplied with a resource connector of class {1} rather than class {2} for asset {3}", "The survey is unable to continue since it is unable to work with the supplied connector.", "Use the details from the error message to determine the class of the connector.  Update the connector type associated with its Connection in the metadata store."),
    CREATING_LOG_FILE("SAF-CONNECTOR-0003", AuditLogRecordSeverityLevel.INFO, "The survey action service {0} is creating log file {1} which is catalogued as CSVFile asset {2}", "This message tells the survey team that a particular survey log file is being created.", "No specific action is required.  The results are added to the log file and the asset for this log file is catalogued as a CSV file."),
    REUSING_LOG_FILE("SAF-CONNECTOR-0004", AuditLogRecordSeverityLevel.INFO, "The survey action service {0} is overriding log file {1}", "This message warns the survey team that a particular survey log file is being reused.", "No specific action is required.  The new results are appended to the existing results."),
    NO_ASSET("SAF-CONNECTOR-0005", AuditLogRecordSeverityLevel.ERROR, "No information about the asset {0} has been returned from the asset store for survey action framework {1}", "The service terminates without running the requested function.", "This is an unexpected condition because the lack of an asset should have been caught before this point."),
    WRONG_TYPE_OF_ASSET("SAF-CONNECTOR-0006", AuditLogRecordSeverityLevel.ERROR, "Asset {0} is of type {1} but survey action service {2} only supports the following asset type(s): {3}", "The survey action service terminates.", "The caller has requested a governance request type that is incompatible with the type of the asset that has been supplied.  This problem could be resolved by issuing the survey request with a governance request type that is compatible with the asset, or changing the survey action service associated with the governance request type to one that supports this type of asset."),
    INVALID_ROOT_SCHEMA_TYPE("SAF-CONNECTOR-0007", AuditLogRecordSeverityLevel.ERROR, "Asset {0} has a root schema of type {1} but survey action service {2} only supports the following root schema type(s): {3}", "The survey action service terminates because it can not proceed.", "The caller has requested a governance request type that is unable to process a root schema for an asset because its type is unsupported.  This problem could be resolved by issuing the survey request with a governance request type that is compatible with the asset's schema, or changing the survey action service associated with the governance request type to one that supports this type of schema."),
    NO_SCHEMA("SAF-CONNECTOR-0008", AuditLogRecordSeverityLevel.ERROR, "The {0} Survey Acton Service has been supplied with asset {1} which does not have a schema attached", "The survey is unable to continue since it is unable to assess whether the data stored in the associated resource matches the desired schema.", "Update the asset to include the desired schema and re-run this survey.  If you want to discover the asset's schema then use a different survey service."),
    NO_SCHEMA_ATTRIBUTES("SAF-CONNECTOR-0009", AuditLogRecordSeverityLevel.ERROR, "The {0} Survey Acton Service has been supplied with asset {1} which does not have any schema attributes attached", "The survey is unable to continue since it is unable to assess whether the data stored in the associated resource matches the desired schema because there are no schema attributes attached to the root schema.", "Update the asset to include the desired schema attributes and re-run this survey.  If you want to discover the asset's schema then use a different survey service.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private SAFAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "SAFAuditCode{logMessageId='" + this.logMessageId + "', severity=" + String.valueOf(this.severity) + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

