/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum SAFErrorCode implements ExceptionMessageSet
{
    NULL_SURVEY_CONTEXT(400, "SURVEY-ACTION-SERVICE-400-001", "No survey context supplied to the survey action service {0}", "The survey action service is not able to determine which asset to analyze.", "This may be a configuration or a code error.  Look for other error messages and review the code of the survey action service.  Once the cause is resolved, retry the survey action request."),
    NO_EMBEDDED_SURVEY_ACTION_SERVICES(400, "SURVEY-ACTION-SERVICE-400-002", "No embedded survey action services supplied to the survey action pipeline {0}", "The survey action pipeline is not able to survey action which survey action services to run.", "This may be a configuration or a code error.  Look for other error messages and review the code of the survey action pipeline service.  Once the cause is resolved, retry the survey action request."),
    INVALID_EMBEDDED_SURVEY_ACTION_SERVICE(400, "SURVEY-ACTION-SERVICE-400-003", "No embedded survey action services supplied to the survey action pipeline {0}", "The survey action pipeline is not able to discover which survey action services to run.", "This may be a configuration or a code error.  Look for other error messages and review the code of the survey action pipeline service or the associated open survey action engine.  Once the cause is resolved, retry the survey action request."),
    DISCONNECT_DETECTED(400, "SURVEY-ACTION-SERVICE-400-004", "The {0} survey action service has been disconnected - either due to its own actions or a cancel request", "The survey action framework will attempt to stop the work of the survey action framework", "Monitor the shutdown of the survey action service."),
    INVALID_ASSET_TYPE(400, "SURVEY-ACTION-SERVICE-400-005", "Asset {0} is of type {1} but survey action service {2} only supports the following asset type(s): {3}", "The survey action service terminates.", "The caller has requested a governance request type that is incompatible with the type of the asset that has been supplied.  This problem could be resolved by issuing the survey request with a governance request type that is compatible with the asset, or changing the survey action service associated with the governance request type to one that supports this type of asset."),
    WRONG_TYPE_OF_CONNECTOR(400, "SURVEY-ACTION-SERVICE-400-006", "The {0} Survey Acton Service has been supplied with a resource connector of class {1} rather than class {2} for asset {3}", "The survey is unable to continue since it is unable to work with the supplied connector.", "Use the details from the error message to determine the class of the connector.  Update the connector type associated with its Connection in the metadata store."),
    NO_SCHEMA(400, "SURVEY-ACTION-SERVICE-400-007", "The {0} Survey Acton Service has been supplied with asset {1} which does not have a schema attached", "The survey is unable to continue since it is unable to assess whether the data stored in the associated resource matches the desired schema.", "Update the asset to include the desired schema and re-run this survey.  If you want to discover the asset's schema then use a different survey service."),
    NO_SCHEMA_ATTRIBUTES(400, "SURVEY-ACTION-SERVICE-400-008", "The {0} Survey Acton Service has been supplied with asset {1} which does not have any schema attributes attached", "The survey is unable to continue since it is unable to assess whether the data stored in the associated resource matches the desired schema because there are no schema attributes attached to the root schema.", "Update the asset to include the desired schema attributes and re-run this survey.  If you want to discover the asset's schema then use a different survey service."),
    UNEXPECTED_EXCEPTION(500, "SURVEY-ACTION-SERVICE-500-001", "Unexpected exception in survey action service {0} of type {1} detected by method {2}.  The error message was {3}", "The survey action service failed during its operation.", "This may be a configuration or a code error.  Look for other error messages and review the code of the survey action service.  Once the cause is resolved, retry the survey action request.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private SAFErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "SAFErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

