/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.measurements;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.types.DataType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum RelationalColumnMetric implements SurveyMetric
{
    COLUMN_QNAME("columnQualifiedName", DataType.STRING.getName(), "Column qualified name", "Qualified name of the column showing the database name, schema name and table name."),
    COLUMN_NAME("columnName", DataType.STRING.getName(), "Column name", "Name of the column within the table."),
    COLUMN_SIZE("columnSize", DataType.LONG.getName(), "Column size", "Number of stored bytes in the column."),
    COLUMN_TYPE("columnDataType", DataType.STRING.getName(), "Column data type", "Data type of column."),
    AVERAGE_WIDTH("averageColumnWidth", DataType.INT.getName(), "Average Column Width", "Average width of the values in this column."),
    NUMBER_OF_DISTINCT_VALUES("numberOfDistinctValues", DataType.LONG.getName(), "Number Of Distinct Values", "Number of distinct values stored in this column."),
    MOST_COMMON_VALUES("mostCommonValues", DataType.STRING.getName(), "Most Common Values", "List of the most common values stored in this column."),
    MOST_COMMON_VALUES_FREQUENCY("mostCommonValuesFrequency", DataType.STRING.getName(), "Most Common Values Frequency", "The frequency that each of the most common values occur."),
    COLUMN_NOT_NULL("columnNotNull", DataType.BOOLEAN.getName(), "Not Null", "Is a null value prohibited in this column?");

    public final String propertyName;
    public final String dataType;
    public final String displayName;
    public final String description;

    private RelationalColumnMetric(String propertyName, String dataType, String displayName, String description) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static List<SurveyMetric> getMetrics() {
        return new ArrayList<SurveyMetric>(List.of(RelationalColumnMetric.values()));
    }

    public String toString() {
        return "RelationalColumnMetric{" + this.displayName + "}";
    }
}

