/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.measurements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.types.DataType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum RelationalTableMetric implements SurveyMetric
{
    TABLE_SIZE("tableSize", DataType.LONG.getName(), "Table Size", "Number of stored bytes in the table."),
    TABLE_NAME("tableName", DataType.STRING.getName(), "Table Name", "Name of table."),
    TABLE_QNAME("tableQualifiedName", DataType.STRING.getName(), "Table Qualified Name", "Qualified name of table showing the database name and schema name."),
    TABLE_TYPE("tableType", DataType.STRING.getName(), "Table Type", "Is this a standard table, view or materialized view?"),
    TABLE_OWNER("tableOwner", DataType.STRING.getName(), "Resource Owner", "Who owns this resource?"),
    COLUMN_COUNT("columnCount", DataType.LONG.getName(), "Number of columns", "Count of columns in the table/view."),
    NUMBER_OF_ROWS_INSERTED("numberOfRowsInserted", DataType.LONG.getName(), "Number Of Rows Inserted", "Count of the number of rows inserted into this table since the last statistics reset."),
    NUMBER_OF_ROWS_UPDATED("numberOfRowsUpdated", DataType.LONG.getName(), "Number Of Rows Updated", "Count of the number of rows updated in this table since the last statistics reset."),
    NUMBER_OF_ROWS_DELETED("numberOfRowsDeleted", DataType.LONG.getName(), "Number Of Rows Deleted", "Count of the number of rows deleted from this table since the last statistics reset."),
    IS_POPULATED("isPopulated", DataType.BOOLEAN.getName(), "Is Populated", "Is this table populated (typically true)?"),
    HAS_INDEXES("hasIndexes", DataType.BOOLEAN.getName(), "Has Indexes", "Is this table indexed?"),
    HAS_RULES("hasRules", DataType.BOOLEAN.getName(), "Has Rules", "Does this table have rules attached?"),
    HAS_TRIGGERS("hasTriggers", DataType.BOOLEAN.getName(), "Has Triggers", "Does this table have triggers attached?"),
    HAS_ROW_SECURITY("hasRowSecurity", DataType.BOOLEAN.getName(), "Has Row Security", "Is this table configured for row-based security?"),
    QUERY_DEFINITION("queryDefinition", DataType.STRING.getName(), "Query Definition", "Which query, if any, is used to create this view or materialized view?");

    public final String propertyName;
    public final String dataType;
    public final String displayName;
    public final String description;

    private RelationalTableMetric(String propertyName, String dataType, String displayName, String description) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static List<SurveyMetric> getMetrics() {
        return new ArrayList<SurveyMetric>(Arrays.asList(RelationalTableMetric.values()));
    }

    public String toString() {
        return "RelationalTableMetric{" + this.displayName + "}";
    }
}

