/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.surveyaction.properties.DataFieldAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelationshipAdviceAnnotation
extends DataFieldAnnotation {
    private String relatedEntityGUID = null;
    private String relationshipTypeName = null;
    private Map<String, String> relationshipProperties = null;

    public RelationshipAdviceAnnotation() {
    }

    public RelationshipAdviceAnnotation(RelationshipAdviceAnnotation template) {
        super(template);
        if (template != null) {
            this.relatedEntityGUID = template.getRelatedEntityGUID();
            this.relationshipTypeName = template.getRelationshipTypeName();
            this.relationshipProperties = template.getRelationshipProperties();
        }
    }

    public String getRelatedEntityGUID() {
        return this.relatedEntityGUID;
    }

    public void setRelatedEntityGUID(String relatedEntityGUID) {
        this.relatedEntityGUID = relatedEntityGUID;
    }

    public String getRelationshipTypeName() {
        return this.relationshipTypeName;
    }

    public void setRelationshipTypeName(String relationshipTypeName) {
        this.relationshipTypeName = relationshipTypeName;
    }

    public Map<String, String> getRelationshipProperties() {
        return this.relationshipProperties;
    }

    public void setRelationshipProperties(Map<String, String> relationshipProperties) {
        this.relationshipProperties = relationshipProperties;
    }

    @Override
    public String toString() {
        return "RelationshipAdviceAnnotation{relatedEntityGUID='" + this.relatedEntityGUID + "', relationshipTypeName='" + this.relationshipTypeName + "', relationshipProperties=" + String.valueOf(this.relationshipProperties) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RelationshipAdviceAnnotation that = (RelationshipAdviceAnnotation)objectToCompare;
        return Objects.equals(this.relatedEntityGUID, that.relatedEntityGUID) && Objects.equals(this.relationshipTypeName, that.relationshipTypeName) && Objects.equals(this.relationshipProperties, that.relationshipProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relatedEntityGUID, this.relationshipTypeName, this.relationshipProperties);
    }
}

