/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.surveyaction.handlers;

import org.odpi.openmetadata.accessservices.assetowner.client.CSVFileAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.ConnectedAssetClient;
import org.odpi.openmetadata.accessservices.assetowner.client.FileSystemAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceContextClient;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceEngineConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.engineservices.surveyaction.handlers.SurveyActionEngineHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.registration.GovernanceEngineHandlerFactory;

public class SurveyActionEngineHandlerFactory
extends GovernanceEngineHandlerFactory {
    public GovernanceEngineHandler createGovernanceEngineHandler(EngineConfig engineConfig, String localServerName, String localServerUserId, String localServerPassword, String partnerServerName, String partnerURLRoot, GovernanceEngineConfigurationClient configurationClient, GovernanceContextClient serverClient, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        if (engineConfig != null) {
            OpenMetadataStoreClient openMetadataClient;
            CSVFileAssetOwner csvFileAssetOwner;
            FileSystemAssetOwner fileSystemAssetOwner;
            ConnectedAssetClient surveyActionEngineClient;
            if (localServerPassword == null) {
                surveyActionEngineClient = new ConnectedAssetClient(partnerServerName, partnerURLRoot);
                fileSystemAssetOwner = new FileSystemAssetOwner(partnerServerName, partnerURLRoot);
                csvFileAssetOwner = new CSVFileAssetOwner(partnerServerName, partnerURLRoot);
                openMetadataClient = new OpenMetadataStoreClient(partnerServerName, partnerURLRoot, maxPageSize);
            } else {
                surveyActionEngineClient = new ConnectedAssetClient(partnerServerName, partnerURLRoot, localServerUserId, localServerPassword);
                fileSystemAssetOwner = new FileSystemAssetOwner(partnerServerName, partnerURLRoot, localServerUserId, localServerPassword);
                csvFileAssetOwner = new CSVFileAssetOwner(partnerServerName, partnerURLRoot, localServerUserId, localServerPassword);
                openMetadataClient = new OpenMetadataStoreClient(partnerServerName, partnerURLRoot, localServerUserId, localServerPassword, maxPageSize);
            }
            return new SurveyActionEngineHandler(engineConfig, localServerName, localServerUserId, configurationClient, serverClient, surveyActionEngineClient, fileSystemAssetOwner, csvFileAssetOwner, (OpenMetadataClient)openMetadataClient, auditLog, maxPageSize);
        }
        return null;
    }
}

