/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.surveyaction.handlers;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceContextClient;
import org.odpi.openmetadata.engineservices.surveyaction.ffdc.SurveyActionAuditCode;
import org.odpi.openmetadata.engineservices.surveyaction.ffdc.SurveyActionErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceEngineProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyContext;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyActionGuard;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;

public class SurveyActionServiceHandler
extends GovernanceServiceHandler {
    private final SurveyActionServiceConnector surveyActionService;
    private final SurveyContext surveyContext;

    SurveyActionServiceHandler(GovernanceEngineProperties surveyActionEngineProperties, String surveyActionEngineGUID, String engineHostUserId, String engineActionGUID, GovernanceContextClient engineActionClient, String serviceRequestType, String surveyActionServiceGUID, String surveyActionServiceName, Connector surveyActionServiceConnector, SurveyContext surveyContext, Date requestedStartDate, AuditLog auditLog) throws InvalidParameterException {
        super(surveyActionEngineProperties, surveyActionEngineGUID, engineHostUserId, engineActionGUID, engineActionClient, serviceRequestType, surveyActionServiceGUID, surveyActionServiceName, surveyActionServiceConnector, requestedStartDate, auditLog);
        this.surveyContext = surveyContext;
        try {
            this.surveyActionService = (SurveyActionServiceConnector)surveyActionServiceConnector;
        }
        catch (Exception error) {
            String surveyActionServiceConnectorParameterName = "surveyActionServiceConnector";
            String actionDescription = "Cast connector to SurveyActionService";
            auditLog.logException("Cast connector to SurveyActionService", SurveyActionAuditCode.INVALID_SURVEY_ACTION_SERVICE.getMessageDefinition(new String[]{surveyActionServiceName, serviceRequestType, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            throw new InvalidParameterException(SurveyActionErrorCode.INVALID_SURVEY_SERVICE.getMessageDefinition(new String[]{surveyActionServiceName, serviceRequestType, error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "Cast connector to SurveyActionService", (Throwable)error, "surveyActionServiceConnector");
        }
    }

    public void run() {
        String surveyReportGUID = null;
        String actionDescription = "Survey an Asset";
        try {
            super.waitForStartDate(this.engineHostUserId);
            surveyReportGUID = this.surveyContext.getAnnotationStore().getSurveyReportGUID();
            this.auditLog.logMessage("Survey an Asset", SurveyActionAuditCode.SURVEY_ACTION_SERVICE_STARTING.getMessageDefinition(new String[]{this.governanceServiceName, this.surveyContext.getAssetGUID(), this.serviceRequestType, this.governanceEngineProperties.getQualifiedName(), this.governanceEngineGUID, surveyReportGUID}));
            this.surveyActionService.setSurveyContext(this.surveyContext);
            this.surveyActionService.setSurveyActionServiceName(this.governanceServiceName);
            Date startTime = new Date();
            this.surveyActionService.start();
            this.surveyContext.getAnnotationStore().setCompletionMessage(null);
            Date endTime = new Date();
            this.auditLog.logMessage("Survey an Asset", SurveyActionAuditCode.SURVEY_ACTION_SERVICE_COMPLETE.getMessageDefinition(new String[]{this.governanceServiceName, this.surveyContext.getAssetGUID(), this.serviceRequestType, Long.toString(endTime.getTime() - startTime.getTime()), surveyReportGUID}));
            super.disconnect();
            this.surveyActionService.setSurveyContext(null);
            ArrayList<String> outputGuards = new ArrayList<String>();
            outputGuards.add(SurveyActionGuard.SURVEY_COMPLETED.getName());
            ArrayList<NewActionTarget> newActionTargets = new ArrayList<NewActionTarget>();
            NewActionTarget newActionTarget = new NewActionTarget();
            newActionTarget.setActionTargetGUID(surveyReportGUID);
            newActionTarget.setActionTargetName("surveyReport");
            newActionTargets.add(newActionTarget);
            super.recordCompletionStatus(CompletionStatus.ACTIONED, outputGuards, null, newActionTargets, "SUCCESS");
        }
        catch (Exception error) {
            try {
                this.surveyContext.getAnnotationStore().setCompletionMessage(error.getMessage());
                ArrayList<String> outputGuards = new ArrayList<String>();
                outputGuards.add(SurveyActionGuard.SURVEY_FAILED.getName());
                super.recordCompletionStatus(CompletionStatus.FAILED, outputGuards, null, null, error.getMessage());
                this.auditLog.logException("Survey an Asset", SurveyActionAuditCode.SURVEY_ACTION_SERVICE_FAILED.getMessageDefinition(new String[]{this.governanceServiceName, error.getClass().getName(), surveyReportGUID, this.surveyContext.getAssetGUID(), this.serviceRequestType, this.governanceEngineProperties.getQualifiedName(), this.governanceEngineGUID, error.getMessage()}), error.toString(), (Throwable)error);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

