/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.surveyaction.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.client.CSVFileAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.ConnectedAssetClient;
import org.odpi.openmetadata.accessservices.assetowner.client.FileSystemAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.SurveyAssetStoreClient;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceContextClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.engineservices.surveyaction.ffdc.SurveyActionAuditCode;
import org.odpi.openmetadata.engineservices.surveyaction.ffdc.SurveyActionErrorCode;
import org.odpi.openmetadata.engineservices.surveyaction.handlers.SurveyActionServiceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyContext;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyOpenMetadataStore;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceCache;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;

public class SurveyActionEngineHandler
extends GovernanceEngineHandler {
    private final ConnectedAssetClient connectedAssetClient;
    private final FileSystemAssetOwner fileSystemAssetOwner;
    private final CSVFileAssetOwner csvFileAssetOwner;
    private final OpenMetadataClient openMetadataClient;
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public SurveyActionEngineHandler(EngineConfig engineConfig, String serverName, String serverUserId, GovernanceConfigurationClient configurationClient, GovernanceContextClient engineActionClient, ConnectedAssetClient connectedAssetClient, FileSystemAssetOwner fileSystemAssetOwner, CSVFileAssetOwner csvFileAssetOwner, OpenMetadataClient openMetadataClient, AuditLog auditLog, int maxPageSize) {
        super(engineConfig, serverName, serverUserId, EngineServiceDescription.SURVEY_ACTION_OMES.getEngineServiceFullName(), configurationClient, engineActionClient, auditLog, maxPageSize);
        this.connectedAssetClient = connectedAssetClient;
        this.fileSystemAssetOwner = fileSystemAssetOwner;
        this.csvFileAssetOwner = csvFileAssetOwner;
        this.openMetadataClient = openMetadataClient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runGovernanceService(String engineActionGUID, String governanceRequestType, String requesterUserId, Date requestedStartDate, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "runGovernanceService";
        super.validateGovernanceEngineInitialized(OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "runGovernanceService");
        GovernanceServiceCache governanceServiceCache = super.getServiceCache(governanceRequestType);
        if (governanceServiceCache == null) throw new InvalidParameterException(SurveyActionErrorCode.NULL_REQUEST.getMessageDefinition(new String[]{engineActionGUID}), ((Object)((Object)this)).getClass().getName(), "runGovernanceService", "governanceServiceCache");
        if (actionTargetElements == null || actionTargetElements.isEmpty()) throw new InvalidParameterException(SurveyActionErrorCode.NO_TARGET_ASSET.getMessageDefinition(new String[]{governanceServiceCache.getGovernanceServiceName(), governanceRequestType, engineActionGUID}), ((Object)((Object)this)).getClass().getName(), "runGovernanceService", "assetGUID");
        String assetGUID = this.getAssetGUIDFromActionTargets(actionTargetElements, governanceServiceCache.getGovernanceServiceName(), governanceRequestType, engineActionGUID);
        if (assetGUID == null) {
            throw new InvalidParameterException(SurveyActionErrorCode.NO_TARGET_ASSET.getMessageDefinition(new String[]{governanceServiceCache.getGovernanceServiceName(), governanceRequestType, engineActionGUID}), ((Object)((Object)this)).getClass().getName(), "runGovernanceService", "assetGUID");
        }
        SurveyActionServiceHandler surveyActionServiceHandler = this.getSurveyActionServiceHandler(assetGUID, governanceRequestType, requestParameters, actionTargetElements, engineActionGUID, requesterUserId, requestedStartDate, governanceServiceCache);
        super.startServiceExecutionThread(engineActionGUID, (GovernanceServiceHandler)surveyActionServiceHandler, governanceServiceCache.getGovernanceServiceName() + assetGUID + new Date());
    }

    private String getAssetGUIDFromActionTargets(List<ActionTargetElement> actionTargetElements, String governanceServiceName, String governanceRequestType, String engineActionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetGUIDFromActionTargets";
        String assetGUID = null;
        ArrayList<String> ignoredAssets = new ArrayList<String>();
        ArrayList<ActionTargetElement> assetTargetElements = new ArrayList<ActionTargetElement>();
        for (ActionTargetElement actionTargetElement : actionTargetElements) {
            if (actionTargetElement == null || !this.propertyHelper.isTypeOf((ElementControlHeader)actionTargetElement.getTargetElement(), OpenMetadataType.ASSET.typeName)) continue;
            assetTargetElements.add(actionTargetElement);
        }
        if (assetTargetElements.size() == 1) {
            assetGUID = ((ActionTargetElement)assetTargetElements.get(0)).getTargetElement().getElementGUID();
        } else {
            for (ActionTargetElement actionTargetElement : assetTargetElements) {
                if (!ActionTarget.NEW_ASSET.getName().equals(actionTargetElement.getActionTargetName())) continue;
                if (assetGUID == null) {
                    assetGUID = actionTargetElement.getTargetElement().getElementGUID();
                    this.engineActionClient.updateActionTargetStatus(this.serverUserId, actionTargetElement.getActionTargetRelationshipGUID(), EngineActionStatus.IN_PROGRESS, new Date(), null, null);
                    continue;
                }
                ignoredAssets.add(actionTargetElement.getTargetElement().getElementGUID());
            }
            if (!ignoredAssets.isEmpty()) {
                this.auditLog.logMessage("getAssetGUIDFromActionTargets", SurveyActionAuditCode.IGNORING_ASSETS.getMessageDefinition(new String[]{governanceServiceName, governanceRequestType, engineActionGUID, assetGUID, ((Object)ignoredAssets).toString()}));
            }
        }
        return assetGUID;
    }

    private SurveyActionServiceHandler getSurveyActionServiceHandler(String assetGUID, String requestType, Map<String, String> requestParameters, List<ActionTargetElement> actionTargetElements, String engineActionGUID, String requesterUserId, Date requestedStartDate, GovernanceServiceCache governanceServiceCache) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Date creationTime = new Date();
        Map analysisParameters = governanceServiceCache.getRequestParameters(requestParameters);
        String reportQualifiedName = "SurveyReport:" + requestType + ":" + assetGUID + ":" + creationTime;
        String reportDisplayName = "Survey Report for " + assetGUID;
        String reportDescription = "This is the " + requestType + " survey report for asset " + assetGUID + " generated at " + creationTime + " by the " + governanceServiceCache.getGovernanceServiceName() + " survey action service running on survey action engine " + this.governanceEngineProperties.getDisplayName() + " (" + this.governanceEngineName + ").";
        AnnotationStore annotationStore = new AnnotationStore(this.engineUserId, assetGUID, this.openMetadataClient, null, null, reportQualifiedName, reportDisplayName, reportDescription, requestType, engineActionGUID);
        SurveyAssetStoreClient assetStore = new SurveyAssetStoreClient(assetGUID, this.engineUserId, this.connectedAssetClient, this.fileSystemAssetOwner, this.csvFileAssetOwner, this.auditLog);
        SurveyOpenMetadataStore openMetadataStore = new SurveyOpenMetadataStore(this.openMetadataClient, this.engineUserId, null, null, engineActionGUID);
        SurveyContext surveyContext = new SurveyContext(this.engineUserId, assetGUID, analysisParameters, actionTargetElements, (SurveyAssetStore)assetStore, annotationStore, openMetadataStore, governanceServiceCache.getGovernanceServiceName(), requesterUserId, this.auditLog);
        return new SurveyActionServiceHandler(this.governanceEngineProperties, this.governanceEngineGUID, this.serverUserId, engineActionGUID, this.engineActionClient, governanceServiceCache.getServiceRequestType(), governanceServiceCache.getGovernanceServiceGUID(), governanceServiceCache.getGovernanceServiceName(), governanceServiceCache.getNextGovernanceService(), surveyContext, requestedStartDate, this.auditLog);
    }
}

