/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.surveyaction.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceContextClient;
import org.odpi.openmetadata.engineservices.surveyaction.ffdc.SurveyActionAuditCode;
import org.odpi.openmetadata.engineservices.surveyaction.ffdc.SurveyActionErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceEngineProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyContext;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyActionGuard;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyActionTarget;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;

public class SurveyActionServiceHandler
extends GovernanceServiceHandler {
    private final SurveyActionServiceConnector surveyActionService;
    private final SurveyContext surveyContext;
    private final String assetGUID;

    SurveyActionServiceHandler(GovernanceEngineProperties surveyActionEngineProperties, String surveyActionEngineGUID, String engineHostUserId, String engineActionGUID, GovernanceContextClient engineActionClient, String serviceRequestType, String surveyActionServiceGUID, String surveyActionServiceName, Connector surveyActionServiceConnector, SurveyContext surveyContext, Date requestedStartDate, AuditLog auditLog) throws InvalidParameterException {
        super(surveyActionEngineProperties, surveyActionEngineGUID, engineHostUserId, engineActionGUID, engineActionClient, serviceRequestType, surveyActionServiceGUID, surveyActionServiceName, surveyActionServiceConnector, requestedStartDate, auditLog);
        this.surveyContext = surveyContext;
        try {
            this.surveyActionService = (SurveyActionServiceConnector)surveyActionServiceConnector;
            this.assetGUID = surveyContext.getAssetGUID();
        }
        catch (Exception error) {
            String surveyActionServiceConnectorParameterName = "surveyActionServiceConnector";
            String actionDescription = "Cast connector to SurveyActionService";
            auditLog.logException("Cast connector to SurveyActionService", SurveyActionAuditCode.INVALID_SURVEY_ACTION_SERVICE.getMessageDefinition(new String[]{surveyActionServiceName, serviceRequestType, error.getClass().getName(), error.getMessage()}), (Throwable)error);
            throw new InvalidParameterException(SurveyActionErrorCode.INVALID_SURVEY_SERVICE.getMessageDefinition(new String[]{surveyActionServiceName, serviceRequestType, error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "Cast connector to SurveyActionService", (Throwable)error, "surveyActionServiceConnector");
        }
    }

    public void run() {
        List<Object> completionActionTargets;
        Map completionRequestParameters;
        AuditLogMessageDefinition completionMessage;
        List<String> completionGuards;
        CompletionStatus completionStatus;
        String surveyReportGUID;
        block10: {
            surveyReportGUID = null;
            String actionDescription = "Survey an Asset";
            try {
                super.waitForStartDate(this.engineHostUserId);
                surveyReportGUID = this.surveyContext.getAnnotationStore().getSurveyReportGUID();
                this.auditLog.logMessage("Survey an Asset", SurveyActionAuditCode.SURVEY_ACTION_SERVICE_STARTING.getMessageDefinition(new String[]{this.governanceServiceName, this.surveyContext.getAssetGUID(), this.serviceRequestType, this.governanceEngineProperties.getQualifiedName(), this.governanceEngineGUID, surveyReportGUID}));
                this.surveyActionService.setSurveyContext(this.surveyContext);
                this.surveyActionService.setSurveyActionServiceName(this.governanceServiceName);
                Date startTime = new Date();
                this.surveyActionService.start();
                this.surveyContext.getAnnotationStore().setCompletionMessage(null);
                Date endTime = new Date();
                completionStatus = this.surveyContext.getCompletionStatus();
                completionGuards = this.surveyContext.getCompletionGuards();
                completionMessage = this.surveyContext.getCompletionMessage();
                completionRequestParameters = this.surveyContext.getCompletionRequestParameters();
                completionActionTargets = this.surveyContext.getCompletionActionTargets();
                if (completionStatus == null) {
                    completionStatus = SurveyActionGuard.SURVEY_COMPLETED.getCompletionStatus();
                }
                if (completionGuards == null || completionGuards.isEmpty()) {
                    completionGuards = new ArrayList();
                    completionGuards.add(SurveyActionGuard.SURVEY_COMPLETED.getName());
                }
                if (completionMessage == null) {
                    completionMessage = SurveyActionAuditCode.SURVEY_ACTION_SERVICE_COMPLETE.getMessageDefinition(new String[]{this.governanceServiceName, this.surveyContext.getAssetGUID(), this.serviceRequestType, Long.toString(endTime.getTime() - startTime.getTime()), surveyReportGUID});
                }
            }
            catch (Exception error) {
                completionStatus = this.surveyContext.getCompletionStatus();
                completionGuards = this.surveyContext.getCompletionGuards();
                completionMessage = this.surveyContext.getCompletionMessage();
                completionRequestParameters = this.surveyContext.getCompletionRequestParameters();
                completionActionTargets = this.surveyContext.getCompletionActionTargets();
                if (completionStatus == null) {
                    completionStatus = SurveyActionGuard.SURVEY_FAILED.getCompletionStatus();
                }
                if (completionGuards == null || completionGuards.isEmpty()) {
                    completionGuards = new ArrayList<String>();
                    completionGuards.add(SurveyActionGuard.SURVEY_FAILED.getName());
                }
                if (completionMessage != null) break block10;
                completionMessage = SurveyActionAuditCode.SURVEY_ACTION_SERVICE_FAILED.getMessageDefinition(new String[]{this.governanceServiceName, error.getClass().getName(), surveyReportGUID, this.assetGUID, this.serviceRequestType, this.governanceEngineProperties.getQualifiedName(), this.governanceEngineGUID, error.getMessage()});
            }
        }
        try {
            if (completionActionTargets == null) {
                completionActionTargets = new ArrayList<NewActionTarget>();
            }
            NewActionTarget reportActionTarget = new NewActionTarget();
            reportActionTarget.setActionTargetGUID(surveyReportGUID);
            reportActionTarget.setActionTargetName(SurveyActionTarget.SURVEY_REPORT.getName());
            completionActionTargets.add(reportActionTarget);
            MessageFormatter messageFormatter = new MessageFormatter();
            String messageText = messageFormatter.getFormattedMessage((MessageDefinition)completionMessage);
            this.auditLog.logMessage("Survey an Asset", completionMessage);
            this.surveyContext.getAnnotationStore().setCompletionMessage(messageText);
            super.recordCompletionStatus(completionStatus, completionGuards, completionRequestParameters, completionActionTargets, messageText);
            super.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

