/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.surveyaction.admin;

import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.engineservices.surveyaction.ffdc.SurveyActionAuditCode;
import org.odpi.openmetadata.engineservices.surveyaction.ffdc.SurveyActionErrorCode;
import org.odpi.openmetadata.engineservices.surveyaction.server.SurveyActionInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.EngineServiceAdmin;
import org.odpi.openmetadata.governanceservers.enginehostservices.enginemap.GovernanceEngineMap;

public class SurveyActionAdmin
extends EngineServiceAdmin {
    private SurveyActionInstance surveyActionInstance = null;

    public void initialize(String localServerId, String localServerName, AuditLog auditLog, String localServerUserId, String localServerPassword, int maxPageSize, GovernanceConfigurationClient configurationClient, EngineServiceConfig engineServiceConfig, GovernanceEngineMap governanceEngineMap) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize engine service";
        String methodName = "initialize";
        this.auditLog = auditLog;
        this.localServerName = localServerName;
        try {
            this.validateConfigDocument(engineServiceConfig);
            String accessServiceRootURL = this.getPartnerServiceRootURL(engineServiceConfig);
            String accessServiceServerName = this.getPartnerServiceServerName(engineServiceConfig);
            auditLog.logMessage("initialize engine service", SurveyActionAuditCode.ENGINE_SERVICE_INITIALIZING.getMessageDefinition(new String[]{localServerName, accessServiceServerName, accessServiceRootURL}));
            governanceEngineMap.setGovernanceEngineProperties(engineServiceConfig.getEngines(), accessServiceServerName, accessServiceRootURL);
            this.surveyActionInstance = new SurveyActionInstance(localServerName, EngineServiceDescription.SURVEY_ACTION_OMES.getEngineServiceName(), auditLog, localServerUserId, maxPageSize, engineServiceConfig.getOMAGServerPlatformRootURL(), engineServiceConfig.getOMAGServerName());
        }
        catch (Exception error) {
            auditLog.logException("initialize engine service", SurveyActionAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{localServerName, error.getMessage()}), error.toString(), (Throwable)error);
            throw new OMAGConfigurationErrorException(SurveyActionErrorCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{localServerName, error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "initialize", error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", SurveyActionAuditCode.SERVER_SHUTTING_DOWN.getMessageDefinition(new String[]{this.localServerName}));
        this.surveyActionInstance.shutdown();
        this.auditLog.logMessage("shutdown", SurveyActionAuditCode.SERVER_SHUTDOWN.getMessageDefinition(new String[]{this.localServerName}));
    }
}

