/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.surveyaction.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorReportResponse;
import org.odpi.openmetadata.engineservices.surveyaction.server.SurveyActionRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/engine-services/survey-action/users/{userId}"})
@Tag(name="Engine Host: Survey Action OMES", description="The Survey Action OMES provide the core subsystem for driving requests for automated metadata survey services.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omes/survey-action/overview/"))
public class SurveyActionResource {
    private final SurveyActionRESTServices restAPI = new SurveyActionRESTServices();

    @GetMapping(path={"/validate-connector/{connectorProviderClassName}"})
    @Operation(summary="validateConnector", description="Validate the connector and return its connector type.  The engine service does not need to be running in the engine host in order for this call to be successful.  The engine service only needs to be registered with the engine host.", externalDocs=@ExternalDocumentation(description="Survey Action Service", url="https://egeria-project.org/concepts/survey-action-service"))
    public ConnectorReportResponse validateConnector(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorProviderClassName) {
        return this.restAPI.validateConnector(serverName, userId, connectorProviderClassName);
    }
}

