/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetClassificationInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetCollectionInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetConnectionManagementInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetDecommissioningInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetKnowledgeInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingInterface;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetReviewInterface;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwnerBaseClient;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.CollectionElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.CollectionMember;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.RelationshipElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.CollectionFolderProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.CollectionMembershipProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.CollectionProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.DataFieldQueryProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.DataFieldValuesProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.FindAssetOriginProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.GovernanceClassificationProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.RetentionClassificationProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SemanticAssignmentProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.assetowner.rest.AnnotationListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.AssetElementResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.AssetElementsResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.CalculatedValueClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.CombinedSchemaRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ConnectionRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.ElementHeaderResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.EmbeddedConnectionRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.OriginRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.OwnerRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.RelationshipElementResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.RelationshipElementsResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.SchemaAttributeElementResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.SchemaAttributeElementsResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.SchemaTypeElementResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.SchemaTypeElementsResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.SecurityTagsRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.StatusRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.SurveyReportListResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.TemplateClassificationRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.UpdateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SurveyReport;

public class AssetOwner
extends AssetOwnerBaseClient
implements AssetKnowledgeInterface,
AssetOnboardingInterface,
AssetClassificationInterface,
AssetConnectionManagementInterface,
AssetCollectionInterface,
AssetReviewInterface,
AssetDecommissioningInterface {
    private static final String serviceURLName = "asset-owner";
    private static final String defaultAssetType = "Asset";

    public AssetOwner(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public AssetOwner(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public AssetOwner(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public AssetOwner(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public AssetOwner(String serverName, String serverPlatformURLRoot, AssetOwnerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    @Override
    public AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.getAssetProperties(serviceURLName, userId, assetGUID);
    }

    @Override
    public List<String> getTypesOfAsset(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAsset";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/sub-types";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAsset");
        NameListResponse restResult = this.restClient.callNameListGetRESTCall("getTypesOfAsset", urlTemplate, this.serverName, userId);
        return restResult.getNames();
    }

    @Override
    public Map<String, String> getTypesOfAssetWithDescriptions(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAssetWithDescriptions";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/sub-types/descriptions";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAssetWithDescriptions");
        StringMapResponse restResult = this.restClient.callStringMapGetRESTCall("getTypesOfAssetWithDescriptions", urlTemplate, this.serverName, userId);
        return restResult.getStringMap();
    }

    @Override
    public String addAssetToCatalog(String userId, String typeName, String qualifiedName, String name, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetToCatalog";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "addAssetToCatalog");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "addAssetToCatalog");
        AssetProperties assetProperties = new AssetProperties();
        assetProperties.setTypeName(typeName);
        assetProperties.setQualifiedName(qualifiedName);
        assetProperties.setName(name);
        assetProperties.setDescription(description);
        assetProperties.setAdditionalProperties(additionalProperties);
        assetProperties.setExtendedProperties(extendedProperties);
        return this.addAssetToCatalog(userId, assetProperties);
    }

    @Override
    public String addAssetToCatalog(String userId, AssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetToCatalog";
        String assetPropertiesParameterName = "assetProperties";
        String qualifiedNameParameter = "assetProperties.qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}";
        this.invalidParameterHandler.validateUserId(userId, "addAssetToCatalog");
        this.invalidParameterHandler.validateObject(assetProperties, "assetProperties", "addAssetToCatalog");
        this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", "addAssetToCatalog");
        if (assetProperties.getTypeName() == null) {
            assetProperties.setTypeName(defaultAssetType);
        }
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addAssetToCatalog", urlTemplate, assetProperties, this.serverName, userId, assetProperties.getTypeName());
        return restResult.getGUID();
    }

    @Override
    public String addAssetToCatalogUsingTemplate(String userId, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/from-template/{2}";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createDatabaseFromTemplate");
        this.invalidParameterHandler.validateObject(templateProperties, "templateProperties", "createDatabaseFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createDatabaseFromTemplate");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseFromTemplate", urlTemplate, templateProperties, this.serverName, userId, templateGUID);
        return restResult.getGUID();
    }

    @Override
    public void updateAsset(String userId, String assetGUID, boolean isMergeUpdate, AssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAsset";
        String assetGUIDParameterName = "assetGUID";
        String propertiesParameterName = "assetProperties";
        String qualifiedNameParameterName = "assetProperties.qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/update?isMergeUpdate={3}";
        this.invalidParameterHandler.validateUserId(userId, "updateAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateAsset");
        this.invalidParameterHandler.validateObject(assetProperties, "assetProperties", "updateAsset");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(assetProperties.getQualifiedName(), "assetProperties.qualifiedName", "updateAsset");
        }
        this.restClient.callVoidPostRESTCall("updateAsset", urlTemplate, assetProperties, this.serverName, userId, assetGUID, isMergeUpdate);
    }

    @Override
    public String setupRelatedAsset(String userId, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, RelationshipProperties relationshipProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupRelatedAsset";
        String fromAssetGUIDParameterName = "fromAssetGUID";
        String toAssetGUIDParameterName = "toAssetGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "setupRelatedAsset");
        this.invalidParameterHandler.validateGUID(fromAssetGUID, "fromAssetGUID", "setupRelatedAsset");
        this.invalidParameterHandler.validateGUID(toAssetGUID, "toAssetGUID", "setupRelatedAsset");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "setupRelatedAsset");
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setProperties(relationshipProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/relationships/{2}/from-asset/{3}/to-asset/{4}";
        GUIDResponse results = this.restClient.callGUIDPostRESTCall("setupRelatedAsset", urlTemplate, requestBody, this.serverName, userId, relationshipTypeName, fromAssetGUID, toAssetGUID);
        return results.getGUID();
    }

    @Override
    public RelationshipElement getAssetRelationship(String userId, String relationshipTypeName, String fromAssetGUID, String toAssetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssetRelationship";
        String fromAssetGUIDParameterName = "fromAssetGUID";
        String toAssetGUIDParameterName = "toAssetGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "getAssetRelationship");
        this.invalidParameterHandler.validateGUID(fromAssetGUID, "fromAssetGUID", "getAssetRelationship");
        this.invalidParameterHandler.validateGUID(toAssetGUID, "toAssetGUID", "getAssetRelationship");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "getAssetRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/relationships/{2}/from-asset/{3}/to-asset/{4}/retrieve";
        RelationshipElementResponse restResult = this.restClient.callRelationshipPostRESTCall("getAssetRelationship", urlTemplate, new EffectiveTimeQueryRequestBody(), this.serverName, userId, relationshipTypeName, fromAssetGUID, toAssetGUID);
        return restResult.getElement();
    }

    @Override
    public void updateAssetRelationship(String userId, String relationshipTypeName, String relationshipGUID, boolean isMergeUpdate, RelationshipProperties relationshipProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetRelationship";
        String relationshipGUIDParameterName = "relationshipGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "updateAssetRelationship");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateAssetRelationship");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "updateAssetRelationship");
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setProperties(relationshipProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/relationships/{2}/{3}/update?isMergeUpdate={4}";
        this.restClient.callVoidPostRESTCall("updateAssetRelationship", urlTemplate, requestBody, this.serverName, userId, relationshipTypeName, relationshipGUID, isMergeUpdate);
    }

    @Override
    public void clearAssetRelationship(String userId, String relationshipTypeName, String relationshipGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetRelationship";
        String relationshipGUIDParameterName = "relationshipGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "clearAssetRelationship");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "clearAssetRelationship");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "clearAssetRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/relationships/{2}/{3}/remove";
        this.restClient.callVoidPostRESTCall("clearAssetRelationship", urlTemplate, new EffectiveTimeQueryRequestBody(), this.serverName, userId, relationshipTypeName, relationshipGUID);
    }

    @Override
    public List<RelationshipElement> getRelatedAssetsAtEnd2(String userId, String relationshipTypeName, String fromAssetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedAssetsAtEnd2";
        String fromAssetGUIDParameterName = "fromAssetGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedAssetsAtEnd2");
        this.invalidParameterHandler.validateGUID(fromAssetGUID, "fromAssetGUID", "getRelatedAssetsAtEnd2");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "getRelatedAssetsAtEnd2");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/relationships/{2}/from-asset/{3}/retrieve/end2?startFrom={4}&pageSize={5}";
        RelationshipElementsResponse restResult = this.restClient.callRelationshipsPostRESTCall("getRelatedAssetsAtEnd2", urlTemplate, new EffectiveTimeQueryRequestBody(), this.serverName, userId, relationshipTypeName, fromAssetGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    @Override
    public List<RelationshipElement> getRelatedAssetsAtEnd1(String userId, String relationshipTypeName, String toAssetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedAssetsAtEnd1";
        String toAssetGUIDParameterName = "toAssetGUID";
        String typeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedAssetsAtEnd1");
        this.invalidParameterHandler.validateGUID(toAssetGUID, "toAssetGUID", "getRelatedAssetsAtEnd1");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "getRelatedAssetsAtEnd1");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/relationships/{2}/to-asset/{3}/retrieve/end1?startFrom={4}&pageSize={5}";
        RelationshipElementsResponse restResult = this.restClient.callRelationshipsPostRESTCall("getRelatedAssetsAtEnd1", urlTemplate, new EffectiveTimeQueryRequestBody(), this.serverName, userId, relationshipTypeName, toAssetGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    @Override
    public String addCombinedSchemaToAsset(String userId, String assetGUID, SchemaTypeProperties schemaType, List<SchemaAttributeProperties> schemaAttributes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addCombinedSchemaToAsset";
        String assetGUIDParameter = "assetGUID";
        String schemaTypeParameter = "schemaType";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/with-attributes";
        this.invalidParameterHandler.validateUserId(userId, "addCombinedSchemaToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addCombinedSchemaToAsset");
        this.invalidParameterHandler.validateObject(schemaType, "schemaType", "addCombinedSchemaToAsset");
        CombinedSchemaRequestBody requestBody = new CombinedSchemaRequestBody();
        requestBody.setSchemaType(schemaType);
        requestBody.setSchemaAttributes(schemaAttributes);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addCombinedSchemaToAsset", urlTemplate, requestBody, this.serverName, userId, assetGUID);
        return restResult.getGUID();
    }

    @Override
    public String addSchemaTypeToAsset(String userId, String assetGUID, SchemaTypeProperties schemaType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSchemaTypeToAsset";
        String assetGUIDParameter = "assetGUID";
        String schemaTypeParameter = "schemaType";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas";
        this.invalidParameterHandler.validateUserId(userId, "addSchemaTypeToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSchemaTypeToAsset");
        this.invalidParameterHandler.validateObject(schemaType, "schemaType", "addSchemaTypeToAsset");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addSchemaTypeToAsset", urlTemplate, schemaType, this.serverName, userId, assetGUID);
        return restResult.getGUID();
    }

    @Override
    public void attachSchemaTypeToAsset(String userId, String assetGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachSchemaTypeToAsset";
        String assetGUIDParameter = "assetGUID";
        String schemaTypeParameter = "schemaTypeGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/{3}/attach";
        this.invalidParameterHandler.validateUserId(userId, "attachSchemaTypeToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "attachSchemaTypeToAsset");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "attachSchemaTypeToAsset");
        this.restClient.callVoidPostRESTCall("attachSchemaTypeToAsset", urlTemplate, this.nullRequestBody, this.serverName, userId, assetGUID, schemaTypeGUID);
    }

    @Override
    public String detachSchemaTypeFromAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachSchemaTypeFromAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/detach";
        this.invalidParameterHandler.validateUserId(userId, "detachSchemaTypeFromAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "detachSchemaTypeFromAsset");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("detachSchemaTypeFromAsset", urlTemplate, this.nullRequestBody, this.serverName, userId, assetGUID);
        return restResult.getGUID();
    }

    @Override
    public void deleteAssetSchemaType(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteAssetSchemaType";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteAssetSchemaType");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "deleteAssetSchemaType");
        this.restClient.callVoidPostRESTCall("deleteAssetSchemaType", urlTemplate, this.nullRequestBody, this.serverName, userId, assetGUID);
    }

    @Override
    public String createSchemaType(String userId, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaType";
        return this.createSchemaType(userId, null, schemaTypeProperties, "createSchemaType");
    }

    @Override
    public String createAnchoredSchemaType(String userId, String anchorGUID, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAnchoredSchemaType";
        return this.createSchemaType(userId, anchorGUID, schemaTypeProperties, "createAnchoredSchemaType");
    }

    private String createSchemaType(String userId, String anchorGUID, SchemaTypeProperties schemaTypeProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "schemaTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject(schemaTypeProperties, "schemaTypeProperties", methodName);
        this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "schemaTypeProperties.qualifiedName", methodName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-types?anchorGUID={2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, schemaTypeProperties, this.serverName, userId, anchorGUID);
        return restResult.getGUID();
    }

    @Override
    public String createSchemaTypeFromTemplate(String userId, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaTypeFromTemplate";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaTypeFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createSchemaTypeFromTemplate");
        this.invalidParameterHandler.validateObject(templateProperties, "templateProperties", "createSchemaTypeFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createSchemaTypeFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-types/from-template/{2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaTypeFromTemplate", urlTemplate, requestBody, this.serverName, userId, templateGUID);
        return restResult.getGUID();
    }

    @Override
    public void updateSchemaType(String userId, String schemaTypeGUID, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSchemaType";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String propertiesParameterName = "schemaTypeProperties";
        String qualifiedNameParameterName = "schemaTypeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "updateSchemaType");
        this.invalidParameterHandler.validateObject(schemaTypeProperties, "schemaTypeProperties", "updateSchemaType");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(schemaTypeProperties.getQualifiedName(), "schemaTypeProperties.qualifiedName", "updateSchemaType");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-types/{2}?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateSchemaType", urlTemplate, schemaTypeProperties, this.serverName, userId, schemaTypeGUID, isMergeUpdate);
    }

    @Override
    public void setupSchemaTypeParent(String userId, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, RelationshipProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupSchemaTypeParent";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateUserId(userId, "setupSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "setupSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "setupSchemaTypeParent");
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", "setupSchemaTypeParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/parents/{2}/{3}/schema-types/{4}";
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall("setupSchemaTypeParent", urlTemplate, requestBody, this.serverName, userId, parentElementGUID, parentElementTypeName, schemaTypeGUID);
    }

    @Override
    public void clearSchemaTypeParent(String userId, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSchemaTypeParent";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateUserId(userId, "clearSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "clearSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "clearSchemaTypeParent");
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", "clearSchemaTypeParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/parents/{2}/{3}/schema-types/{4}/remove";
        this.restClient.callVoidPostRESTCall("clearSchemaTypeParent", urlTemplate, new EffectiveTimeQueryRequestBody(), this.serverName, userId, parentElementGUID, parentElementTypeName, schemaTypeGUID);
    }

    @Override
    public void setupSchemaElementRelationship(String userId, String endOneGUID, String endTwoGUID, String relationshipTypeName, RelationshipProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupSchemaElementRelationship";
        String endOneGUIDParameterName = "endOneGUID";
        String endTwoGUIDParameterName = "endTwoGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "setupSchemaElementRelationship");
        this.invalidParameterHandler.validateGUID(endOneGUID, "endOneGUID", "setupSchemaElementRelationship");
        this.invalidParameterHandler.validateGUID(endTwoGUID, "endTwoGUID", "setupSchemaElementRelationship");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "setupSchemaElementRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-elements/{2}/relationships/{3}/schema-elements/{4}";
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall("setupSchemaElementRelationship", urlTemplate, requestBody, this.serverName, userId, endOneGUID, relationshipTypeName, endTwoGUID);
    }

    @Override
    public void clearSchemaElementRelationship(String userId, String endOneGUID, String endTwoGUID, String relationshipTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSchemaElementRelationship";
        String endOneGUIDParameterName = "endOneGUID";
        String endTwoGUIDParameterName = "endTwoGUID";
        String relationshipTypeNameParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateUserId(userId, "clearSchemaElementRelationship");
        this.invalidParameterHandler.validateGUID(endOneGUID, "endOneGUID", "clearSchemaElementRelationship");
        this.invalidParameterHandler.validateGUID(endTwoGUID, "endTwoGUID", "clearSchemaElementRelationship");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "clearSchemaElementRelationship");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-elements/{2}/relationships/{3}/schema-elements/{4}/remove";
        this.restClient.callVoidPostRESTCall("clearSchemaElementRelationship", urlTemplate, new EffectiveTimeQueryRequestBody(), this.serverName, userId, endOneGUID, relationshipTypeName, endTwoGUID);
    }

    @Override
    public void removeSchemaType(String userId, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSchemaType";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeSchemaType");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "removeSchemaType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-types/{2}/remove";
        this.restClient.callVoidPostRESTCall("removeSchemaType", urlTemplate, new UpdateRequestBody(), this.serverName, userId, schemaTypeGUID);
    }

    @Override
    public List<SchemaTypeElement> findSchemaType(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSchemaType";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findSchemaType");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findSchemaType");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSchemaType");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-types/by-search-string?startFrom={2}&pageSize={3}";
        SchemaTypeElementsResponse restResult = this.restClient.callSchemaTypesPostRESTCall("findSchemaType", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public SchemaTypeElement getSchemaTypeForElement(String userId, String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeForElement";
        String guidParameterName = "parentElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeForElement");
        this.invalidParameterHandler.validateGUID(parentElementGUID, "parentElementGUID", "getSchemaTypeForElement");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/parents/{2}/{3}/schema-types/retrieve";
        SchemaTypeElementResponse restResult = this.restClient.callSchemaTypePostRESTCall("getSchemaTypeForElement", urlTemplate, new EffectiveTimeQueryRequestBody(), this.serverName, userId, parentElementTypeName, parentElementGUID);
        return restResult.getElement();
    }

    @Override
    public List<SchemaTypeElement> getSchemaTypeByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeByName");
        this.invalidParameterHandler.validateName(name, "name", "getSchemaTypeByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSchemaTypeByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-types/by-name?startFrom={2}&pageSize={3}";
        SchemaTypeElementsResponse restResult = this.restClient.callSchemaTypesPostRESTCall("getSchemaTypeByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public SchemaTypeElement getSchemaTypeByGUID(String userId, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeByGUID";
        String guidParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeByGUID");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "getSchemaTypeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-types/{2}/retrieve";
        SchemaTypeElementResponse restResult = this.restClient.callSchemaTypePostRESTCall("getSchemaTypeByGUID", urlTemplate, new EffectiveTimeQueryRequestBody(), this.serverName, userId, schemaTypeGUID);
        return restResult.getElement();
    }

    @Override
    public ElementHeader getSchemaTypeParent(String userId, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaTypeParent";
        String guidParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaTypeParent");
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", "getSchemaTypeParent");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/parents/schema-types/{2}/retrieve";
        ElementHeaderResponse restResult = this.restClient.callElementHeaderPostRESTCall("getSchemaTypeParent", urlTemplate, new EffectiveTimeQueryRequestBody(), this.serverName, userId, schemaTypeGUID);
        return restResult.getElement();
    }

    @Override
    public void addSchemaAttributes(String userId, String assetGUID, String parentGUID, List<SchemaAttributeProperties> schemaAttributes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSchemaAttributesToSchemaType";
        String assetGUIDParameter = "assetGUID";
        String parentGUIDParameter = "parentGUID";
        String schemaAttributesParameter = "schemaAttributes";
        String schemaAttributeParameter = "schemaAttributes[x]";
        String qualifiedNameParameter = "schemaAttribute[x].getQualifiedName()";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/{3}/schema-attributes/list";
        this.invalidParameterHandler.validateUserId(userId, "addSchemaAttributesToSchemaType");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSchemaAttributesToSchemaType");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "addSchemaAttributesToSchemaType");
        this.invalidParameterHandler.validateObject(schemaAttributes, "schemaAttributes", "addSchemaAttributesToSchemaType");
        for (SchemaAttributeProperties schemaAttributeProperties : schemaAttributes) {
            this.invalidParameterHandler.validateObject(schemaAttributeProperties, "schemaAttributes[x]", "addSchemaAttributesToSchemaType");
            this.invalidParameterHandler.validateName(schemaAttributeProperties.getQualifiedName(), "schemaAttribute[x].getQualifiedName()", "addSchemaAttributesToSchemaType");
        }
        this.restClient.callVoidPostRESTCall("addSchemaAttributesToSchemaType", urlTemplate, schemaAttributes, this.serverName, userId, assetGUID, parentGUID);
    }

    @Override
    public String addSchemaAttribute(String userId, String assetGUID, String parentGUID, SchemaAttributeProperties schemaAttribute) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSchemaAttributes";
        String assetGUIDParameter = "assetGUID";
        String parentGUIDParameter = "parentGUID";
        String schemaAttributeParameter = "schemaAttribute";
        String qualifiedNameParameter = "schemaAttribute.getQualifiedName()";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/schemas/{3}/schema-attributes";
        this.invalidParameterHandler.validateUserId(userId, "addSchemaAttributes");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSchemaAttributes");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "addSchemaAttributes");
        this.invalidParameterHandler.validateObject(schemaAttribute, "schemaAttribute", "addSchemaAttributes");
        this.invalidParameterHandler.validateName(schemaAttribute.getQualifiedName(), "schemaAttribute.getQualifiedName()", "addSchemaAttributes");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addSchemaAttributes", urlTemplate, schemaAttribute, this.serverName, userId, assetGUID, parentGUID);
        return restResult.getGUID();
    }

    @Override
    public String createSchemaAttributeFromTemplate(String userId, String schemaElementGUID, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttributeFromTemplate";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateObject(templateProperties, "templateProperties", "createSchemaAttributeFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "createSchemaAttributeFromTemplate");
        TemplateRequestBody requestBody = new TemplateRequestBody();
        requestBody.setElementProperties(templateProperties);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-elements/{2}/schema-attributes/from-template/{3}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSchemaAttributeFromTemplate", urlTemplate, requestBody, this.serverName, userId, schemaElementGUID, templateGUID);
        return restResult.getGUID();
    }

    @Override
    public void updateSchemaAttribute(String userId, String schemaAttributeGUID, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSchemaAttribute";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        String propertiesParameterName = "schemaAttributeProperties";
        String qualifiedNameParameterName = "schemaAttributeProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateSchemaAttribute");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "updateSchemaAttribute");
        this.invalidParameterHandler.validateObject(schemaAttributeProperties, "schemaAttributeProperties", "updateSchemaAttribute");
        if (isMergeUpdate) {
            this.invalidParameterHandler.validateName(schemaAttributeProperties.getQualifiedName(), "schemaAttributeProperties.qualifiedName", "updateSchemaAttribute");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-attributes/{2}?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateSchemaAttribute", urlTemplate, schemaAttributeProperties, this.serverName, userId, schemaAttributeGUID, isMergeUpdate);
    }

    @Override
    public void setSchemaElementAsCalculatedValue(String userId, String schemaElementGUID, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setSchemaElementAsCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "setSchemaElementAsCalculatedValue");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "setSchemaElementAsCalculatedValue");
        CalculatedValueClassificationRequestBody requestBody = new CalculatedValueClassificationRequestBody();
        requestBody.setFormula(formula);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-elements/{2}/is-calculated-value";
        this.restClient.callVoidPostRESTCall("setSchemaElementAsCalculatedValue", urlTemplate, requestBody, this.serverName, userId, schemaElementGUID);
    }

    @Override
    public void clearSchemaElementAsCalculatedValue(String userId, String schemaElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSchemaElementAsCalculatedValue";
        String schemaElementGUIDParameterName = "schemaElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearSchemaElementAsCalculatedValue");
        this.invalidParameterHandler.validateGUID(schemaElementGUID, "schemaElementGUID", "clearSchemaElementAsCalculatedValue");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-elements/{2}/is-calculated-value/remove";
        this.restClient.callVoidPostRESTCall("clearSchemaElementAsCalculatedValue", urlTemplate, new UpdateRequestBody(), this.serverName, userId, schemaElementGUID);
    }

    @Override
    public void removeSchemaAttribute(String userId, String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSchemaAttribute";
        String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeSchemaAttribute");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "removeSchemaAttribute");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-attributes/{2}/remove";
        this.restClient.callVoidPostRESTCall("removeSchemaAttribute", urlTemplate, new UpdateRequestBody(), this.serverName, userId, schemaAttributeGUID);
    }

    @Override
    public List<SchemaAttributeElement> findSchemaAttributes(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSchemaAttributes";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findSchemaAttributes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findSchemaAttributes");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSchemaAttributes");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-attributes/by-search-string?startFrom={2}&pageSize={3}";
        SchemaAttributeElementsResponse restResult = this.restClient.callSchemaAttributesPostRESTCall("findSchemaAttributes", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public List<SchemaAttributeElement> getNestedSchemaAttributes(String userId, String parentSchemaElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNestedSchemaAttributes";
        String guidParameterName = "parentSchemaElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getNestedSchemaAttributes");
        this.invalidParameterHandler.validateGUID(parentSchemaElementGUID, "parentSchemaElementGUID", "getNestedSchemaAttributes");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getNestedSchemaAttributes");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-elements/{2}/schema-attributes/retrieve?startFrom={3}&pageSize={4}";
        SchemaAttributeElementsResponse restResult = this.restClient.callSchemaAttributesPostRESTCall("getNestedSchemaAttributes", urlTemplate, new EffectiveTimeQueryRequestBody(), this.serverName, userId, parentSchemaElementGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public List<SchemaAttributeElement> getSchemaAttributesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaAttributesByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaAttributesByName");
        this.invalidParameterHandler.validateName(name, "name", "getSchemaAttributesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSchemaAttributesByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNameParameterName("name");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-attributes/by-name?startFrom={2}&pageSize={3}";
        SchemaAttributeElementsResponse restResult = this.restClient.callSchemaAttributesPostRESTCall("getSchemaAttributesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public SchemaAttributeElement getSchemaAttributeByGUID(String userId, String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSchemaAttributeByGUID";
        String guidParameterName = "schemaAttributeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSchemaAttributeByGUID");
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, "schemaAttributeGUID", "getSchemaAttributeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/schema-attributes/{2}/retrieve";
        SchemaAttributeElementResponse restResult = this.restClient.callSchemaAttributePostRESTCall("getSchemaAttributeByGUID", urlTemplate, new EffectiveTimeQueryRequestBody(), this.serverName, userId, schemaAttributeGUID);
        return restResult.getElement();
    }

    @Override
    @Deprecated
    public void addConnectionToAsset(String userId, String assetGUID, String assetSummary, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addConnectionToAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/connection";
        this.invalidParameterHandler.validateUserId(userId, "addConnectionToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addConnectionToAsset");
        ConnectionRequestBody requestBody = new ConnectionRequestBody();
        requestBody.setShortDescription(assetSummary);
        requestBody.setConnection(connection);
        this.restClient.callVoidPostRESTCall("addConnectionToAsset", urlTemplate, requestBody, this.serverName, userId, assetGUID);
    }

    @Override
    public void addSemanticAssignment(String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.addSemanticAssignment(userId, assetGUID, glossaryTermGUID, assetElementGUID, null);
    }

    @Override
    public void addSemanticAssignment(String userId, String assetGUID, String assetElementGUID, String glossaryTermGUID, SemanticAssignmentProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSemanticAssignment";
        String assetGUIDParameter = "assetGUID";
        String glossaryTermParameter = "glossaryTermGUID";
        String assetURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings/{3}";
        String elementURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/meanings/{4}";
        this.invalidParameterHandler.validateUserId(userId, "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "addSemanticAssignment");
        if (assetElementGUID == null) {
            this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings/{3}", properties, this.serverName, userId, assetGUID, glossaryTermGUID);
        } else {
            this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/meanings/{4}", properties, this.serverName, userId, assetGUID, assetElementGUID, glossaryTermGUID);
        }
    }

    @Override
    public void removeSemanticAssignment(String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSemanticAssignment";
        String assetGUIDParameter = "assetGUID";
        String glossaryTermParameter = "glossaryTermGUID";
        String assetURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings/delete";
        String elementURLTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/meanings/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSemanticAssignment");
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, "glossaryTermGUID", "addSemanticAssignment");
        if (assetElementGUID == null) {
            this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/meanings/delete", this.nullRequestBody, this.serverName, userId, assetGUID, glossaryTermGUID);
        } else {
            this.restClient.callVoidPostRESTCall("addSemanticAssignment", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/meanings/{4}/delete", this.nullRequestBody, this.serverName, userId, assetGUID, assetElementGUID, glossaryTermGUID);
        }
    }

    @Override
    public void addAssetOrigin(String userId, String assetGUID, String organizationGUID, String businessCapabilityGUID, Map<String, String> otherOriginValues) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetOrigin";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/origin";
        this.invalidParameterHandler.validateUserId(userId, "addAssetOrigin");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addAssetOrigin");
        OriginRequestBody requestBody = new OriginRequestBody();
        requestBody.setBusinessCapabilityGUID(businessCapabilityGUID);
        requestBody.setOrganizationGUID(organizationGUID);
        requestBody.setOtherOriginValues(otherOriginValues);
        this.restClient.callVoidPostRESTCall("addAssetOrigin", urlTemplate, requestBody, this.serverName, userId, assetGUID);
    }

    @Override
    public void removeAssetOrigin(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeAssetOrigin";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/origin/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeAssetOrigin");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeAssetOrigin");
        this.restClient.callVoidPostRESTCall("removeAssetOrigin", urlTemplate, this.nullRequestBody, this.serverName, userId, assetGUID);
    }

    @Override
    public void publishAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/publish";
        this.invalidParameterHandler.validateUserId(userId, "publishAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "publishAsset");
        this.restClient.callVoidPostRESTCall("publishAsset", urlTemplate, this.nullRequestBody, this.serverName, userId, assetGUID);
    }

    @Override
    public void withdrawAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/withdraw";
        this.invalidParameterHandler.validateUserId(userId, "withdrawAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "withdrawAsset");
        this.restClient.callVoidPostRESTCall("withdrawAsset", urlTemplate, this.nullRequestBody, this.serverName, userId, assetGUID);
    }

    @Override
    public void updateAssetZones(String userId, String assetGUID, List<String> assetZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetZones";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/governance-zones";
        this.invalidParameterHandler.validateUserId(userId, "updateAssetZones");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateAssetZones");
        this.restClient.callVoidPostRESTCall("updateAssetZones", urlTemplate, assetZones, this.serverName, userId, assetGUID);
    }

    @Override
    public void updateAssetOwner(String userId, String assetGUID, String ownerId, String ownerTypeName, String ownerPropertyName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetOwner";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/owner";
        this.invalidParameterHandler.validateUserId(userId, "updateAssetOwner");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateAssetOwner");
        OwnerRequestBody requestBody = new OwnerRequestBody();
        requestBody.setOwnerId(ownerId);
        requestBody.setOwnerTypeName(ownerTypeName);
        requestBody.setOwnerPropertyName(ownerPropertyName);
        this.restClient.callVoidPostRESTCall("updateAssetOwner", urlTemplate, requestBody, this.serverName, userId, assetGUID);
    }

    @Override
    public void removeAssetOwner(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeAssetOwner";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeAssetOwner");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeAssetOwner");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/owner/delete";
        this.restClient.callVoidPostRESTCall("removeAssetOwner", urlTemplate, this.nullRequestBody, this.serverName, userId, assetGUID);
    }

    @Override
    public void addSecurityTags(String userId, String assetGUID, String assetElementGUID, List<String> securityLabels, Map<String, Object> securityProperties, Map<String, List<String>> accessGroups) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSecurityTags";
        String assetGUIDParameter = "assetGUID";
        String assetURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/security-tags";
        String elementURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/security-tags";
        this.invalidParameterHandler.validateUserId(userId, "addSecurityTags");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addSecurityTags");
        SecurityTagsRequestBody requestBody = new SecurityTagsRequestBody();
        requestBody.setSecurityLabels(securityLabels);
        requestBody.setSecurityProperties(securityProperties);
        requestBody.setAccessGroups(accessGroups);
        if (assetElementGUID == null) {
            this.restClient.callVoidPostRESTCall("addSecurityTags", assetURLTemplate, requestBody, this.serverName, userId, assetGUID);
        } else {
            this.restClient.callVoidPostRESTCall("addSecurityTags", elementURLTemplate, requestBody, this.serverName, userId, assetGUID, assetElementGUID);
        }
    }

    @Override
    public void removeSecurityTags(String userId, String assetGUID, String assetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSecurityTags";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeSecurityTags");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeSecurityTags");
        String assetURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/security-tags/delete";
        String elementURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/attachments/{3}/security-tags/delete";
        if (assetElementGUID == null) {
            this.restClient.callVoidPostRESTCall("removeSecurityTags", assetURLTemplate, this.nullRequestBody, this.serverName, userId, assetGUID);
        } else {
            this.restClient.callVoidPostRESTCall("removeSecurityTags", elementURLTemplate, this.nullRequestBody, this.serverName, userId, assetGUID, assetElementGUID);
        }
    }

    @Override
    public void addTemplateClassification(String userId, String assetGUID, String name, String versionIdentifier, String description, Map<String, String> additionalProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addTemplateClassification";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "addTemplateClassification");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addTemplateClassification");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/template-classification";
        TemplateClassificationRequestBody requestBody = new TemplateClassificationRequestBody();
        requestBody.setName(name);
        requestBody.setVersionIdentifier(versionIdentifier);
        requestBody.setDescription(description);
        requestBody.setAdditionalProperties(additionalProperties);
        this.restClient.callVoidPostRESTCall("addTemplateClassification", urlTemplate, requestBody, this.serverName, userId, assetGUID);
    }

    @Override
    public void removeTemplateClassification(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeTemplateClassification";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeTemplateClassification");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeTemplateClassification");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/template-classification/delete";
        this.restClient.callVoidPostRESTCall("removeTemplateClassification", urlTemplate, this.nullRequestBody, this.serverName, userId, assetGUID);
    }

    @Override
    public void setElementAsDataField(String userId, String elementGUID, DataFieldValuesProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public void clearElementAsDataField(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public void setConfidenceClassification(String userId, String elementGUID, GovernanceClassificationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public void clearConfidenceClassification(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public void setCriticalityClassification(String userId, String elementGUID, GovernanceClassificationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public void clearCriticalityClassification(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public void setConfidentialityClassification(String userId, String elementGUID, GovernanceClassificationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public void clearConfidentialityClassification(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public void setRetentionClassification(String userId, String elementGUID, RetentionClassificationProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public void clearRetentionClassification(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public void addGovernanceDefinitionToElement(String userId, String definitionGUID, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public void removeGovernanceDefinitionFromElement(String userId, String definitionGUID, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public String createConnection(String userId, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnection";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "connectionProperties";
        this.invalidParameterHandler.validateUserId(userId, "createConnection");
        this.invalidParameterHandler.validateObject(connectionProperties, "connectionProperties", "createConnection");
        this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "qualifiedName", "createConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnection", urlTemplate, connectionProperties, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public String createConnectionFromTemplate(String userId, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectionFromTemplate";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createConnectionFromTemplate");
        this.invalidParameterHandler.validateObject(templateProperties, "templateProperties", "createConnectionFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createConnectionFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/from-template/{2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createConnectionFromTemplate", urlTemplate, templateProperties, this.serverName, userId, templateGUID);
        return restResult.getGUID();
    }

    @Override
    public void updateConnection(String userId, String connectionGUID, boolean isMergeUpdate, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnection";
        String guidParameter = "connectionGUID";
        String propertiesParameter = "connectionProperties";
        String qualifiedNameParameter = "connectionProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "updateConnection");
        this.invalidParameterHandler.validateObject(connectionProperties, "connectionProperties", "updateConnection");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(connectionProperties.getQualifiedName(), "connectionProperties.qualifiedName", "updateConnection");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/{2}/update?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateConnection", urlTemplate, connectionProperties, this.serverName, userId, connectionGUID, isMergeUpdate);
    }

    @Override
    public void setupConnectorType(String userId, String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupConnectorType";
        String connectionGUIDParameter = "connectionGUID";
        String connectorTypeGUIDParameter = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupConnectorType");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "setupConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/{2}/connector-types/{3}";
        this.restClient.callVoidPostRESTCall("setupConnectorType", urlTemplate, this.nullRequestBody, this.serverName, userId, connectionGUID, connectorTypeGUID);
    }

    @Override
    public void clearConnectorType(String userId, String connectionGUID, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConnectorType";
        String connectionGUIDParameter = "connectionGUID";
        String connectorTypeGUIDParameter = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearConnectorType");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearConnectorType");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "clearConnectorType");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/{2}/connector-types/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearConnectorType", urlTemplate, this.nullRequestBody, this.serverName, userId, connectionGUID, connectorTypeGUID);
    }

    @Override
    public void setupEndpoint(String userId, String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEndpoint";
        String connectionGUIDParameter = "connectionGUID";
        String endpointGUIDParameter = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupEndpoint");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "setupEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/{2}/endpoints/{3}";
        this.restClient.callVoidPostRESTCall("setupEndpoint", urlTemplate, this.nullRequestBody, this.serverName, userId, connectionGUID, endpointGUID);
    }

    @Override
    public void clearEndpoint(String userId, String connectionGUID, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEndpoint";
        String connectionGUIDParameter = "connectionGUID";
        String endpointGUIDParameter = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearEndpoint");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "clearEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/{2}/endpoints/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearEndpoint", urlTemplate, this.nullRequestBody, this.serverName, userId, connectionGUID, endpointGUID);
    }

    @Override
    public void setupEmbeddedConnection(String userId, String connectionGUID, int position, String displayName, Map<String, Object> arguments, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEmbeddedConnection";
        String connectionGUIDParameter = "connectionGUID";
        String embeddedConnectionGUIDParameter = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", "setupEmbeddedConnection");
        EmbeddedConnectionRequestBody requestBody = new EmbeddedConnectionRequestBody();
        requestBody.setPosition(position);
        requestBody.setDisplayName(displayName);
        requestBody.setArguments(arguments);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/{2}/embedded-connections/{3}";
        this.restClient.callVoidPostRESTCall("setupEmbeddedConnection", urlTemplate, requestBody, this.serverName, userId, connectionGUID, embeddedConnectionGUID);
    }

    @Override
    public void clearEmbeddedConnection(String userId, String connectionGUID, String embeddedConnectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEmbeddedConnection";
        String connectionGUIDParameter = "connectionGUID";
        String embeddedConnectionGUIDParameter = "embeddedConnectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearEmbeddedConnection");
        this.invalidParameterHandler.validateGUID(embeddedConnectionGUID, "embeddedConnectionGUID", "clearEmbeddedConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/{2}/embedded-connections/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearEmbeddedConnection", urlTemplate, this.nullRequestBody, this.serverName, userId, connectionGUID, embeddedConnectionGUID);
    }

    @Override
    public void setupAssetConnection(String userId, String assetGUID, String assetSummary, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAssetConnection";
        String assetGUIDParameter = "assetGUID";
        String connectionGUIDParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "setupAssetConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "setupAssetConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "setupAssetConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/connections/{3}";
        StringRequestBody requestBody = new StringRequestBody();
        requestBody.setString(assetSummary);
        this.restClient.callVoidPostRESTCall("setupAssetConnection", urlTemplate, requestBody, this.serverName, userId, assetGUID, connectionGUID);
    }

    @Override
    public void clearAssetConnection(String userId, String assetGUID, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetConnection";
        String assetGUIDParameter = "assetGUID";
        String connectionGUIDParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "clearAssetConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "clearAssetConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "clearAssetConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/connections/{3}/delete";
        this.restClient.callVoidPostRESTCall("clearAssetConnection", urlTemplate, this.nullRequestBody, this.serverName, userId, assetGUID, connectionGUID);
    }

    @Override
    public void removeConnection(String userId, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnection";
        String guidParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "removeConnection");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/{2}/delete";
        this.restClient.callVoidPostRESTCall("removeConnection", urlTemplate, this.nullRequestBody, this.serverName, userId, connectionGUID);
    }

    @Override
    public List<ConnectionElement> findConnections(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findConnections";
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findConnections");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findConnections");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findConnections");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ConnectionsResponse restResult = this.restClient.callConnectionsPostRESTCall("findConnections", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public List<ConnectionElement> scanConnections(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "scanConnections";
        this.invalidParameterHandler.validateUserId(userId, "scanConnections");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "scanConnections");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/scan?startFrom={2}&pageSize={3}";
        ConnectionsResponse restResult = this.restClient.callConnectionsGetRESTCall("scanConnections", urlTemplate, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public List<ConnectionElement> getConnectionsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionsByName");
        this.invalidParameterHandler.validateName(name, "name", "getConnectionsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectionsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ConnectionsResponse restResult = this.restClient.callConnectionsPostRESTCall("getConnectionsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public ConnectionElement getConnectionByGUID(String userId, String connectionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionByGUID";
        String connectionGUIDParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionByGUID");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getConnectionByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connections/{2}";
        ConnectionResponse restResult = this.restClient.callMyConnectionGetRESTCall("getConnectionByGUID", urlTemplate, this.serverName, userId, connectionGUID);
        return restResult.getElement();
    }

    @Override
    public String createEndpoint(String userId, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpoint";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "endpointProperties";
        this.invalidParameterHandler.validateUserId(userId, "createEndpoint");
        this.invalidParameterHandler.validateObject(endpointProperties, "endpointProperties", "createEndpoint");
        this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "qualifiedName", "createEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/endpoints";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEndpoint", urlTemplate, endpointProperties, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public String createEndpointFromTemplate(String userId, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpointFromTemplate";
        String nameParameter = "qualifiedName";
        String propertiesParameter = "templateProperties";
        this.invalidParameterHandler.validateUserId(userId, "createEndpointFromTemplate");
        this.invalidParameterHandler.validateObject(templateProperties, "templateProperties", "createEndpointFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", "createEndpointFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/endpoints/from-template/{2}";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEndpointFromTemplate", urlTemplate, templateProperties, this.serverName, userId, templateGUID);
        return restResult.getGUID();
    }

    @Override
    public void updateEndpoint(String userId, boolean isMergeUpdate, String endpointGUID, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEndpoint";
        String guidParameter = "endpointGUID";
        String propertiesParameter = "endpointProperties";
        String qualifiedNameParameter = "endpointProperties.qualifiedName";
        if (isMergeUpdate) {
            this.invalidParameterHandler.validateName(endpointProperties.getQualifiedName(), "endpointProperties.qualifiedName", "updateEndpoint");
        }
        this.invalidParameterHandler.validateUserId(userId, "updateEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "updateEndpoint");
        this.invalidParameterHandler.validateObject(endpointProperties, "endpointProperties", "updateEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/endpoints/{2}/update?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateEndpoint", urlTemplate, endpointProperties, this.serverName, userId, endpointGUID, isMergeUpdate);
    }

    @Override
    public void removeEndpoint(String userId, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeEndpoint";
        String guidParameter = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeEndpoint");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "removeEndpoint");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/endpoints/{2}/delete";
        this.restClient.callVoidPostRESTCall("removeEndpoint", urlTemplate, this.nullRequestBody, this.serverName, userId, endpointGUID);
    }

    @Override
    public List<EndpointElement> findEndpoints(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findEndpoints";
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findEndpoints");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findEndpoints");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findEndpoints");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/endpoints/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        EndpointsResponse restResult = this.restClient.callEndpointsPostRESTCall("findEndpoints", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public List<EndpointElement> getEndpointsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointsByName");
        this.invalidParameterHandler.validateName(name, "name", "getEndpointsByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getEndpointsByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/endpoints/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        EndpointsResponse restResult = this.restClient.callEndpointsPostRESTCall("getEndpointsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public EndpointElement getEndpointByGUID(String userId, String endpointGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEndpointByGUID";
        String endpointGUIDParameter = "endpointGUID";
        this.invalidParameterHandler.validateUserId(userId, "getEndpointByGUID");
        this.invalidParameterHandler.validateGUID(endpointGUID, "endpointGUID", "getEndpointByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/endpoints/{2}";
        EndpointResponse restResult = this.restClient.callEndpointGetRESTCall("getEndpointByGUID", urlTemplate, this.serverName, userId, endpointGUID);
        return restResult.getElement();
    }

    @Override
    public List<ConnectorTypeElement> findConnectorTypes(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findConnectorTypes";
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findConnectorTypes");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findConnectorTypes");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findConnectorTypes");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connector-types/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ConnectorTypesResponse restResult = this.restClient.callConnectorTypesPostRESTCall("findConnectorTypes", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public List<ConnectorTypeElement> getConnectorTypesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypesByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypesByName");
        this.invalidParameterHandler.validateName(name, "name", "getConnectorTypesByName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getConnectorTypesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connector-types/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        ConnectorTypesResponse restResult = this.restClient.callConnectorTypesPostRESTCall("getConnectorTypesByName", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    @Override
    public ConnectorTypeElement getConnectorTypeByGUID(String userId, String connectorTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorTypeByGUID";
        String connectorTypeGUIDParameter = "connectorTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorTypeByGUID");
        this.invalidParameterHandler.validateGUID(connectorTypeGUID, "connectorTypeGUID", "getConnectorTypeByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/connector-types/{2}";
        ConnectorTypeResponse restResult = this.restClient.callMyConnectorTypeGetRESTCall("getConnectorTypeByGUID", urlTemplate, this.serverName, userId, connectorTypeGUID);
        return restResult.getElement();
    }

    @Override
    public List<AssetElement> getAssetsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-name?startFrom={2}&pageSize={3}";
        String methodName = "getAssetsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByName");
        this.invalidParameterHandler.validateName(name, "name", "getAssetsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        AssetElementsResponse restResult = this.restClient.callAssetElementsPostRESTCall("getAssetsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getAssets();
    }

    @Override
    public List<AssetElement> findAssets(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/by-search-string?startFrom={2}&pageSize={3}";
        String methodName = "findAssets";
        String searchParameter = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findAssets");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findAssets");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        AssetElementsResponse restResult = this.restClient.callAssetElementsPostRESTCall("findAssets", urlTemplate, requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getAssets();
    }

    @Override
    public AssetElement getAssetSummary(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAssetSummary";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetSummary");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getAssetSummary");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}";
        AssetElementResponse restResult = this.restClient.callAssetElementGetRESTCall("getAssetSummary", urlTemplate, this.serverName, userId, assetGUID);
        return restResult.getAsset();
    }

    @Override
    public Connector getConnectorToAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorToAsset";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getConnectorToAsset");
        try {
            return super.getConnectorForConnection(this.restClient, serviceURLName, userId, this.getConnectionForAsset(this.restClient, serviceURLName, userId, assetGUID), "getConnectorToAsset");
        }
        catch (ConnectionCheckedException error) {
            throw new InvalidParameterException(error.getReportedErrorMessage(), error, "connection to asset " + assetGUID);
        }
        catch (ConnectorCheckedException error) {
            throw new PropertyServerException(error);
        }
    }

    @Override
    public List<SurveyReport> getSurveyReports(String userId, String assetGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSurveyReports";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/survey-reports?startingFrom={4}&maximumResults={5}";
        this.invalidParameterHandler.validateUserId(userId, "getSurveyReports");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getSurveyReports");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getSurveyReports");
        SurveyReportListResponse restResult = this.restClient.callSurveyReportListGetRESTCall("getSurveyReports", urlTemplate, this.serverName, userId, assetGUID, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getSurveyReports();
    }

    @Override
    public List<String> getTypesOfAnnotation(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAnnotation";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/sub-types";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAnnotation");
        NameListResponse restResult = this.restClient.callNameListGetRESTCall("getTypesOfAnnotation", urlTemplate, this.serverName, userId);
        return restResult.getNames();
    }

    @Override
    public Map<String, String> getTypesOfAnnotationWithDescriptions(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAnnotationWithDescriptions";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/sub-types/descriptions";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAnnotationWithDescriptions");
        StringMapResponse restResult = this.restClient.callStringMapGetRESTCall("getTypesOfAnnotationWithDescriptions", urlTemplate, this.serverName, userId);
        return restResult.getStringMap();
    }

    @Override
    public List<Annotation> getSurveyReportAnnotations(String userId, String surveyReportGUID, AnnotationStatus annotationStatus, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSurveyReportAnnotations";
        String discoveryReportGUIDParameter = "surveyReportGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/survey-reports/{2}?startingFrom={3}&maxPageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getSurveyReportAnnotations");
        this.invalidParameterHandler.validateGUID(surveyReportGUID, "surveyReportGUID", "getSurveyReportAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getSurveyReportAnnotations");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setAnnotationStatus(annotationStatus);
        AnnotationListResponse restResult = this.restClient.callAnnotationListPostRESTCall("getSurveyReportAnnotations", urlTemplate, requestBody, this.serverName, userId, surveyReportGUID, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getAnnotations();
    }

    @Override
    public List<Annotation> getExtendedAnnotations(String userId, String annotationGUID, AnnotationStatus annotationStatus, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExtendedAnnotations";
        String annotationGUIDParameter = "annotationGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/annotations/{2}?startingFrom={3}&maxPageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getExtendedAnnotations");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "getExtendedAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getExtendedAnnotations");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setAnnotationStatus(annotationStatus);
        AnnotationListResponse restResult = this.restClient.callAnnotationListPostRESTCall("getExtendedAnnotations", urlTemplate, requestBody, this.serverName, userId, annotationGUID, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getAnnotations();
    }

    @Override
    public List<ElementStub> getDataFieldClassifiedElements(String userId, DataFieldQueryProperties properties, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<ElementStub> getConfidenceClassifiedElements(String userId, boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<ElementStub> getCriticalityClassifiedElements(String userId, boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<ElementStub> getConfidentialityClassifiedElements(String userId, boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<ElementStub> getRetentionClassifiedElements(String userId, boolean returnSpecificBasisIdentifier, int basisIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<ElementStub> getSecurityTaggedElements(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<ElementStub> getOwnersElements(String userId, String owner, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<AssetElement> getAssetsByOrigin(String userId, FindAssetOriginProperties properties, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<ElementStub> getMembersOfSubjectArea(String userId, String subjectAreaName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<GlossaryTermElement> getMeanings(String userId, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<RelatedElement> getSemanticAssignees(String userId, String glossaryTermGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<GovernanceDefinitionElement> getGovernedByDefinitions(String userId, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<RelatedElement> getGovernedElements(String userId, String governanceDefinitionGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<RelatedElement> getSourceElements(String userId, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<RelatedElement> getElementsSourceFrom(String userId, String elementGUID, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public void deleteAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteAsset";
        String assetGUIDParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "deleteAsset");
        this.restClient.callVoidPostRESTCall("deleteAsset", urlTemplate, this.nullRequestBody, this.serverName, userId, assetGUID);
    }

    @Override
    public List<CollectionElement> getCollections(String userId, String parentGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    @Override
    public CollectionElement getCollection(String userId, String collectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    @Override
    public List<CollectionElement> findCollections(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public List<CollectionElement> getCollectionsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    @Override
    public String createCollection(String userId, CollectionProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    @Override
    public String createFolderCollection(String userId, CollectionFolderProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    @Override
    public void updateCollection(String userId, String collectionGUID, boolean isMergeUpdate, CollectionProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    @Override
    public void removeCollection(String userId, String collectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }

    @Override
    public List<CollectionMember> getCollectionMembers(String userId, String collectionGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    @Override
    public CollectionMember getCollectionMember(String userId, String collectionGUID, String memberGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    @Override
    public List<CollectionElement> getElementsCollections(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    @Override
    public void updateCollectionMembership(String userId, String collectionGUID, CollectionMembershipProperties properties, boolean isMergeUpdate, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }

    @Override
    public void removeFromCollection(String userId, String collectionGUID, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }
}

