/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetowner.api.AssetOnboardingFileSystem;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.FileSystemElement;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.FolderElement;
import org.odpi.openmetadata.accessservices.assetowner.rest.FileSystemResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.FolderResponse;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewFileAssetRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.NewFileSystemRequestBody;
import org.odpi.openmetadata.accessservices.assetowner.rest.PathNameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class FileSystemAssetOwner
extends AssetOwner
implements AssetOnboardingFileSystem {
    public FileSystemAssetOwner(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public FileSystemAssetOwner(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public FileSystemAssetOwner(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public FileSystemAssetOwner(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public FileSystemAssetOwner(String serverName, String serverPlatformURLRoot, AssetOwnerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    @Override
    public String createFileSystemInCatalog(String userId, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, String format, String encryption, Map<String, String> additionalProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFileSystemInCatalog";
        String pathParameter = "uniqueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems";
        this.invalidParameterHandler.validateUserId(userId, "createFileSystemInCatalog");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "createFileSystemInCatalog");
        NewFileSystemRequestBody requestBody = new NewFileSystemRequestBody();
        requestBody.setUniqueName(uniqueName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setFileSystemType(type);
        requestBody.setVersion(version);
        requestBody.setPatchLevel(patchLevel);
        requestBody.setSource(source);
        requestBody.setFormat(format);
        requestBody.setEncryption(encryption);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createFileSystemInCatalog", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public List<String> createFolderStructureInCatalog(String userId, String parentGUID, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFolderStructureInCatalog";
        String pathParameter = "pathName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}";
        this.invalidParameterHandler.validateUserId(userId, "createFolderStructureInCatalog");
        this.invalidParameterHandler.validateName(pathName, "pathName", "createFolderStructureInCatalog");
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setFullPath(pathName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("createFolderStructureInCatalog", urlTemplate, requestBody, this.serverName, userId, parentGUID);
        return restResult.getGUIDs();
    }

    @Override
    public List<String> createFolderStructureInCatalog(String userId, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFolderStructureInCatalog";
        String pathParameter = "pathName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders";
        this.invalidParameterHandler.validateUserId(userId, "createFolderStructureInCatalog");
        this.invalidParameterHandler.validateName(pathName, "pathName", "createFolderStructureInCatalog");
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setFullPath(pathName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("createFolderStructureInCatalog", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUIDs();
    }

    @Override
    public void attachFolderToFileSystem(String userId, String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachFolderToFileSystem";
        String fileSystemGUIDParameter = "fileSystemGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems/{2}/folders/{3}/attach";
        this.invalidParameterHandler.validateUserId(userId, "attachFolderToFileSystem");
        this.invalidParameterHandler.validateGUID(fileSystemGUID, "fileSystemGUID", "attachFolderToFileSystem");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "attachFolderToFileSystem");
        this.restClient.callVoidPostRESTCall("attachFolderToFileSystem", urlTemplate, this.nullRequestBody, this.serverName, userId, fileSystemGUID, folderGUID);
    }

    @Override
    public void detachFolderFromFileSystem(String userId, String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachFolderFromFileSystem";
        String fileSystemGUIDParameter = "fileSystemGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems/{2}/folders/{3}/detach";
        this.invalidParameterHandler.validateUserId(userId, "detachFolderFromFileSystem");
        this.invalidParameterHandler.validateGUID(fileSystemGUID, "fileSystemGUID", "detachFolderFromFileSystem");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "detachFolderFromFileSystem");
        this.restClient.callVoidPostRESTCall("detachFolderFromFileSystem", urlTemplate, this.nullRequestBody, this.serverName, userId, fileSystemGUID, folderGUID);
    }

    @Override
    public List<String> addDataFileAssetToCatalog(String userId, String displayName, String description, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFileAssetToCatalog";
        String pathParameter = "pathName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-files";
        this.invalidParameterHandler.validateUserId(userId, "addDataFileAssetToCatalog");
        this.invalidParameterHandler.validateName(pathName, "pathName", "addDataFileAssetToCatalog");
        NewFileAssetRequestBody requestBody = new NewFileAssetRequestBody();
        requestBody.setName(displayName);
        requestBody.setDescription(description);
        requestBody.setFullPath(pathName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addDataFileAssetToCatalog", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUIDs();
    }

    @Override
    public List<String> addDataFolderAssetToCatalog(String userId, String displayName, String description, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFolderAssetToCatalog";
        String pathParameter = "pathName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/assets/data-folders";
        this.invalidParameterHandler.validateUserId(userId, "addDataFolderAssetToCatalog");
        this.invalidParameterHandler.validateName(pathName, "pathName", "addDataFolderAssetToCatalog");
        NewFileAssetRequestBody requestBody = new NewFileAssetRequestBody();
        requestBody.setName(displayName);
        requestBody.setDescription(description);
        requestBody.setFullPath(pathName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addDataFolderAssetToCatalog", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUIDs();
    }

    @Override
    public void attachDataFileAssetToFolder(String userId, String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachDataFileAssetToFolder";
        String fileGUIDParameter = "fileGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-files/{3}/attach";
        this.invalidParameterHandler.validateUserId(userId, "attachDataFileAssetToFolder");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "attachDataFileAssetToFolder");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "attachDataFileAssetToFolder");
        this.restClient.callVoidPostRESTCall("attachDataFileAssetToFolder", urlTemplate, this.nullRequestBody, this.serverName, userId, folderGUID, fileGUID);
    }

    @Override
    public void detachDataFileAssetFromFolder(String userId, String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachDataFileAssetFromFolder";
        String fileGUIDParameter = "fileGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-files/{3}/detach";
        this.invalidParameterHandler.validateUserId(userId, "detachDataFileAssetFromFolder");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "detachDataFileAssetFromFolder");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "detachDataFileAssetFromFolder");
        this.restClient.callVoidPostRESTCall("detachDataFileAssetFromFolder", urlTemplate, this.nullRequestBody, this.serverName, userId, folderGUID, fileGUID);
    }

    @Override
    public void moveDataFileInCatalog(String userId, String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "moveDataFileInCatalog";
        String fileGUIDParameter = "fileGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-files/{3}/move-to";
        this.invalidParameterHandler.validateUserId(userId, "moveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "moveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "moveDataFileInCatalog");
        this.restClient.callVoidPostRESTCall("moveDataFileInCatalog", urlTemplate, this.nullRequestBody, this.serverName, userId, folderGUID, fileGUID);
    }

    @Override
    public void moveDataFolderInCatalog(String userId, String folderGUID, String dataFolderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "moveDataFileInCatalog";
        String fileGUIDParameter = "fileGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-folders/{3}/move-to";
        this.invalidParameterHandler.validateUserId(userId, "moveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(dataFolderGUID, "fileGUID", "moveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "moveDataFileInCatalog");
        this.restClient.callVoidPostRESTCall("moveDataFileInCatalog", urlTemplate, this.nullRequestBody, this.serverName, userId, folderGUID, dataFolderGUID);
    }

    @Override
    public FileSystemElement getFileSystemByGUID(String userId, String fileSystemGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileSystemByGUID";
        String fileSystemGUIDParameter = "fileSystemGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getFileSystemByGUID");
        this.invalidParameterHandler.validateGUID(fileSystemGUID, "fileSystemGUID", "getFileSystemByGUID");
        FileSystemResponse restResult = this.restClient.callFileSystemGetRESTCall("getFileSystemByGUID", urlTemplate, this.serverName, userId, fileSystemGUID);
        return restResult.getFileSystem();
    }

    @Override
    public FileSystemElement getFileSystemByUniqueName(String userId, String uniqueName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileSystemByUniqueName";
        String nameParameter = "uniqueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems/by-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getFileSystemByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getFileSystemByUniqueName");
        FileSystemResponse restResult = this.restClient.callFileSystemGetRESTCall("getFileSystemByUniqueName", urlTemplate, this.serverName, userId, uniqueName);
        return restResult.getFileSystem();
    }

    @Override
    public List<String> getFileSystems(String userId, int startingFrom, int maxPageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileSystems";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/file-systems?startingFrom={2}&maximumResults={3}";
        this.invalidParameterHandler.validateUserId(userId, "getFileSystems");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getFileSystems", urlTemplate, this.serverName, userId, Integer.toString(startingFrom), Integer.toString(maxPageSize));
        return restResult.getGUIDs();
    }

    @Override
    public FolderElement getFolderByGUID(String userId, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileSystemByGUID";
        String folderGUIDParameter = "folderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getFileSystemByGUID");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "getFileSystemByGUID");
        FolderResponse restResult = this.restClient.callFolderGetRESTCall("getFileSystemByGUID", urlTemplate, this.serverName, userId, folderGUID);
        return restResult.getFolder();
    }

    @Override
    public FolderElement getFolderByPathName(String userId, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileSystemByUniqueName";
        String nameParameter = "pathName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/by-path-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getFileSystemByUniqueName");
        this.invalidParameterHandler.validateName(pathName, "pathName", "getFileSystemByUniqueName");
        FolderResponse restResult = this.restClient.callFolderGetRESTCall("getFileSystemByUniqueName", urlTemplate, this.serverName, userId, pathName);
        return restResult.getFolder();
    }

    @Override
    public List<String> getNestedFolders(String userId, String parentGUID, int startingFrom, int maxPageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNestedFolders";
        String anchorGUIDParameter = "anchorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/anchor/{2}/folders?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getNestedFolders");
        this.invalidParameterHandler.validateGUID(parentGUID, "anchorGUID", "getNestedFolders");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getNestedFolders", urlTemplate, this.serverName, userId, parentGUID, Integer.toString(startingFrom), Integer.toString(maxPageSize));
        return restResult.getGUIDs();
    }

    @Override
    public List<String> getFolderFiles(String userId, String folderGUID, int startingFrom, int maxPageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFolderFiles";
        String anchorGUIDParameter = "folderGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/folders/{2}/assets/data-files?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getFolderFiles");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "getFolderFiles");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getFolderFiles", urlTemplate, this.serverName, userId, folderGUID, Integer.toString(startingFrom), Integer.toString(maxPageSize));
        return restResult.getGUIDs();
    }
}

