/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetowner.client.CSVFileAssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.ConnectedAssetClient;
import org.odpi.openmetadata.accessservices.assetowner.client.FileSystemAssetOwner;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;

public class SurveyAssetStoreClient
extends SurveyAssetStore {
    private final ConnectedAssetClient connectedAssetClient;
    private final FileSystemAssetOwner fileSystemAssetOwner;
    private final CSVFileAssetOwner csvFileAssetOwner;

    public SurveyAssetStoreClient(String assetGUID, String userId, ConnectedAssetClient connectedAssetClient, FileSystemAssetOwner fileSystemAssetOwner, CSVFileAssetOwner csvFileAssetOwner) {
        super(assetGUID, userId);
        this.connectedAssetClient = connectedAssetClient;
        this.fileSystemAssetOwner = fileSystemAssetOwner;
        this.csvFileAssetOwner = csvFileAssetOwner;
    }

    @Override
    public Connector getConnectorByConnection(Connection connection) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException {
        return this.connectedAssetClient.getConnectorByConnection(this.userId, connection);
    }

    @Override
    public AssetUniverse getAssetProperties() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.connectedAssetClient.getAssetProperties(AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceFullName(), this.userId, this.assetGUID);
    }

    @Override
    public void logAssetAuditMessage(String surveyService, String message) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.connectedAssetClient.logAssetAuditMessage(this.userId, this.assetGUID, surveyService, message);
    }

    @Override
    public Connector getConnectorToAsset() throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, UserNotAuthorizedException, PropertyServerException {
        return this.connectedAssetClient.getConnectorForAsset(this.userId, this.assetGUID);
    }

    @Override
    public String addDataFileAssetToCatalog(String displayName, String description, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<String> fileAssetGUIDs = this.fileSystemAssetOwner.addDataFileAssetToCatalog(this.userId, displayName, description, pathName);
        if (fileAssetGUIDs != null && !fileAssetGUIDs.isEmpty()) {
            return fileAssetGUIDs.get(fileAssetGUIDs.size() - 1);
        }
        return null;
    }

    @Override
    public String addCSVFileToCatalog(String displayName, String description, String pathName, List<String> columnHeaders, Character delimiterCharacter, Character quoteCharacter) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<String> fileAssetGUIDs = this.csvFileAssetOwner.addCSVFileToCatalog(this.userId, displayName, description, pathName, columnHeaders, delimiterCharacter, quoteCharacter);
        if (fileAssetGUIDs != null && !fileAssetGUIDs.isEmpty()) {
            return fileAssetGUIDs.get(fileAssetGUIDs.size() - 1);
        }
        return null;
    }
}

