/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaAttributeRelationshipProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaElementProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SchemaAttributeElement.class, name="SchemaAttributeElement")})
public class SchemaAttributeProperties
extends SchemaElementProperties {
    private int elementPosition = 0;
    private int minCardinality = 0;
    private int maxCardinality = -1;
    private boolean allowsDuplicateValues = false;
    private boolean orderedValues = false;
    private String defaultValueOverride = null;
    private DataItemSortOrder sortOrder = null;
    private int minimumLength = 0;
    private int length = 0;
    private int precision = 0;
    private int significantDigits = 0;
    private boolean isNullable = true;
    private SchemaTypeProperties attributeType = null;
    private List<SchemaAttributeRelationshipProperties> attributeRelationships = null;
    private String nativeJavaClass = null;
    private List<String> aliases = null;

    public SchemaAttributeProperties() {
    }

    public SchemaAttributeProperties(SchemaAttributeProperties template) {
        super(template);
        if (template != null) {
            this.elementPosition = template.getElementPosition();
            this.minCardinality = template.getMinCardinality();
            this.maxCardinality = template.getMaxCardinality();
            this.allowsDuplicateValues = template.getAllowsDuplicateValues();
            this.orderedValues = template.getOrderedValues();
            this.sortOrder = template.getSortOrder();
            this.minimumLength = template.getMinimumLength();
            this.length = template.getLength();
            this.precision = template.getPrecision();
            this.significantDigits = template.getSignificantDigits();
            this.isNullable = template.getIsNullable();
            this.defaultValueOverride = template.getDefaultValueOverride();
            this.attributeType = template.getAttributeType();
            this.attributeRelationships = template.getAttributeRelationships();
            this.nativeJavaClass = template.getNativeJavaClass();
            this.aliases = template.getAliases();
        }
    }

    public int getElementPosition() {
        return this.elementPosition;
    }

    public void setElementPosition(int elementPosition) {
        this.elementPosition = elementPosition;
    }

    public int getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(int minCardinality) {
        this.minCardinality = minCardinality;
    }

    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(int maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public boolean getAllowsDuplicateValues() {
        return this.allowsDuplicateValues;
    }

    public void setAllowsDuplicateValues(boolean allowsDuplicateValues) {
        this.allowsDuplicateValues = allowsDuplicateValues;
    }

    public boolean getOrderedValues() {
        return this.orderedValues;
    }

    public void setOrderedValues(boolean orderedValues) {
        this.orderedValues = orderedValues;
    }

    public DataItemSortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(DataItemSortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(int minimumLength) {
        this.minimumLength = minimumLength;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getSignificantDigits() {
        return this.significantDigits;
    }

    public void setSignificantDigits(int significantDigits) {
        this.significantDigits = significantDigits;
    }

    public boolean getIsNullable() {
        return this.isNullable;
    }

    public void setIsNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    public String getDefaultValueOverride() {
        return this.defaultValueOverride;
    }

    public void setDefaultValueOverride(String defaultValueOverride) {
        this.defaultValueOverride = defaultValueOverride;
    }

    public SchemaTypeProperties getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(SchemaTypeProperties attributeType) {
        this.attributeType = attributeType;
    }

    public List<SchemaAttributeRelationshipProperties> getAttributeRelationships() {
        if (this.attributeRelationships == null) {
            return null;
        }
        if (this.attributeRelationships.isEmpty()) {
            return null;
        }
        return new ArrayList<SchemaAttributeRelationshipProperties>(this.attributeRelationships);
    }

    public void setAttributeRelationships(List<SchemaAttributeRelationshipProperties> attributeRelationships) {
        this.attributeRelationships = attributeRelationships;
    }

    public String getNativeJavaClass() {
        return this.nativeJavaClass;
    }

    public void setNativeJavaClass(String nativeJavaClass) {
        this.nativeJavaClass = nativeJavaClass;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    @Override
    public String toString() {
        return "SchemaAttributeProperties{elementPosition=" + this.elementPosition + ", minCardinality=" + this.minCardinality + ", maxCardinality=" + this.maxCardinality + ", allowsDuplicateValues=" + this.allowsDuplicateValues + ", orderedValues=" + this.orderedValues + ", defaultValueOverride='" + this.defaultValueOverride + "', sortOrder=" + this.sortOrder + ", minimumLength=" + this.minimumLength + ", length=" + this.length + ", precision=" + this.precision + ", significantDigits=" + this.significantDigits + ", isNullable=" + this.isNullable + ", attributeType=" + this.attributeType + ", attributeRelationships=" + this.attributeRelationships + ", nativeJavaClass='" + this.nativeJavaClass + "', aliases=" + this.aliases + ", displayName='" + this.getDisplayName() + "', description='" + this.getDescription() + "', isDeprecated=" + this.getIsDeprecated() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof SchemaAttributeProperties)) {
            return false;
        }
        SchemaAttributeProperties that = (SchemaAttributeProperties)objectToCompare;
        if (!super.equals(objectToCompare)) {
            return false;
        }
        return this.elementPosition == that.elementPosition && this.minCardinality == that.minCardinality && this.maxCardinality == that.maxCardinality && this.allowsDuplicateValues == that.allowsDuplicateValues && this.orderedValues == that.orderedValues && this.minimumLength == that.minimumLength && this.length == that.length && this.precision == that.precision && this.significantDigits == that.significantDigits && this.isNullable == that.isNullable && Objects.equals(this.defaultValueOverride, that.defaultValueOverride) && this.sortOrder == that.sortOrder && Objects.equals(this.attributeType, that.attributeType) && Objects.equals(this.attributeRelationships, that.attributeRelationships) && Objects.equals(this.nativeJavaClass, that.nativeJavaClass) && Objects.equals(this.aliases, that.aliases);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementPosition, this.minCardinality, this.maxCardinality, this.allowsDuplicateValues, this.orderedValues, this.defaultValueOverride, this.sortOrder, this.minimumLength, this.length, this.precision, this.significantDigits, this.isNullable, this.attributeType, this.attributeRelationships, this.nativeJavaClass, this.aliases);
    }
}

