/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetowner.rest.PagedResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetElementsResponse
extends PagedResponse {
    private List<AssetElement> assets = null;

    public AssetElementsResponse() {
    }

    public AssetElementsResponse(AssetElementsResponse template) {
        super(template);
        if (template != null) {
            this.assets = template.getAssets();
        }
    }

    public List<AssetElement> getAssets() {
        if (this.assets == null) {
            return null;
        }
        if (this.assets.isEmpty()) {
            return null;
        }
        ArrayList<AssetElement> clonedList = new ArrayList<AssetElement>();
        for (AssetElement existingElement : this.assets) {
            clonedList.add(new AssetElement(existingElement));
        }
        return clonedList;
    }

    public void setAssets(List<AssetElement> assets) {
        this.assets = assets;
    }

    @Override
    public String toString() {
        return "AssetElementsResponse{assets=" + this.assets + ", startingFromElement=" + this.getStartingFromElement() + ", relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetElementsResponse that = (AssetElementsResponse)objectToCompare;
        return Objects.equals(this.getAssets(), that.getAssets());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAssets());
    }
}

