/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetowner.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetowner.metadataelements.LicenseElement;
import org.odpi.openmetadata.accessservices.assetowner.rest.AssetOwnerOMASAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class LicenseListResponse
extends AssetOwnerOMASAPIResponse {
    private List<LicenseElement> elements = null;

    public LicenseListResponse() {
    }

    public LicenseListResponse(LicenseListResponse template) {
        super(template);
        if (template != null) {
            this.elements = template.getElements();
        }
    }

    public List<LicenseElement> getElements() {
        if (this.elements == null) {
            return null;
        }
        if (this.elements.isEmpty()) {
            return null;
        }
        return new ArrayList<LicenseElement>(this.elements);
    }

    public void setElements(List<LicenseElement> elements) {
        this.elements = elements;
    }

    @Override
    public String toString() {
        return "LicenseListResponse{elements=" + this.elements + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof LicenseListResponse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        LicenseListResponse that = (LicenseListResponse)objectToCompare;
        return Objects.equals(this.getElements(), that.getElements());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.elements, super.hashCode());
    }
}

