/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataEngineProxyConfig
extends AdminServicesConfigHeader {
    private String accessServiceRootURL = null;
    private String accessServiceServerName = null;
    private Connection dataEngineConnection = null;
    private int pollIntervalInSeconds = 60;
    private int batchWindowInSeconds = 86400;
    private boolean eventsClientEnabled = false;

    public DataEngineProxyConfig() {
    }

    public DataEngineProxyConfig(DataEngineProxyConfig template) {
        if (template != null) {
            this.accessServiceRootURL = template.accessServiceRootURL;
            this.accessServiceServerName = template.accessServiceServerName;
            this.dataEngineConnection = template.dataEngineConnection;
            this.pollIntervalInSeconds = template.pollIntervalInSeconds;
            this.batchWindowInSeconds = template.batchWindowInSeconds;
        }
    }

    public String getAccessServiceRootURL() {
        return this.accessServiceRootURL;
    }

    public void setAccessServiceRootURL(String accessServiceRootURL) {
        this.accessServiceRootURL = accessServiceRootURL;
    }

    public String getAccessServiceServerName() {
        return this.accessServiceServerName;
    }

    public void setAccessServiceServerName(String accessServiceServerName) {
        this.accessServiceServerName = accessServiceServerName;
    }

    public Connection getDataEngineConnection() {
        return this.dataEngineConnection;
    }

    public void setDataEngineConnection(Connection dataEngineConnection) {
        this.dataEngineConnection = dataEngineConnection;
    }

    public int getPollIntervalInSeconds() {
        return this.pollIntervalInSeconds;
    }

    public void setPollIntervalInSeconds(int pollIntervalInSeconds) {
        this.pollIntervalInSeconds = pollIntervalInSeconds;
    }

    public int getBatchWindowInSeconds() {
        return this.batchWindowInSeconds;
    }

    public void setBatchWindowInSeconds(int batchWindowInSeconds) {
        this.batchWindowInSeconds = batchWindowInSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataEngineProxyConfig)) {
            return false;
        }
        DataEngineProxyConfig that = (DataEngineProxyConfig)o;
        return Objects.equals(this.getAccessServiceRootURL(), that.getAccessServiceRootURL()) && Objects.equals(this.getAccessServiceServerName(), that.getAccessServiceServerName()) && Objects.equals(this.getDataEngineConnection(), that.getDataEngineConnection()) && Objects.equals(this.getPollIntervalInSeconds(), that.getPollIntervalInSeconds());
    }

    public int hashCode() {
        return Objects.hash(this.getAccessServiceRootURL(), this.getAccessServiceServerName(), this.getDataEngineConnection(), this.getPollIntervalInSeconds());
    }

    public boolean isEventsClientEnabled() {
        return this.eventsClientEnabled;
    }

    public void setEventsClientEnabled(boolean eventsClientEnabled) {
        this.eventsClientEnabled = eventsClientEnabled;
    }
}

