/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import java.util.UUID;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EngineConfig
extends AdminServicesConfigHeader {
    private String engineId = UUID.randomUUID().toString();
    private String engineQualifiedName = null;
    private String engineUserId = null;

    public EngineConfig() {
    }

    public EngineConfig(EngineConfig template) {
        super(template);
        if (template != null) {
            this.engineId = template.getEngineId();
            this.engineQualifiedName = template.getEngineQualifiedName();
            this.engineUserId = template.getEngineUserId();
        }
    }

    public String getEngineId() {
        return this.engineId;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public String getEngineQualifiedName() {
        return this.engineQualifiedName;
    }

    public void setEngineQualifiedName(String engineQualifiedName) {
        this.engineQualifiedName = engineQualifiedName;
    }

    public String getEngineUserId() {
        return this.engineUserId;
    }

    public void setEngineUserId(String engineUserId) {
        this.engineUserId = engineUserId;
    }

    public String toString() {
        return "EngineConfig{engineId=" + this.engineId + ", engineQualifiedName='" + this.engineQualifiedName + "', engineUserId='" + this.engineUserId + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        EngineConfig that = (EngineConfig)objectToCompare;
        return Objects.equals(this.engineId, that.engineId) && Objects.equals(this.engineQualifiedName, that.engineQualifiedName) && Objects.equals(this.engineUserId, that.engineUserId);
    }

    public int hashCode() {
        return Objects.hash(this.getEngineId(), this.getEngineQualifiedName(), this.getEngineUserId());
    }
}

