/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.auditlog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogReportingComponent;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AuditLogReport {
    private AuditLogReportingComponent reportingComponent = null;
    private List<AuditLogReport> childAuditLogReports = null;
    private Map<Integer, List<String>> severityIdentification = null;
    private Map<Integer, Integer> severityCount = null;

    public AuditLogReport() {
    }

    public AuditLogReport(AuditLogReport template) {
        if (template != null) {
            this.reportingComponent = template.getReportingComponent();
            this.childAuditLogReports = template.getChildAuditLogReports();
            this.severityIdentification = template.getSeverityIdentification();
            this.severityCount = template.getSeverityCount();
        }
    }

    public AuditLogReportingComponent getReportingComponent() {
        return new AuditLogReportingComponent(this.reportingComponent);
    }

    public void setReportingComponent(AuditLogReportingComponent reportingComponent) {
        this.reportingComponent = new AuditLogReportingComponent(reportingComponent);
    }

    public List<AuditLogReport> getChildAuditLogReports() {
        if (this.childAuditLogReports == null) {
            return null;
        }
        if (this.childAuditLogReports.isEmpty()) {
            return null;
        }
        ArrayList<AuditLogReport> result = new ArrayList<AuditLogReport>();
        for (AuditLogReport report : this.childAuditLogReports) {
            if (report == null) continue;
            result.add(new AuditLogReport(report));
        }
        return result;
    }

    public void setChildAuditLogReports(List<AuditLogReport> childAuditLogReports) {
        this.childAuditLogReports = childAuditLogReports;
    }

    public Map<Integer, List<String>> getSeverityIdentification() {
        if (this.severityIdentification == null) {
            return null;
        }
        if (this.severityIdentification.isEmpty()) {
            return null;
        }
        return new HashMap<Integer, List<String>>(this.severityIdentification);
    }

    public void setSeverityIdentification(Map<Integer, List<String>> severityIdentification) {
        this.severityIdentification = severityIdentification;
    }

    public Map<Integer, Integer> getSeverityCount() {
        if (this.severityCount == null) {
            return null;
        }
        if (this.severityCount.isEmpty()) {
            return null;
        }
        return new HashMap<Integer, Integer>(this.severityCount);
    }

    public void setSeverityCount(Map<Integer, Integer> severityCount) {
        this.severityCount = severityCount;
    }

    public String toString() {
        return "AuditLogReport{reportingComponent=" + this.reportingComponent + ", childAuditLogReports=" + this.childAuditLogReports + ", severityIdentification=" + this.severityIdentification + ", severityCount=" + this.severityCount + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        AuditLogReport that = (AuditLogReport)objectToCompare;
        return Objects.equals(this.reportingComponent, that.reportingComponent) && Objects.equals(this.childAuditLogReports, that.childAuditLogReports) && Objects.equals(this.severityIdentification, that.severityIdentification) && Objects.equals(this.severityCount, that.severityCount);
    }

    public int hashCode() {
        return Objects.hash(this.reportingComponent, this.childAuditLogReports, this.severityIdentification, this.severityCount);
    }
}

