/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.SecretsStoreConnector;
import org.odpi.openmetadata.frameworks.connectors.SecureConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectedAssetProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.Connections;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectorBase
extends Connector
implements SecureConnectorExtension {
    protected String connectorInstanceId = null;
    protected ConnectionProperties connectionProperties = null;
    protected Connection connectionBean = null;
    protected ConnectedAssetProperties connectedAssetProperties = null;
    protected Map<String, SecretsStoreConnector> secretsStoreConnectorMap = new HashMap<String, SecretsStoreConnector>();
    private volatile boolean isActive = false;
    private static final Logger log = LoggerFactory.getLogger(ConnectorBase.class);
    private final int hashCode = UUID.randomUUID().hashCode();

    public ConnectorBase() {
        log.debug("New Connector Requested");
    }

    @Override
    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        this.connectorInstanceId = connectorInstanceId;
        this.connectionProperties = connectionProperties;
        ProtectedConnection protectedConnection = new ProtectedConnection(connectionProperties);
        this.connectionBean = protectedConnection.getConnectionBean();
        log.debug("New Connector initialized: " + connectorInstanceId + ", " + connectionProperties.getQualifiedName() + "," + connectionProperties.getDisplayName());
    }

    @Override
    public String getConnectorInstanceId() {
        return this.connectorInstanceId;
    }

    @Override
    public ConnectionProperties getConnection() {
        return this.connectionProperties;
    }

    @Override
    public void initializeConnectedAssetProperties(ConnectedAssetProperties connectedAssetProperties) {
        this.connectedAssetProperties = connectedAssetProperties;
    }

    @Override
    public void initializeSecretsStoreConnector(String displayName, SecretsStoreConnector secretsStoreConnector) {
        if (displayName != null) {
            this.secretsStoreConnectorMap.put(displayName, secretsStoreConnector);
        } else {
            this.secretsStoreConnectorMap.put(String.valueOf(this.secretsStoreConnectorMap.size()), secretsStoreConnector);
        }
    }

    @Override
    public ConnectedAssetProperties getConnectedAssetProperties(String userId) throws PropertyServerException, UserNotAuthorizedException {
        log.debug("ConnectedAssetProperties requested: " + this.connectorInstanceId + ", " + this.connectionProperties.getQualifiedName() + "," + this.connectionProperties.getDisplayName());
        if (this.connectedAssetProperties != null) {
            this.connectedAssetProperties.refresh();
        }
        return this.connectedAssetProperties;
    }

    @Override
    public synchronized void start() throws ConnectorCheckedException {
        this.isActive = true;
    }

    protected Map<String, String> getSuppliedPlaceholderProperties(Map<String, Object> configurationProperties) {
        if (configurationProperties != null) {
            HashMap<String, String> placeholderProperties = new HashMap<String, String>();
            for (String configurationPropertyName : configurationProperties.keySet()) {
                if (configurationProperties.get(configurationPropertyName) == null) {
                    placeholderProperties.put(configurationPropertyName, null);
                    continue;
                }
                placeholderProperties.put(configurationPropertyName, configurationProperties.get(configurationPropertyName).toString());
            }
            if (!placeholderProperties.isEmpty()) {
                return placeholderProperties;
            }
        }
        return null;
    }

    protected List<String> getArrayConfigurationProperty(String propertyName, Map<String, Object> configurationProperties) {
        if (configurationProperties != null && configurationProperties.containsKey(propertyName)) {
            Object arrayOption = configurationProperties.get(propertyName);
            String[] options = arrayOption.toString().split(",");
            return new ArrayList<String>(Arrays.asList(options));
        }
        return null;
    }

    protected boolean getBooleanConfigurationProperty(String propertyName, Map<String, Object> configurationProperties) {
        if (configurationProperties != null && configurationProperties.containsKey(propertyName)) {
            Object booleanOption = configurationProperties.get(propertyName);
            return !"FALSE".equals(booleanOption) && !"false".equals(booleanOption) && !"False".equals(booleanOption);
        }
        return false;
    }

    protected int getIntConfigurationProperty(String propertyName, Map<String, Object> configurationProperties) {
        Object integerOption;
        if (configurationProperties != null && configurationProperties.get(propertyName) != null && (integerOption = configurationProperties.get(propertyName)) != null) {
            return Integer.parseInt(integerOption.toString());
        }
        return 0;
    }

    protected String getStringConfigurationProperty(String propertyName, Map<String, Object> configurationProperties) {
        if (configurationProperties != null && configurationProperties.get(propertyName) != null) {
            return configurationProperties.get(propertyName).toString();
        }
        return null;
    }

    protected void throwNoAsset(String assetGUID, String connectorName, String methodName) throws ConnectorCheckedException {
        throw new ConnectorCheckedException(OCFErrorCode.NO_ASSET.getMessageDefinition(assetGUID, connectorName), this.getClass().getName(), methodName);
    }

    protected void throwWrongTypeOfAsset(String assetGUID, String assetType, String supportedAssetType, String connectorName, String methodName) throws ConnectorCheckedException {
        throw new ConnectorCheckedException(OCFErrorCode.INVALID_ASSET_TYPE.getMessageDefinition(assetGUID, assetType, connectorName, supportedAssetType), this.getClass().getName(), methodName);
    }

    protected void throwWrongTypeOfResource(String assetGUID, String assetTypeName, String assetResourceName, String assetResourceType, String supportedResourceType, String connectorName, String methodName) throws ConnectorCheckedException {
        throw new ConnectorCheckedException(OCFErrorCode.INVALID_RESOURCE.getMessageDefinition(assetTypeName, assetGUID, assetResourceName, assetResourceType, connectorName, supportedResourceType), this.getClass().getName(), methodName);
    }

    protected void throwMissingResource(String assetGUID, String assetTypeName, String assetResourceName, String methodName) throws ConnectorCheckedException {
        throw new ConnectorCheckedException(OCFErrorCode.NO_RESOURCE.getMessageDefinition(assetTypeName, assetGUID, assetResourceName), this.getClass().getName(), methodName);
    }

    protected void throwWrongTypeOfRootSchema(String assetGUID, String rootSchemaType, String supportedRootSchemaType, String connectorName, String methodName) throws ConnectorCheckedException {
        throw new ConnectorCheckedException(OCFErrorCode.INVALID_ROOT_SCHEMA_TYPE.getMessageDefinition(assetGUID, rootSchemaType, connectorName, supportedRootSchemaType), this.getClass().getName(), methodName);
    }

    protected String getAssetTypeName(AssetUniverse asset, String connectorName, String methodName) throws ConnectorCheckedException {
        ElementType elementType = asset.getType();
        if (elementType != null) {
            return elementType.getTypeName();
        }
        throw new ConnectorCheckedException(OCFErrorCode.NO_ASSET_TYPE.getMessageDefinition(asset.toString(), connectorName), this.getClass().getName(), methodName);
    }

    protected List<String> getNetworkAddresses(AssetUniverse asset) {
        Connections connections;
        if (asset != null && (connections = asset.getConnections()) != null) {
            ArrayList<String> networkAddresses = new ArrayList<String>();
            while (connections.hasNext()) {
                Endpoint endpointProperties;
                Connection connectionProperties = connections.next();
                if (connectionProperties == null || (endpointProperties = connectionProperties.getEndpoint()) == null || endpointProperties.getAddress() == null || networkAddresses.contains(endpointProperties.getAddress())) continue;
                networkAddresses.add(endpointProperties.getAddress());
            }
            if (!networkAddresses.isEmpty()) {
                return networkAddresses;
            }
        }
        return null;
    }

    @Override
    public synchronized void disconnect() throws ConnectorCheckedException {
        this.isActive = false;
    }

    protected void disconnectConnectors(List<Connector> activeConnectors) {
        if (activeConnectors != null) {
            for (Connector embeddedConnector : activeConnectors) {
                if (embeddedConnector == null) continue;
                try {
                    embeddedConnector.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectorBase that = (ConnectorBase)object;
        return this.hashCode == that.hashCode;
    }

    public String toString() {
        return "ConnectorBase{connectorInstanceId='" + this.connectorInstanceId + "', connectionProperties=" + this.connectionProperties + ", connectedAssetProperties=" + this.connectedAssetProperties + ", isActive=" + this.isActive + ", hashCode=" + this.hashCode + "}";
    }

    protected static class ProtectedConnection
    extends ConnectionProperties {
        ProtectedConnection(ConnectionProperties templateConnection) {
            super(templateConnection);
        }

        @Override
        protected Connection getConnectionBean() {
            return super.getConnectionBean();
        }
    }
}

