/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.connectors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetIntegrator;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFAuditCode;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFErrorCode;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.properties.RequestedCatalogTarget;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public abstract class IntegrationConnectorBase
extends ConnectorBase
implements IntegrationConnector,
AuditLoggingComponent,
VirtualConnectorExtension {
    protected AuditLog auditLog = null;
    protected String connectorName = null;
    protected IntegrationContext integrationContext = null;
    protected List<Connector> embeddedConnectors = null;
    private final PropertyHelper propertyHelper = new PropertyHelper();

    @Override
    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    @Override
    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    @Override
    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    @Override
    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    @Override
    public void setContext(IntegrationContext integrationContext) {
        this.integrationContext = integrationContext;
    }

    protected void refreshCatalogTargets(CatalogTargetIntegrator catalogTargetIntegrator) throws ConnectorCheckedException {
        String methodName = "refreshCatalogTargets";
        try {
            int startFrom = 0;
            int catalogTargetCount = 0;
            List<CatalogTarget> catalogTargetList = this.integrationContext.getCatalogTargets(startFrom, this.integrationContext.getMaxPageSize());
            while (catalogTargetList != null) {
                for (CatalogTarget catalogTarget : catalogTargetList) {
                    boolean savedExternalSourceIsHome = this.integrationContext.getExternalSourceIsHome();
                    String savedMetadataSourceQualifiedName = this.integrationContext.getMetadataSourceQualifiedName();
                    if (catalogTarget != null && super.isActive()) {
                        ++catalogTargetCount;
                        if (catalogTarget.getMetadataSourceQualifiedName() == null) {
                            this.integrationContext.setExternalSourceIsHome(false);
                        } else {
                            this.integrationContext.setMetadataSourceQualifiedName(catalogTarget.getMetadataSourceQualifiedName());
                            this.integrationContext.setExternalSourceIsHome(true);
                        }
                        RequestedCatalogTarget requestedCatalogTarget = new RequestedCatalogTarget(catalogTarget);
                        Map<String, Object> configurationProperties = this.connectionProperties.getConfigurationProperties();
                        if (catalogTarget.getConfigurationProperties() != null) {
                            if (configurationProperties == null) {
                                configurationProperties = new HashMap<String, Object>();
                            }
                            configurationProperties.putAll(catalogTarget.getConfigurationProperties());
                        }
                        requestedCatalogTarget.setConfigurationProperties(configurationProperties);
                        if (this.propertyHelper.isTypeOf(catalogTarget.getCatalogTargetElement(), OpenMetadataType.ASSET.typeName)) {
                            requestedCatalogTarget.setCatalogTargetConnector(this.integrationContext.getConnectedAssetContext().getConnectorToAsset(catalogTarget.getCatalogTargetElement().getGUID()));
                        }
                        this.auditLog.logMessage("refreshCatalogTargets", OIFAuditCode.REFRESHING_CATALOG_TARGET.getMessageDefinition(this.connectorName, requestedCatalogTarget.getCatalogTargetName()));
                        catalogTargetIntegrator.integrateCatalogTarget(requestedCatalogTarget);
                    }
                    this.integrationContext.setExternalSourceIsHome(savedExternalSourceIsHome);
                    this.integrationContext.setMetadataSourceQualifiedName(savedMetadataSourceQualifiedName);
                }
                catalogTargetList = this.integrationContext.getCatalogTargets(startFrom += this.integrationContext.getMaxPageSize(), this.integrationContext.getMaxPageSize());
                if (catalogTargetCount == 0) {
                    this.auditLog.logMessage("refreshCatalogTargets", OIFAuditCode.NO_CATALOG_TARGETS.getMessageDefinition(this.connectorName));
                    continue;
                }
                this.auditLog.logMessage("refreshCatalogTargets", OIFAuditCode.REFRESHED_CATALOG_TARGETS.getMessageDefinition(this.connectorName, Integer.toString(catalogTargetCount)));
            }
        }
        catch (ConnectorCheckedException exception) {
            throw exception;
        }
        catch (Exception exception) {
            this.auditLog.logException("refreshCatalogTargets", OIFAuditCode.GET_CATALOG_TARGET_EXCEPTION.getMessageDefinition(exception.getClass().getName(), this.connectorName, exception.getMessage()), exception);
        }
    }

    @Override
    public void engage() throws ConnectorCheckedException {
        String actionDescription = "Calling default engage() method";
        throw new ConnectorCheckedException(OIFErrorCode.ENGAGE_IMPLEMENTATION_MISSING.getMessageDefinition(this.connectorName), this.getClass().getName(), "Calling default engage() method");
    }

    @Override
    public synchronized void disconnect() throws ConnectorCheckedException {
        super.disconnectConnectors(this.embeddedConnectors);
        super.disconnect();
    }
}

