/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.integration.controls.CatalogTargetType;

public enum CatalogTargetEnum {
    EXAMPLE("exampleCatalogTargetName", "Asset", "General Asset", null);

    private final String name;
    private final String typeName;
    private final String deployedImplementationType;
    private final Map<String, String> otherPropertyValues;

    private CatalogTargetEnum(String name, String typeName, String deployedImplementationType, Map<String, String> otherPropertyValues) {
        this.name = name;
        this.typeName = typeName;
        this.deployedImplementationType = deployedImplementationType;
        this.otherPropertyValues = otherPropertyValues;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public Map<String, String> getOtherPropertyValues() {
        return this.otherPropertyValues;
    }

    public static List<CatalogTargetType> getCatalogTargetTypes() {
        ArrayList<CatalogTargetType> catalogTargetTypes = new ArrayList<CatalogTargetType>();
        for (CatalogTargetEnum catalogTargetEnum : CatalogTargetEnum.values()) {
            catalogTargetTypes.add(catalogTargetEnum.getCatalogTargetType());
        }
        return catalogTargetTypes;
    }

    public CatalogTargetType getCatalogTargetType() {
        CatalogTargetType catalogTargetType = new CatalogTargetType();
        catalogTargetType.setName(this.name);
        catalogTargetType.setTypeName(this.typeName);
        catalogTargetType.setDeployedImplementationType(this.deployedImplementationType);
        catalogTargetType.setOtherPropertyValues(this.otherPropertyValues);
        return catalogTargetType;
    }

    public String toString() {
        return "CatalogTargetEnum{catalogTargetName='" + this.name + "'}";
    }
}

