/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum MediaType implements OpenMetadataEnum
{
    IMAGE(0, 0, "Image", "The media is an image."),
    AUDIO(1, 1, "Audio", "The media is an audio recording."),
    DOCUMENT(2, 2, "Document", "The media is a text document - probably rich text."),
    VIDEO(3, 3, "Video", "The media is a video recording."),
    OTHER(99, 99, "Other", "The media type is not supported.");

    private static final String ENUM_TYPE_GUID = "9548390c-69f5-4dc6-950d-6fdffb257b56";
    private static final String ENUM_TYPE_NAME = "MediaType";
    private static final String ENUM_DESCRIPTION = "Defines the type of media.";
    private static final String ENUM_DESCRIPTION_GUID = "7d2d2830-d95b-4d9e-8f46-26f5eace592b";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/0/0015-Linked-Media-Types/";
    private final int openTypeOrdinal;
    private final int ordinal;
    private final String name;
    private final String description;

    private MediaType(int ordinal, int openTypeOrdinal, String name, String description) {
        this.ordinal = ordinal;
        this.openTypeOrdinal = openTypeOrdinal;
        this.name = name;
        this.description = description;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return null;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public String toString() {
        return "MediaType{mediaTypeCode=" + this.ordinal + ", mediaTypeName='" + this.name + "', mediaTypeDescription='" + this.description + "'}";
    }
}

