/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum MediaUsage implements OpenMetadataEnum
{
    ICON(0, 0, "Icon", "Provides a small image to represent the asset in tree views and graphs."),
    THUMBNAIL(1, 1, "Thumbnail", "Provides a small image about the asset that can be used in lists."),
    ILLUSTRATION(2, 2, "Illustration", "Illustrates how the asset works or what it contains. It is complementary to the asset's description."),
    USAGE_GUIDANCE(3, 3, "Usage Guidance", "Provides guidance to a person on how to use the asset."),
    OTHER(99, 99, "Other", "Another usage.");

    private static final String ENUM_TYPE_GUID = "c6861a72-7485-48c9-8040-876f6c342b61";
    private static final String ENUM_TYPE_NAME = "MediaUsage";
    private static final String ENUM_DESCRIPTION = "Defines how a related media reference should be used.";
    private static final String ENUM_DESCRIPTION_GUID = "55f8bcb1-2cd5-4965-859c-62cd083985ce";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/0/0015-Linked-Media-Types/";
    private final int openTypeOrdinal;
    private final int ordinal;
    private final String name;
    private final String description;

    private MediaUsage(int ordinal, int openTypeOrdinal, String name, String description) {
        this.ordinal = ordinal;
        this.openTypeOrdinal = openTypeOrdinal;
        this.name = name;
        this.description = description;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return null;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String toString() {
        return "MediaUsage{mediaUsageCode=" + this.ordinal + ", mediaUsageName='" + this.name + "', mediaUsageDescription='" + this.description + "'}";
    }
}

