/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.refdata;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public enum ProjectStatus {
    NEW("New", "The project has just been created."),
    ACTIVE("Active", "The project is currently being worked on by the project team."),
    COMPLETED("Completed", "Work on the project has finished, and all deliverables have either been completed, abandoned or moved to a different project."),
    CANCELLED("Cancelled", "Work on the project will not continue despite incomplete deliverables.  This may be due to a change in direction or a road block that is preventing further progress."),
    ON_HOLD("On Hold", "The project has not finished, and work on the project has been temporarily suspended.");

    private final String name;
    private final String description;

    private ProjectStatus(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(null, OpenMetadataProperty.PROJECT_STATUS.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(null, OpenMetadataProperty.PROJECT_STATUS.name, null);
    }

    public String toString() {
        return "ProjectStatus{" + this.name + "}";
    }
}

