/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;

public enum SAFAuditCode implements AuditLogMessageSet
{
    DISCONNECT_DETECTED("SAF-CONNECTOR-0001", AuditLogRecordSeverityLevel.INFO, "The {0} survey action service has been disconnected - either due to its own actions or a cancel request", "The survey action framework will attempt to stop the work of the survey action framework", "Monitor the shutdown of the survey action service."),
    WRONG_TYPE_OF_CONNECTOR("OCF-CONNECTION-400-011", AuditLogRecordSeverityLevel.ERROR, "The {0} Survey Acton Service has been supplied with a resource connector of class {1} rather than class {2} for asset {3}", "The survey is unable to continue since it is unable to work with the supplied connector.", "Use the details from the error message to determine the class of the connector.  Update the connector type associated with its Connection in the metadata store.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private SAFAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    @Override
    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    @Override
    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "SAFAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

