/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Note;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.NoteLogHeader;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.OCFOMASAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class NoteLogResponse
extends OCFOMASAPIResponse {
    private NoteLogHeader noteLog = null;
    private List<Note> notes = null;

    public NoteLogResponse() {
    }

    public NoteLogResponse(NoteLogResponse template) {
        super(template);
        if (template != null) {
            this.noteLog = template.getNoteLog();
            this.notes = template.getNotes();
        }
    }

    public NoteLogHeader getNoteLog() {
        return this.noteLog;
    }

    public void setNoteLog(NoteLogHeader noteLog) {
        this.noteLog = noteLog;
    }

    public List<Note> getNotes() {
        if (this.notes == null) {
            return null;
        }
        if (this.notes.isEmpty()) {
            return null;
        }
        return new ArrayList<Note>(this.notes);
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    @Override
    public String toString() {
        return "NoteLogResponse{noteLog=" + this.noteLog + ", notes=" + this.notes + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        NoteLogResponse that = (NoteLogResponse)objectToCompare;
        return Objects.equals(this.getNoteLog(), that.getNoteLog()) && Objects.equals(this.getNotes(), that.getNotes());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNoteLog(), this.getNotes());
    }
}

